/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.Buffer;

public class ColumnInformation {
    private static final int[] maxCharlen = new int[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 3, 1, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int lazyPositionFromEnd = 0;
    Buffer buffer;
    private short charsetNumber;
    private long length;
    private ColumnType type;
    private byte decimals;
    private short flags;

    public ColumnInformation(ColumnType type) {
        this.type = type;
    }

    public ColumnInformation(Buffer buffer) {
        this.buffer = buffer;
        if (lazyPositionFromEnd == 0) {
            buffer.skipLengthEncodedBytes();
            buffer.skipLengthEncodedBytes();
            buffer.skipLengthEncodedBytes();
            buffer.skipLengthEncodedBytes();
            buffer.skipLengthEncodedBytes();
            buffer.skipLengthEncodedBytes();
            buffer.readByte();
            lazyPositionFromEnd = buffer.limit - buffer.position;
        } else {
            buffer.position = buffer.limit - lazyPositionFromEnd;
        }
        this.charsetNumber = buffer.readShort();
        this.length = buffer.readInt();
        this.type = ColumnType.fromServer(buffer.readByte() & 0xFF);
        this.flags = buffer.readShort();
        this.decimals = buffer.readByte();
        int sqlType = this.type.getSqlType();
        if (!(sqlType != 2004 && sqlType != -3 && sqlType != -2 && sqlType != -4 || this.isBinary())) {
            this.type = ColumnType.VARCHAR;
        }
    }

    public static ColumnInformation create(String name, ColumnType type) {
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (i = 0; i < 4; ++i) {
                baos.write(new byte[]{1, 0});
            }
            for (i = 0; i < 2; ++i) {
                baos.write(new byte[]{(byte)name.length()});
                baos.write(name.getBytes());
            }
            baos.write(12);
            baos.write(new byte[]{33, 0});
            int len = 1;
            switch (type.getSqlType()) {
                case 1: 
                case 12: {
                    len = 192;
                    break;
                }
                case 5: {
                    len = 5;
                    break;
                }
                case 0: {
                    len = 0;
                    break;
                }
                default: {
                    len = 1;
                }
            }
            baos.write(new byte[]{(byte)len, 0, 0, 0});
            baos.write(ColumnType.toServer(type.getSqlType()).getType());
            baos.write(new byte[]{0, 0});
            baos.write(0);
            baos.write(new byte[]{0, 0});
            return new ColumnInformation(new Buffer(baos.toByteArray()));
        }
        catch (IOException ioe) {
            throw new RuntimeException("unexpected condition", ioe);
        }
    }

    private String getString(int idx) {
        try {
            this.buffer.position = 0;
            for (int i = 0; i < idx; ++i) {
                this.buffer.skipLengthEncodedBytes();
            }
            return new String(this.buffer.getLengthEncodedBytes(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("this does not happen", e);
        }
    }

    public String getCatalog() {
        return null;
    }

    public String getDb() {
        return this.getString(1);
    }

    public String getTable() {
        return this.getString(2);
    }

    public String getOriginalTable() {
        return this.getString(3);
    }

    public String getName() {
        return this.getString(4);
    }

    public String getOriginalName() {
        return this.getString(5);
    }

    public short getCharsetNumber() {
        return this.charsetNumber;
    }

    public long getLength() {
        return this.length;
    }

    public long getPrecision() {
        switch (this.type) {
            case OLDDECIMAL: 
            case DECIMAL: {
                if (this.isSigned()) {
                    return this.length - (long)(this.decimals > 0 ? 2 : 1);
                }
                return this.length - (long)(this.decimals > 0 ? 1 : 0);
            }
        }
        return this.length;
    }

    public int getDisplaySize() {
        int vtype = this.type.getSqlType();
        if (vtype == 12 || vtype == 1) {
            int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
            if (maxWidth == 0) {
                maxWidth = 1;
            }
            return (int)this.length / maxWidth;
        }
        return (int)this.length;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public ColumnType getColumnType() {
        return this.type;
    }

    public short getFlags() {
        return this.flags;
    }

    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    public boolean isNotNull() {
        return (this.flags & 1) > 0;
    }

    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this.flags & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this.flags & 8) > 0;
    }

    public boolean isBlob() {
        return (this.flags & 0x10) > 0;
    }

    public void setUnsigned() {
        this.flags = (short)(this.flags | 0x20);
    }

    public boolean isZeroFill() {
        return (this.flags & 0x40) > 0;
    }

    public boolean isBinary() {
        return this.getCharsetNumber() == 63;
    }
}

