/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.ResultSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.CmdInformation;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class CmdInformationRewrite
implements CmdInformation {
    private Deque<Long> insertIds;
    private Deque<Integer> updateCounts;
    private int insertIdNumber = 0;
    private int expectedSize;
    private boolean hasException;
    private int autoIncrement;

    public CmdInformationRewrite(int expectedSize) {
        this.expectedSize = expectedSize;
        this.insertIds = new ArrayDeque<Long>(expectedSize);
        this.updateCounts = new ArrayDeque<Integer>(expectedSize);
        this.hasException = false;
    }

    @Override
    public void addStats(int updateCount) {
        this.hasException = true;
        this.updateCounts.add(updateCount);
    }

    @Override
    public void addStats(int updateCount, long insertId) {
        if (insertId != 0L) {
            this.insertIds.add(insertId);
            this.insertIdNumber += updateCount;
            this.updateCounts.add(updateCount);
        }
    }

    @Override
    public int[] getUpdateCounts() {
        int[] ret = new int[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3 : -2);
        return ret;
    }

    @Override
    public int getUpdateCount() {
        return this.hasException ? -3 : -2;
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator<Long> iterator = this.insertIds.iterator();
        for (int updateCount : this.updateCounts) {
            if (updateCount == -3) continue;
            long insertId = iterator.next();
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return MariaSelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        if (this.updateCounts.pollFirst() != null) {
            return this.isCurrentUpdateCount();
        }
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        Integer updateCount = this.updateCounts.peekFirst();
        return updateCount == null ? false : -1 != updateCount;
    }

    void setAutoIncrement(int autoIncrement) {
        this.autoIncrement = autoIncrement;
    }
}

