/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.ComStmtPrepare;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.protocol.AsyncMultiRead;
import org.mariadb.jdbc.internal.protocol.AsyncMultiReadResult;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.Results;
import org.mariadb.jdbc.internal.stream.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.BulkStatus;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public abstract class AbstractMultiSend {
    private static final ThreadPoolExecutor readScheduler = SchedulerServiceProviderHolder.getBulkScheduler();
    private Protocol protocol;
    private PacketOutputStream writer;
    private Results results;
    private List<ParameterHolder[]> parametersList;
    private PrepareResult prepareResult;
    private List<String> queries;
    private boolean binaryProtocol;
    private boolean readPrepareStmtResult;
    private String sql;
    int statementId = -1;
    MariaDbType[] parameterTypeHeader;

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, ServerPrepareResult serverPrepareResult, List<ParameterHolder[]> parametersList, boolean readPrepareStmtResult, String sql) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.prepareResult = serverPrepareResult;
        this.parametersList = parametersList;
        this.binaryProtocol = true;
        this.readPrepareStmtResult = readPrepareStmtResult;
        this.sql = sql;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> parametersList) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.prepareResult = clientPrepareResult;
        this.parametersList = parametersList;
        this.binaryProtocol = false;
        this.readPrepareStmtResult = false;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, List<String> queries) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.queries = queries;
        this.binaryProtocol = false;
        this.readPrepareStmtResult = false;
    }

    public abstract void sendCmd(PacketOutputStream var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, BulkStatus var6, PrepareResult var7) throws QueryException, IOException;

    public abstract QueryException handleResultException(QueryException var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, int var6, int var7, PrepareResult var8) throws QueryException;

    public abstract int getParamCount();

    public abstract int getTotalExecutionNumber();

    public PrepareResult getPrepareResult() {
        return this.prepareResult;
    }

    public PrepareResult executeBatch() throws QueryException {
        int paramCount = this.getParamCount();
        if (this.binaryProtocol) {
            if (this.readPrepareStmtResult) {
                this.parameterTypeHeader = new MariaDbType[paramCount];
                if (this.prepareResult == null && this.protocol.getOptions().cachePrepStmts) {
                    String key = this.protocol.getDatabase() + "-" + this.sql;
                    this.prepareResult = (PrepareResult)this.protocol.prepareStatementCache().get(key);
                    if (this.prepareResult != null && !((ServerPrepareResult)this.prepareResult).incrementShareCounter()) {
                        this.prepareResult = null;
                    }
                }
                this.statementId = this.prepareResult == null ? -1 : ((ServerPrepareResult)this.prepareResult).getStatementId();
            } else if (this.prepareResult != null) {
                this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
            }
        }
        return this.executeBatchStandard(paramCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrepareResult executeBatchStandard(int paramCount) throws QueryException {
        int totalExecutionNumber = this.getTotalExecutionNumber();
        QueryException exception = null;
        BulkStatus status = new BulkStatus();
        ComStmtPrepare comStmtPrepare = null;
        FutureTask<AsyncMultiReadResult> futureReadTask = null;
        try {
            do {
                status.sendSubCmdCounter = 0;
                int requestNumberByBulk = Math.min(totalExecutionNumber - status.sendCmdCounter, this.protocol.getOptions().useBatchMultiSendNumber);
                this.protocol.changeSocketTcpNoDelay(false);
                if (this.readPrepareStmtResult && this.prepareResult == null) {
                    comStmtPrepare = new ComStmtPrepare(this.protocol, this.sql);
                    comStmtPrepare.send(this.writer);
                    this.prepareResult = comStmtPrepare.read(this.protocol.getPacketFetcher());
                    this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
                    paramCount = this.getParamCount();
                }
                while (status.sendSubCmdCounter < requestNumberByBulk) {
                    this.sendCmd(this.writer, this.results, this.parametersList, this.queries, paramCount, status, this.prepareResult);
                    ++status.sendSubCmdCounter;
                    ++status.sendCmdCounter;
                    if (futureReadTask != null) continue;
                    futureReadTask = new FutureTask<AsyncMultiReadResult>(new AsyncMultiRead(comStmtPrepare, requestNumberByBulk, status.sendCmdCounter - 1, this.protocol, false, this, paramCount, this.binaryProtocol, this.results, this.parametersList, this.queries, this.prepareResult));
                    readScheduler.execute(futureReadTask);
                }
                this.protocol.changeSocketTcpNoDelay(this.protocol.getOptions().tcpNoDelay);
                try {
                    AsyncMultiReadResult asyncMultiReadResult = (AsyncMultiReadResult)futureReadTask.get();
                    if (this.binaryProtocol && this.prepareResult == null && asyncMultiReadResult.getPrepareResult() != null) {
                        this.prepareResult = asyncMultiReadResult.getPrepareResult();
                        this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
                        paramCount = this.prepareResult.getParamCount();
                    }
                    if (asyncMultiReadResult.getException() != null) {
                        if (this.readPrepareStmtResult && this.prepareResult == null || !this.protocol.getOptions().continueBatchOnError) {
                            throw asyncMultiReadResult.getException();
                        }
                        exception = asyncMultiReadResult.getException();
                    }
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() == null) {
                        throw new QueryException("Error reading results " + executionException.getMessage());
                    }
                    throw new QueryException("Error reading results " + executionException.getCause().getMessage());
                }
                catch (InterruptedException executionException) {
                }
                finally {
                    this.protocol.forceReleaseWaitingPrepareStatement();
                }
                futureReadTask = null;
            } while (status.sendCmdCounter < totalExecutionNumber);
            if (exception != null) {
                throw exception;
            }
            PrepareResult executionException = this.prepareResult;
            return executionException;
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.protocol.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.writer.releaseBufferIfNotLogging();
        }
    }
}

