/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.stream.MariaDbInputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class TextRowPacket
implements RowPacket {
    private final int columnInformationLength;

    public TextRowPacket(int columnInformationLength) {
        this.columnInformationLength = columnInformationLength;
    }

    @Override
    public byte[][] getRow(ReadPacketFetcher packetFetcher, Buffer buffer) throws IOException {
        byte[][] valueObjects = new byte[this.columnInformationLength][];
        for (int i = 0; i < this.columnInformationLength; ++i) {
            while (buffer.remaining() == 0) {
                buffer.appendPacket(packetFetcher.getPacket());
            }
            long valueLen = buffer.getLengthEncodedBinary();
            if (valueLen == -1L) {
                valueObjects[i] = null;
                continue;
            }
            while ((long)buffer.remaining() < valueLen) {
                buffer.appendPacket(packetFetcher.getPacket());
            }
            valueObjects[i] = buffer.readRawBytes((int)valueLen);
        }
        return valueObjects;
    }

    @Override
    public byte[][] getRow(ReadPacketFetcher packetFetcher, MariaDbInputStream inputStream, int remaining, int read) throws IOException {
        byte[][] valueObjects = new byte[this.columnInformationLength][];
        int position = 0;
        while (true) {
            int toReadLen;
            switch (read) {
                case 251: {
                    toReadLen = -1;
                    break;
                }
                case 252: {
                    toReadLen = (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8);
                    remaining -= 2;
                    break;
                }
                case 253: {
                    toReadLen = (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8) + ((inputStream.read() & 0xFF) << 16);
                    remaining -= 3;
                    break;
                }
                case 254: {
                    toReadLen = (int)((long)(inputStream.read() & 0xFF) + ((long)(inputStream.read() & 0xFF) << 8) + ((long)(inputStream.read() & 0xFF) << 16) + ((long)(inputStream.read() & 0xFF) << 24) + ((long)(inputStream.read() & 0xFF) << 32) + ((long)(inputStream.read() & 0xFF) << 40) + ((long)(inputStream.read() & 0xFF) << 48) + ((long)(inputStream.read() & 0xFF) << 56));
                    remaining -= 8;
                    break;
                }
                default: {
                    toReadLen = read;
                }
            }
            if (toReadLen == -1) {
                valueObjects[position++] = null;
            } else if (toReadLen == 0) {
                valueObjects[position++] = new byte[0];
            } else {
                valueObjects[position++] = packetFetcher.readLength(toReadLen);
                remaining -= toReadLen;
            }
            if (remaining <= 0) break;
            read = inputStream.read() & 0xFF;
            --remaining;
        }
        return valueObjects;
    }
}

