/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.ResultSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.CmdInformation;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class CmdInformationMultiple
implements CmdInformation {
    private Deque<Long> insertIds;
    private Deque<Integer> updateCounts;
    private int expectedSize;

    public CmdInformationMultiple(long insertId, int updateCount, int expectedSize) {
        this.expectedSize = expectedSize;
        this.insertIds = new ArrayDeque<Long>(expectedSize);
        this.updateCounts = new ArrayDeque<Integer>(expectedSize);
        if (insertId != 0L) {
            this.insertIds.add(insertId);
        }
        this.updateCounts.add(updateCount);
    }

    public CmdInformationMultiple(int updateCount, int expectedSize) {
        this.expectedSize = expectedSize;
        this.insertIds = new ArrayDeque<Long>(expectedSize);
        this.updateCounts = new ArrayDeque<Integer>(expectedSize);
        this.updateCounts.add(updateCount);
    }

    public CmdInformationMultiple(int expectedSize) {
        this.expectedSize = expectedSize;
        this.insertIds = new ArrayDeque<Long>(expectedSize);
        this.updateCounts = new ArrayDeque<Integer>(expectedSize);
        this.updateCounts.add(-3);
    }

    @Override
    public void addStats(int updateCount) {
        this.updateCounts.add(updateCount);
    }

    @Override
    public void addStats(int updateCount, long insertId) {
        if (insertId != 0L) {
            this.insertIds.add(insertId);
        }
        this.updateCounts.add(updateCount);
    }

    @Override
    public int[] getUpdateCounts() {
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        int pos = 0;
        for (Integer updateCount : this.updateCounts) {
            ret[pos++] = updateCount;
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public int getUpdateCount() {
        Integer updateCount = this.updateCounts.peekFirst();
        return updateCount == null ? -1 : updateCount;
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIds.size()];
        Iterator<Long> iterator = this.insertIds.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return MariaSelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        if (this.updateCounts.pollFirst() != null) {
            return this.isCurrentUpdateCount();
        }
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        Integer updateCount = this.updateCounts.peekFirst();
        return updateCount == null ? false : -1 != updateCount;
    }
}

