/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.LocalInfileInterceptor;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.packet.ComExecute;
import org.mariadb.jdbc.internal.packet.ComStmtExecute;
import org.mariadb.jdbc.internal.packet.ComStmtLongData;
import org.mariadb.jdbc.internal.packet.ComStmtPrepare;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.result.EndOfFilePacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.send.SendChangeDbPacket;
import org.mariadb.jdbc.internal.packet.send.SendPingPacket;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.AbstractMultiSend;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiFixedIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiVariableIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.stream.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.BulkStatus;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private static Logger logger = LoggerFactory.getLogger(AbstractQueryProtocol.class);
    private int transactionIsolationLevel = 0;
    private InputStream localInfileInputStream;
    private int maxRows;
    private volatile int statementIdToRelease = -1;

    public AbstractQueryProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    @Override
    public void executeQuery(String sql) throws QueryException {
        this.executeQuery(this.isMasterConnection(), new SingleExecutionResult(null, 0, false, false), sql, 1003);
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, ExecutionResult executionResult, String sql, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        try {
            this.writer.send(sql, (byte)3);
            this.getResult(executionResult, resultSetScrollType, false, true);
        }
        catch (QueryException queryException) {
            throw this.addQueryInfo(sql, queryException);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, ExecutionResult executionResult, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                ComExecute.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0));
            } else {
                this.writer.startPacket(0);
                ComExecute.sendSubCmd(this.writer, clientPrepareResult, parameters);
                this.writer.finishPacketWithoutRelease(true);
            }
            this.getResult(executionResult, resultSetScrollType, false, true);
        }
        catch (QueryException queryException) {
            throw this.throwErrorWithQuery(parameters, queryException, clientPrepareResult);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.writer.releaseBufferIfNotLogging();
        }
    }

    @Override
    public void executeBatchMulti(boolean mustExecuteOnMaster, ExecutionResult executionResult, final ClientPrepareResult clientPrepareResult, final List<ParameterHolder[]> parametersList, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        new AbstractMultiSend(this, this.writer, executionResult, clientPrepareResult, parametersList, resultSetScrollType){

            @Override
            public void sendCmd(PacketOutputStream writer, ExecutionResult executionResult, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws QueryException, IOException {
                ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                writer.startPacket(0);
                ComExecute.sendSubCmd(writer, clientPrepareResult, parameters);
                writer.finishPacketWithoutRelease(true);
            }

            @Override
            public QueryException handleResultException(QueryException qex, ExecutionResult executionResult, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) throws QueryException {
                int counter = executionResult instanceof MultiVariableIntExecutionResult ? ((MultiVariableIntExecutionResult)executionResult).getAffectedRows().length - 1 : ((MultiFixedIntExecutionResult)executionResult).getCurrentStat() - 1;
                ParameterHolder[] parameters = parametersList2.get(counter);
                List<byte[]> queryParts = clientPrepareResult.getQueryParts();
                String sql = new String(queryParts.get(0));
                for (int i = 0; i < paramCount; ++i) {
                    sql = sql + parameters[i].toString() + new String(queryParts.get(i + 1));
                }
                return AbstractQueryProtocol.this.addQueryInfo(sql, qex);
            }

            @Override
            public int getParamCount() {
                return clientPrepareResult.getQueryParts().size() - 1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return parametersList.size();
            }
        }.executeBatch();
    }

    @Override
    public void executeBatch(boolean mustExecuteOnMaster, ExecutionResult executionResult, final List<String> queries, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        new AbstractMultiSend(this, this.writer, executionResult, queries, resultSetScrollType){

            @Override
            public void sendCmd(PacketOutputStream writer, ExecutionResult executionResult, List<ParameterHolder[]> parametersList, List<String> queries2, int paramCount, BulkStatus status, PrepareResult prepareResult) throws QueryException, IOException {
                String sql = queries2.get(status.sendCmdCounter);
                writer.send(sql, (byte)3);
            }

            @Override
            public QueryException handleResultException(QueryException qex, ExecutionResult executionResult, List<ParameterHolder[]> parametersList, List<String> queries2, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) throws QueryException {
                String sql = queries2.get(currentCounter + sendCmdCounter);
                return AbstractQueryProtocol.this.addQueryInfo(sql, qex);
            }

            @Override
            public int getParamCount() {
                return -1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return queries.size();
            }
        }.executeBatch();
    }

    @Override
    public ServerPrepareResult prepare(String sql, boolean executeOnMaster) throws QueryException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            ServerPrepareResult result;
            String key;
            ServerPrepareResult pr;
            if (this.options.cachePrepStmts && (pr = (ServerPrepareResult)this.serverPrepareStatementCache.get(key = this.database + "-" + sql)) != null && pr.incrementShareCounter()) {
                ServerPrepareResult serverPrepareResult = pr;
                return serverPrepareResult;
            }
            this.writer.startPacket(0, true);
            ComStmtPrepare comStmtPrepare = new ComStmtPrepare(this, sql);
            comStmtPrepare.send(this.writer);
            ServerPrepareResult serverPrepareResult = result = comStmtPrepare.read(this.packetFetcher);
            return serverPrepareResult;
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void executeBatchMultiple(boolean mustExecuteOnMaster, ExecutionResult executionResult, List<String> queries, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        String firstSql = null;
        int currentIndex = 0;
        int totalQueries = queries.size();
        QueryException exception = null;
        do {
            try {
                firstSql = queries.get(currentIndex++);
                if (totalQueries == 1) {
                    this.writer.send(firstSql, (byte)3);
                } else {
                    currentIndex = ComExecute.sendMultiple(this.writer, firstSql, queries, currentIndex);
                }
                this.getResult(executionResult, resultSetScrollType, false, true);
            }
            catch (QueryException queryException) {
                this.addQueryInfo(firstSql, queryException);
                if (!this.getOptions().continueBatchOnError) {
                    throw queryException;
                }
                if (exception != null) continue;
                exception = queryException;
            }
            catch (MaxAllowedPacketException e) {
                if (e.isMustReconnect()) {
                    this.connect();
                }
                throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
            }
            catch (IOException e) {
                throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
            }
            finally {
                this.writer.releaseBufferIfNotLogging();
            }
        } while (currentIndex < totalQueries);
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void executeBatchRewrite(boolean mustExecuteOnMaster, ExecutionResult executionResult, ClientPrepareResult prepareResult, List<ParameterHolder[]> parameterList, int resultSetScrollType, boolean rewriteValues) throws QueryException {
        this.cmdPrologue();
        int currentIndex = 0;
        int totalParameterList = parameterList.size();
        try {
            do {
                ParameterHolder[] parameters = parameterList.get(currentIndex++);
                currentIndex = ComExecute.sendRewriteCmd(this.writer, prepareResult.getQueryParts(), parameters, currentIndex, prepareResult.getParamCount(), parameterList, rewriteValues);
                this.getResult(executionResult, resultSetScrollType, false, true);
            } while (currentIndex < totalParameterList);
        }
        catch (QueryException queryException) {
            this.throwErrorWithQuery(this.writer.buffer, queryException);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.writer.releaseBufferIfNotLogging();
        }
    }

    @Override
    public ServerPrepareResult prepareAndExecutes(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, ExecutionResult executionResult, String sql, final List<ParameterHolder[]> parametersList, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        return (ServerPrepareResult)new AbstractMultiSend(this, this.writer, executionResult, serverPrepareResult, parametersList, resultSetScrollType, true, sql){

            @Override
            public void sendCmd(PacketOutputStream writer, ExecutionResult executionResult, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws QueryException, IOException {
                ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                if (parameters.length < paramCount) {
                    throw new QueryException("Parameter at position " + (paramCount - 1) + " is not set", -1, "07004");
                }
                for (int i = 0; i < paramCount; ++i) {
                    if (!parameters[i].isLongData()) continue;
                    new ComStmtLongData().send(writer, this.statementId, (short)i, parameters[i]);
                }
                writer.startPacket(0);
                ComStmtExecute.writeCmd(this.statementId, parameters, paramCount, this.parameterTypeHeader, writer);
                writer.finishPacketWithoutRelease(true);
            }

            @Override
            public QueryException handleResultException(QueryException qex, ExecutionResult executionResult, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) throws QueryException {
                return AbstractQueryProtocol.this.throwErrorWithQuery(parametersList2, qex, (ServerPrepareResult)prepareResult);
            }

            @Override
            public int getParamCount() {
                return this.getPrepareResult() == null ? ((ParameterHolder[])parametersList.get(0)).length : ((ServerPrepareResult)this.getPrepareResult()).getParameters().length;
            }

            @Override
            public int getTotalExecutionNumber() {
                return parametersList.size();
            }
        }.executeBatch();
    }

    @Override
    public ServerPrepareResult prepareAndExecute(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, ExecutionResult executionResult, String sql, ParameterHolder[] parameters, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        int statementId = -1;
        int parameterCount = parameters.length;
        MariaDbType[] parameterTypeHeader = new MariaDbType[parameters.length];
        if (this.getOptions().cachePrepStmts) {
            String key = this.getDatabase() + "-" + sql;
            serverPrepareResult = (ServerPrepareResult)this.prepareStatementCache().get(key);
            if (serverPrepareResult != null && !serverPrepareResult.incrementShareCounter()) {
                serverPrepareResult = null;
            }
            statementId = serverPrepareResult == null ? -1 : serverPrepareResult.getStatementId();
        }
        ComStmtPrepare comStmtPrepare = null;
        Object exception = null;
        try {
            block17: {
                if (serverPrepareResult == null) {
                    comStmtPrepare = new ComStmtPrepare(this, sql);
                    comStmtPrepare.send(this.writer);
                    serverPrepareResult = comStmtPrepare.read(this.getPacketFetcher());
                    statementId = serverPrepareResult.getStatementId();
                    parameterCount = serverPrepareResult.getParameters().length;
                }
                if (serverPrepareResult != null && parameters.length < parameterCount) {
                    throw new QueryException("Parameter at position " + parameterCount + " is not set", -1, "07004");
                }
                for (int i = 0; i < parameterCount; ++i) {
                    if (!parameters[i].isLongData()) continue;
                    new ComStmtLongData().send(this.writer, statementId, (short)i, parameters[i]);
                }
                this.writer.startPacket(0);
                ComStmtExecute.writeCmd(statementId, parameters, parameterCount, parameterTypeHeader, this.writer);
                this.writer.finishPacketWithoutRelease(true);
                try {
                    this.getResult(executionResult, resultSetScrollType, true, true);
                }
                catch (QueryException qex) {
                    if (exception != null) break block17;
                    throw this.throwErrorWithQuery(parameters, qex, (PrepareResult)serverPrepareResult);
                }
            }
            if (exception != null) {
                throw exception;
            }
            ServerPrepareResult qex = serverPrepareResult;
            return qex;
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.writer.releaseBufferIfNotLogging();
        }
    }

    @Override
    public void executePreparedQuery(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, ExecutionResult executionResult, ParameterHolder[] parameters, int resultSetScrollType) throws QueryException {
        this.cmdPrologue();
        try {
            int parameterCount = serverPrepareResult.getParameters().length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                new ComStmtLongData().send(this.writer, serverPrepareResult.getStatementId(), (short)i, parameters[i]);
            }
            new ComStmtExecute(serverPrepareResult.getStatementId(), parameters, parameterCount, serverPrepareResult.getParameterTypeHeader()).send(this.writer);
            this.getResult(executionResult, resultSetScrollType, true, true);
        }
        catch (QueryException qex) {
            throw this.throwErrorWithQuery(parameters, qex, (PrepareResult)serverPrepareResult);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.writer.releaseBufferIfNotLogging();
        }
    }

    @Override
    public void rollback() throws QueryException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery("ROLLBACK");
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean forceReleasePrepareStatement(int statementId) throws QueryException {
        if (this.lock.tryLock()) {
            try {
                this.checkClose();
                try {
                    this.writer.closePrepare(statementId);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    throw new QueryException("Could not deallocate query: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.statementIdToRelease = statementId;
        return false;
    }

    @Override
    public void forceReleaseWaitingPrepareStatement() throws QueryException {
        if (this.statementIdToRelease != -1 && this.forceReleasePrepareStatement(this.statementIdToRelease)) {
            this.statementIdToRelease = -1;
        }
    }

    @Override
    public boolean ping() throws QueryException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            SendPingPacket pingPacket = new SendPingPacket();
            try {
                pingPacket.send(this.writer);
                Buffer buffer = this.packetFetcher.getReusableBuffer();
                boolean bl = buffer.getByteAt(0) == 0;
                return bl;
            }
            catch (IOException e) {
                throw new QueryException("Could not ping: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCatalog(String database) throws QueryException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            SendChangeDbPacket packet = new SendChangeDbPacket(database);
            packet.send(this.writer);
            Buffer buffer = this.packetFetcher.getReusableBuffer();
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new QueryException("Could not select database '" + database + "' : " + ep.getMessage(), (int)ep.getErrorNumber(), ep.getSqlState());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw new QueryException("Could not select database '" + database + "' :" + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancelCurrentQuery() throws QueryException, IOException {
        MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new ReentrantLock());
        copiedProtocol.setHostAddress(this.getHostAddress());
        copiedProtocol.connect();
        copiedProtocol.executeQuery("KILL QUERY " + this.serverThreadId);
        copiedProtocol.close();
    }

    private void sendLocalFile(ExecutionResult executionResult, String fileName) throws IOException, QueryException {
        InputStream is;
        int seq = 2;
        this.writer.setCompressSeqNo(2);
        if (this.localInfileInputStream == null) {
            if (!this.getUrlParser().getOptions().allowLocalInfile) {
                this.writer.writeEmptyPacket(seq++);
                this.packetFetcher.getReusableBuffer();
                throw new QueryException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", -1, SqlStates.FEATURE_NOT_SUPPORTED.getSqlState());
            }
            ServiceLoader<LocalInfileInterceptor> loader = ServiceLoader.load(LocalInfileInterceptor.class);
            for (LocalInfileInterceptor interceptor : loader) {
                if (interceptor.validate(fileName)) continue;
                this.writer.writeEmptyPacket(seq++);
                this.packetFetcher.getReusableBuffer();
                throw new QueryException("LOCAL DATA LOCAL INFILE request to send local file named \"" + fileName + "\" not validated by interceptor \"" + interceptor.getClass().getName() + "\"");
            }
            try {
                URL url = new URL(fileName);
                is = url.openStream();
            }
            catch (IOException ioe) {
                try {
                    is = new FileInputStream(fileName);
                }
                catch (FileNotFoundException f) {
                    this.writer.writeEmptyPacket(seq++);
                    this.packetFetcher.getReusableBuffer();
                    throw new QueryException("Could not send file : " + f.getMessage(), -1, "22000", (Throwable)f);
                }
            }
        } else {
            is = this.localInfileInputStream;
            this.localInfileInputStream = null;
        }
        this.writer.sendFile(is, seq);
        is.close();
        this.getResult(executionResult, 1003, false, true);
    }

    private ServerPrepareResult getPrepareResultFromCacheIfNeeded(ServerPrepareResult serverPrepareResult, String sql) throws UnsupportedEncodingException {
        String key;
        if (serverPrepareResult == null && this.options.cachePrepStmts && (serverPrepareResult = (ServerPrepareResult)this.serverPrepareStatementCache.get(key = this.database + "-" + sql)) != null && !serverPrepareResult.incrementShareCounter()) {
            return null;
        }
        return serverPrepareResult;
    }

    @Override
    public boolean getAutocommit() {
        this.lock.lock();
        try {
            boolean bl = (this.serverStatus & ServerStatus.AUTOCOMMIT) != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & ServerStatus.IN_TRANSACTION) != 0;
    }

    @Override
    public boolean hasMoreResults() {
        return this.moreResults;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void releasePrepareStatement(ServerPrepareResult serverPrepareResult) throws QueryException {
        serverPrepareResult.decrementShareCounter();
        if (serverPrepareResult.canBeDeallocate()) {
            this.forceReleasePrepareStatement(serverPrepareResult.getStatementId());
        }
    }

    @Override
    public void getMoreResults(ExecutionResult executionResult) throws QueryException {
        if (!this.hasMoreResults()) {
            return;
        }
        this.getResult(executionResult, 1003, this.activeStreamingResult != null ? this.activeStreamingResult.isBinaryEncoded() : this.moreResultsTypeBinary, false);
    }

    @Override
    public void setInternalMaxRows(int max) {
        if (this.maxRows != max) {
            this.maxRows = max;
        }
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws QueryException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery("set @@SQL_SELECT_LIMIT=DEFAULT");
            } else {
                this.executeQuery("set @@SQL_SELECT_LIMIT=" + max);
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            this.getOptions().socketTimeout = timeout;
            this.socket.setSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws QueryException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new QueryException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(query);
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws QueryException {
        if (!this.connected) {
            throw new QueryException("Connection is close", 1220, "08000");
        }
    }

    public void fetchActiveStreamingResult() throws SQLException {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.fetchAllStreaming();
        }
    }

    private QueryException addQueryInfo(String sql, QueryException queryException) {
        if (this.getOptions().dumpQueriesOnException || queryException.getErrorCode() == 1064) {
            if (this.options.maxQuerySizeToLog > 0 && sql.length() > this.options.maxQuerySizeToLog - 3) {
                sql = sql.substring(0, this.options.maxQuerySizeToLog - 3) + "...";
            }
            queryException.setMessage(queryException.getMessage() + "\nQuery is : " + sql);
        }
        return queryException;
    }

    private void throwErrorWithQuery(ByteBuffer buffer, QueryException queryException) throws QueryException {
        if (this.getOptions().dumpQueriesOnException || queryException.getErrorCode() == 1064) {
            String queryString;
            if (this.options.maxQuerySizeToLog == 0) {
                queryString = new String(buffer.array(), 5, buffer.limit());
            } else {
                queryString = new String(buffer.array(), 5, Math.min(buffer.limit() - 5, this.options.maxQuerySizeToLog * 3));
                if (queryString.length() > this.options.maxQuerySizeToLog - 3) {
                    queryString = queryString.substring(0, this.options.maxQuerySizeToLog - 3) + "...";
                }
            }
            this.addQueryInfo(queryString, queryException);
        }
        throw queryException;
    }

    private QueryException throwErrorWithQuery(ParameterHolder[] parameters, QueryException qex, PrepareResult serverPrepareResult) throws QueryException {
        if (this.getOptions().dumpQueriesOnException || qex.getErrorCode() == 1064) {
            String sql = serverPrepareResult.getSql();
            if (serverPrepareResult.getParamCount() > 0) {
                sql = sql + ", parameters [";
                if (parameters.length > 0) {
                    for (int i = 0; i < Math.min(parameters.length, serverPrepareResult.getParamCount()); ++i) {
                        sql = sql + parameters[i].toString() + ",";
                    }
                    sql = sql.substring(0, sql.length() - 1);
                }
                sql = sql + "]";
            }
            if (this.options.maxQuerySizeToLog != 0 && sql.length() > this.options.maxQuerySizeToLog - 3) {
                qex.setMessage(qex.getMessage() + "\nQuery is: " + sql.substring(0, this.options.maxQuerySizeToLog - 3) + "...");
            } else {
                qex.setMessage(qex.getMessage() + "\nQuery is: " + sql);
            }
        }
        if (qex.getCause() instanceof SocketTimeoutException) {
            return new QueryException("Connection timed out", -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)qex);
        }
        return qex;
    }

    private QueryException throwErrorWithQuery(List<ParameterHolder[]> parameterList, QueryException qex, ServerPrepareResult serverPrepareResult) throws QueryException {
        if (this.getOptions().dumpQueriesOnException || qex.getErrorCode() == 1064) {
            String querySql = serverPrepareResult.getSql();
            if (serverPrepareResult.getParameters().length > 0) {
                querySql = querySql + ", parameters ";
                for (int paramNo = 0; paramNo < parameterList.size(); ++paramNo) {
                    ParameterHolder[] parameters = parameterList.get(paramNo);
                    querySql = querySql + "[";
                    if (parameters.length > 0) {
                        for (int i = 0; i < parameters.length; ++i) {
                            querySql = querySql + parameters[i].toString() + ",";
                        }
                        querySql = querySql.substring(0, querySql.length() - 1);
                    }
                    if (this.options.maxQuerySizeToLog > 0 && querySql.length() > this.options.maxQuerySizeToLog) break;
                    querySql = querySql + "],";
                }
                querySql = querySql.substring(0, querySql.length() - 1);
            }
            if (this.options.maxQuerySizeToLog != 0 && querySql.length() > this.options.maxQuerySizeToLog - 3) {
                qex.setMessage(qex.getMessage() + "\nQuery is: " + querySql.substring(0, this.options.maxQuerySizeToLog - 3) + "...");
            } else {
                qex.setMessage(qex.getMessage() + "\nQuery is: " + querySql);
            }
        }
        return qex;
    }

    @Override
    public ExecutionResult getResult(ExecutionResult executionResult, int resultSetScrollType, boolean binaryProtocol, boolean loadAllResults) throws QueryException {
        Buffer buffer;
        try {
            buffer = this.packetFetcher.getReusableBuffer();
        }
        catch (IOException e) {
            try {
                if (this.writer != null) {
                    this.writer.writeEmptyPacket(this.packetFetcher.getLastPacketSeq() + 1);
                    this.packetFetcher.getReusableBuffer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
        }
        switch (buffer.getByteAt(0)) {
            case 0: {
                buffer.skipByte();
                long affectedRows = buffer.getLengthEncodedBinary();
                long insertId = buffer.getLengthEncodedBinary();
                this.serverStatus = buffer.readShort();
                this.hasWarnings = buffer.readShort() > 0;
                this.moreResults = (this.serverStatus & ServerStatus.MORE_RESULTS_EXISTS) != 0;
                executionResult.addStats(affectedRows, insertId, this.moreResults);
                if (!loadAllResults) {
                    return new SingleExecutionResult(executionResult.getStatement(), 0, true, false, affectedRows, insertId);
                }
                while (this.moreResults && loadAllResults && executionResult.getFetchSize() == 0) {
                    executionResult.getCachedExecutionResults().add(this.getResult(executionResult, 1003, this.activeStreamingResult != null ? this.activeStreamingResult.isBinaryEncoded() : this.moreResultsTypeBinary, false));
                }
                break;
            }
            case -1: {
                String message;
                String sqlState;
                this.moreResults = false;
                this.hasWarnings = false;
                buffer.skipByte();
                short errorNumber = buffer.readShort();
                if (buffer.readByte() == 35) {
                    sqlState = new String(buffer.readRawBytes(5));
                    message = buffer.readString(StandardCharsets.UTF_8);
                } else {
                    --buffer.position;
                    message = new String(buffer.buf, buffer.position, buffer.limit - buffer.position, StandardCharsets.UTF_8);
                    sqlState = "HY000";
                }
                executionResult.addStatsError(this.moreResults);
                throw new QueryException(message, (int)errorNumber, sqlState);
            }
            case -5: {
                buffer.getLengthEncodedBinary();
                String fileName = buffer.readString(StandardCharsets.UTF_8);
                try {
                    this.sendLocalFile(executionResult, fileName);
                    break;
                }
                catch (MaxAllowedPacketException e) {
                    if (e.isMustReconnect()) {
                        this.connect();
                    }
                    try {
                        if (this.writer != null) {
                            this.writer.writeEmptyPacket(this.packetFetcher.getLastPacketSeq() + 1);
                            this.packetFetcher.getReusableBuffer();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new QueryException("Could not send query: " + e.getMessage(), -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), (Throwable)e);
                }
                catch (IOException e) {
                    try {
                        if (this.writer != null) {
                            this.writer.writeEmptyPacket(this.packetFetcher.getLastPacketSeq() + 1);
                            this.packetFetcher.getReusableBuffer();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
                }
            }
            case -2: {
                if (buffer.remaining() < 9) {
                    throw new QueryException("Could not parse result", -1, SqlStates.INTERRUPTED_EXCEPTION.getSqlState());
                }
            }
            default: {
                this.hasWarnings = false;
                long fieldCount = buffer.getLengthEncodedBinary();
                try {
                    boolean callableResult = false;
                    ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
                    int i = 0;
                    while ((long)i < fieldCount) {
                        ci[i] = new ColumnInformation(this.packetFetcher.getPacket());
                        ++i;
                    }
                    Buffer bufferEof = this.packetFetcher.getReusableBuffer();
                    if (bufferEof.getByteAt(0) != -2) {
                        throw new QueryException("Packets out of order when reading field packets, expected was EOF stream. Packet contents (hex) = " + Utils.hexdump(bufferEof.buf, this.options.maxQuerySizeToLog, 0));
                    }
                    if (executionResult.isCanHaveCallableResultset() || this.checkCallableResultSet) {
                        EndOfFilePacket endOfFilePacket = new EndOfFilePacket(bufferEof);
                        callableResult = (endOfFilePacket.getStatusFlags() & ServerStatus.PS_OUT_PARAMETERS) != 0;
                    }
                    MariaSelectResultSet mariaSelectResultset = new MariaSelectResultSet(ci, executionResult.getStatement(), this, this.packetFetcher, binaryProtocol, resultSetScrollType, executionResult.getFetchSize(), callableResult);
                    mariaSelectResultset.initFetch();
                    if (!executionResult.isSelectPossible()) {
                        while (this.moreResults && loadAllResults && executionResult.getFetchSize() == 0) {
                            try {
                                this.getResult(executionResult, 1003, this.activeStreamingResult != null ? this.activeStreamingResult.isBinaryEncoded() : this.moreResultsTypeBinary, false);
                            }
                            catch (QueryException queryException) {}
                        }
                        if (!executionResult.isCanHaveCallableResultset()) {
                            throw new QueryException("Select command are not permitted via executeBatch() command");
                        }
                    }
                    if (!loadAllResults) {
                        return new SingleExecutionResult(executionResult.getStatement(), 0, true, false, mariaSelectResultset);
                    }
                    executionResult.addResultSet(mariaSelectResultset, this.moreResults);
                    while (this.moreResults && loadAllResults && executionResult.getFetchSize() == 0) {
                        executionResult.getCachedExecutionResults().add(this.getResult(executionResult, 1003, this.activeStreamingResult != null ? this.activeStreamingResult.isBinaryEncoded() : this.moreResultsTypeBinary, false));
                    }
                    break;
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION.getSqlState(), (Throwable)e);
                }
            }
        }
        return executionResult;
    }

    @Override
    public void prologProxy(ServerPrepareResult serverPrepareResult, ExecutionResult executionResult, int maxRows, boolean hasProxy, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        this.prolog(executionResult, maxRows, hasProxy, connection, statement);
    }

    @Override
    public void prolog(ExecutionResult executionResult, int maxRows, boolean hasProxy, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        if (this.explicitClosed) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (!hasProxy && this.shouldReconnectWithoutProxy()) {
            try {
                this.connectWithoutProxy();
            }
            catch (QueryException qe) {
                ExceptionMapper.throwException(qe, connection, statement);
            }
        }
        try {
            this.setMaxRows(maxRows);
            this.fetchActiveStreamingResult();
            while (this.hasMoreResults()) {
                this.getMoreResults(executionResult);
            }
        }
        catch (QueryException qe) {
            ExceptionMapper.throwException(qe, connection, statement);
        }
        connection.reenableWarnings();
    }

    @Override
    public ServerPrepareResult addPrepareInCache(String key, ServerPrepareResult serverPrepareResult) {
        return this.serverPrepareStatementCache.put(key, serverPrepareResult);
    }

    private void cmdPrologue() throws QueryException {
        if (this.activeStreamingResult != null) {
            throw new QueryException("There is an open result set on the current connection, which must be closed prior to executing a query");
        }
        this.moreResults = false;
        if (!this.connected) {
            throw new QueryException("Connection is close", 1220, "08000");
        }
    }

    @Override
    public ServerPrepareResult getPrepareStatementFromCache(String key) {
        ServerPrepareResult pr = (ServerPrepareResult)this.serverPrepareStatementCache.get(key);
        if (pr != null && pr.incrementShareCounter()) {
            return pr;
        }
        return null;
    }
}

