/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults.resultset;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.BinaryRowPacket;
import org.mariadb.jdbc.internal.packet.result.EndOfFilePacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.packet.result.TextRowPacket;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.ColumnNameMap;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.stream.MariaDbInputStream;
import org.mariadb.jdbc.internal.util.ExceptionCode;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaSelectResultSet
implements ResultSet {
    private static Logger logger = LoggerFactory.getLogger(MariaSelectResultSet.class);
    public static final MariaSelectResultSet EMPTY = MariaSelectResultSet.createEmptyResultSet();
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    private static final Pattern isIntegerRegex = Pattern.compile("^-?\\d+\\.0+$");
    private Protocol protocol;
    private ReadPacketFetcher packetFetcher;
    private MariaDbInputStream inputStream;
    private Statement statement;
    private RowPacket rowPacket;
    private ColumnInformation[] columnsInformation;
    private byte[] lastReusableArray = null;
    private boolean isEof;
    private boolean isBinaryEncoded;
    private int dataFetchTime;
    private boolean streaming;
    private int columnInformationLength;
    private List<byte[][]> resultSet;
    private int resultSetSize;
    private int fetchSize;
    private int resultSetScrollType;
    private int rowPointer;
    private ColumnNameMap columnNameMap;
    private Calendar cal;
    private boolean lastGetWasNull;
    private int dataTypeMappingFlags;
    private Options options;
    private boolean returnTableAlias;
    private boolean isClosed;
    public boolean callableResult;
    static final String zeroTimestamp = "0000-00-00 00:00:00";
    static final String zeroDate = "0000-00-00";

    public MariaSelectResultSet(ColumnInformation[] columnInformation, Statement statement, Protocol protocol, ReadPacketFetcher fetcher, boolean isBinaryEncoded, int resultSetScrollType, int fetchSize, boolean isCanHaveCallableResultset) {
        this.statement = statement;
        this.isClosed = false;
        this.protocol = protocol;
        if (protocol != null) {
            this.options = protocol.getOptions();
            this.cal = protocol.getCalendar();
            this.dataTypeMappingFlags = protocol.getDataTypeMappingFlags();
            this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        } else {
            this.options = null;
            this.cal = null;
            this.dataTypeMappingFlags = 3;
            this.returnTableAlias = false;
        }
        this.columnsInformation = columnInformation;
        this.columnNameMap = new ColumnNameMap(this.columnsInformation);
        this.statement = statement;
        this.columnInformationLength = columnInformation.length;
        this.packetFetcher = fetcher;
        this.inputStream = this.packetFetcher.getInputStream();
        this.isEof = false;
        this.isBinaryEncoded = isBinaryEncoded;
        this.fetchSize = fetchSize;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSet = new ArrayList<byte[][]>();
        this.resultSetSize = 0;
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = isCanHaveCallableResultset;
    }

    public MariaSelectResultSet(ColumnInformation[] columnInformation, List<byte[][]> resultSet, Protocol protocol, int resultSetScrollType) {
        this.statement = null;
        this.isClosed = false;
        this.protocol = protocol;
        if (protocol != null) {
            this.options = protocol.getOptions();
            this.cal = protocol.getCalendar();
            this.dataTypeMappingFlags = protocol.getDataTypeMappingFlags();
            this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        } else {
            this.options = null;
            this.cal = null;
            this.dataTypeMappingFlags = 3;
            this.returnTableAlias = false;
        }
        this.columnsInformation = columnInformation;
        this.columnNameMap = new ColumnNameMap(this.columnsInformation);
        this.columnInformationLength = columnInformation.length;
        this.isEof = false;
        this.isBinaryEncoded = false;
        this.fetchSize = 1;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSet = resultSet;
        this.resultSetSize = this.resultSet.size();
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = false;
    }

    public static ResultSet createGeneratedData(long[] data, Protocol protocol, boolean findColumnReturnsOne) {
        ColumnInformation[] columns = new ColumnInformation[]{ColumnInformation.create("insert_id", MariaDbType.BIGINT)};
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        for (long rowData : data) {
            if (rowData == 0L) continue;
            byte[][] row = new byte[][]{String.valueOf(rowData).getBytes()};
            rows.add(row);
        }
        if (findColumnReturnsOne) {
            return new MariaSelectResultSet(columns, rows, protocol, 1005){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new MariaSelectResultSet(columns, rows, protocol, 1005);
    }

    public static ResultSet createResultSet(String[] columnNames, MariaDbType[] columnTypes, String[][] data, Protocol protocol) {
        int columnNameLength = columnNames.length;
        ColumnInformation[] columns = new ColumnInformation[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnInformation.create(columnNames[i], columnTypes[i]);
        }
        byte[] boolTrue = new byte[]{1};
        byte[] boolFalse = new byte[]{0};
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        for (String[] rowData : data) {
            byte[][] row = new byte[columnNameLength][];
            if (rowData.length != columnNameLength) {
                throw new RuntimeException("Number of elements in the row != number of columns :" + rowData.length + " vs " + columnNameLength);
            }
            for (int i = 0; i < columnNameLength; ++i) {
                byte[] bytes;
                if (rowData[i] == null) {
                    bytes = null;
                } else if (columnTypes[i] == MariaDbType.BIT) {
                    bytes = rowData[i].equals("0") ? boolFalse : boolTrue;
                } else {
                    try {
                        bytes = rowData[i].getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = new byte[]{};
                    }
                }
                row[i] = bytes;
            }
            rows.add(row);
        }
        return new MariaSelectResultSet(columns, rows, protocol, 1005);
    }

    private static MariaSelectResultSet createEmptyResultSet() {
        return new MariaSelectResultSet(new ColumnInformation[0], new ArrayList<byte[][]>(), null, 1005);
    }

    public void initFetch() throws IOException, QueryException {
        this.rowPacket = this.isBinaryEncoded ? new BinaryRowPacket(this.columnsInformation, this.columnInformationLength) : new TextRowPacket(this.columnInformationLength);
        if (this.fetchSize == 0 || this.resultSetScrollType != 1003) {
            this.fetchAllResults();
            this.streaming = false;
        } else {
            this.protocol.setActiveStreamingResult(this);
            this.nextStreamingValue();
            this.streaming = true;
        }
    }

    public boolean isBinaryEncoded() {
        return this.isBinaryEncoded;
    }

    private void fetchAllResults() throws IOException, QueryException {
        ArrayList<byte[][]> valueObjects = new ArrayList<byte[][]>();
        while (this.readNextValue(valueObjects)) {
        }
        ++this.dataFetchTime;
        this.resultSet = valueObjects;
        this.resultSetSize = this.resultSet.size();
    }

    public void fetchAllStreaming() throws SQLException {
        try {
            try {
                Protocol protocolTmp = this.protocol;
                while (this.readNextValue(this.resultSet)) {
                }
                this.resultSetSize = this.resultSet.size();
                if (protocolTmp.hasMoreResults() && this.statement != null) {
                    this.statement.getMoreResults();
                }
            }
            catch (IOException ioexception) {
                throw new QueryException("Could not close resultset : " + ioexception.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)ioexception);
            }
        }
        catch (QueryException queryException) {
            ExceptionMapper.throwException(queryException, null, this.getStatement());
        }
        ++this.dataFetchTime;
        this.streaming = false;
    }

    private void nextStreamingValue() throws IOException, QueryException {
        ArrayList<byte[][]> valueObjects = new ArrayList<byte[][]>(this.fetchSize);
        for (int fetchSizeTmp = this.fetchSize; fetchSizeTmp > 0 && this.readNextValue(valueObjects); --fetchSizeTmp) {
        }
        ++this.dataFetchTime;
        this.resultSet = valueObjects;
        this.resultSetSize = this.resultSet.size();
    }

    public boolean readNextValue(List<byte[][]> values) throws IOException, QueryException {
        int length = this.inputStream.readHeader();
        if (length < 0xFFFFFF) {
            int read = this.inputStream.read() & 0xFF;
            if (logger.isTraceEnabled()) {
                logger.trace("read packet data(part):0x" + Integer.valueOf(String.valueOf(read), 16));
            }
            int remaining = length - 1;
            if (read == 255) {
                this.protocol.setActiveStreamingResult(null);
                Buffer buffer = this.packetFetcher.getReusableBuffer(remaining, this.lastReusableArray);
                ErrorPacket errorPacket = new ErrorPacket(buffer, false);
                this.lastReusableArray = null;
                throw new QueryException(errorPacket.getMessage(), (int)errorPacket.getErrorNumber(), errorPacket.getSqlState());
            }
            if (read == 254 && remaining < 9) {
                Buffer buffer = this.packetFetcher.getReusableBuffer(remaining, this.lastReusableArray);
                this.protocol.setHasWarnings((buffer.buf[0] & 0xFF) + ((buffer.buf[1] & 0xFF) << 8) > 0);
                this.protocol.setMoreResults(this.callableResult || ((buffer.buf[2] & 0xFF) + ((buffer.buf[3] & 0xFF) << 8) & ServerStatus.MORE_RESULTS_EXISTS) != 0, this.isBinaryEncoded);
                if (!this.protocol.hasMoreResults()) {
                    if (this.protocol.getActiveStreamingResult() == this) {
                        this.protocol.setActiveStreamingResult(null);
                    }
                    this.protocol = null;
                    this.packetFetcher = null;
                    this.inputStream = null;
                }
                this.lastReusableArray = null;
                this.isEof = true;
                return false;
            }
            values.add(this.rowPacket.getRow(this.packetFetcher, this.inputStream, remaining, read));
            return true;
        }
        Buffer buffer = this.packetFetcher.getReusableBuffer(length, this.lastReusableArray);
        this.lastReusableArray = buffer.buf;
        if (buffer.getByteAt(0) == -1) {
            this.protocol.setActiveStreamingResult(null);
            ErrorPacket errorPacket = new ErrorPacket(buffer);
            this.lastReusableArray = null;
            throw new QueryException(errorPacket.getMessage(), (int)errorPacket.getErrorNumber(), errorPacket.getSqlState());
        }
        if (buffer.getByteAt(0) == -2 && buffer.limit < 9) {
            if (this.protocol.getActiveStreamingResult() == this) {
                this.protocol.setActiveStreamingResult(null);
            }
            this.protocol.setHasWarnings((buffer.buf[1] & 0xFF) + ((buffer.buf[2] & 0xFF) << 8) > 0);
            this.protocol.setMoreResults(this.callableResult || ((buffer.buf[3] & 0xFF) + ((buffer.buf[4] & 0xFF) << 8) & ServerStatus.MORE_RESULTS_EXISTS) != 0, this.isBinaryEncoded);
            this.protocol = null;
            this.packetFetcher = null;
            this.inputStream = null;
            this.isEof = true;
            this.lastReusableArray = null;
            return false;
        }
        values.add(this.rowPacket.getRow(this.packetFetcher, buffer));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.protocol != null && this.protocol.getActiveStreamingResult() == this) {
            ReentrantLock lock = this.protocol.getLock();
            lock.lock();
            try {
                try {
                    while (!this.isEof) {
                        Buffer buffer = this.packetFetcher.getReusableBuffer();
                        if (buffer.getByteAt(0) == -1) {
                            this.protocol.setActiveStreamingResult(null);
                            ErrorPacket errorPacket = new ErrorPacket(buffer);
                            throw new QueryException(errorPacket.getMessage(), (int)errorPacket.getErrorNumber(), errorPacket.getSqlState());
                        }
                        if (buffer.getByteAt(0) != -2 || buffer.limit >= 9) continue;
                        EndOfFilePacket endOfFilePacket = new EndOfFilePacket(buffer);
                        this.protocol.setHasWarnings(endOfFilePacket.getWarningCount() > 0);
                        this.protocol.setMoreResults((endOfFilePacket.getStatusFlags() & ServerStatus.MORE_RESULTS_EXISTS) != 0, this.isBinaryEncoded);
                        if (!this.protocol.hasMoreResults() && this.protocol.getActiveStreamingResult() == this) {
                            this.protocol.setActiveStreamingResult(null);
                        }
                        this.lastReusableArray = null;
                        this.isEof = true;
                    }
                    while (this.protocol.hasMoreResults()) {
                        this.protocol.getMoreResults(new SingleExecutionResult(this.statement, 0, true, this.callableResult));
                    }
                    if (this.protocol.getActiveStreamingResult() == this) {
                        this.protocol.setActiveStreamingResult(null);
                    }
                }
                catch (IOException ioexception) {
                    throw new QueryException("Could not close resultset : " + ioexception.getMessage(), -1, SqlStates.CONNECTION_EXCEPTION, (Throwable)ioexception);
                }
            }
            catch (QueryException queryException) {
                ExceptionMapper.throwException(queryException, null, this.getStatement());
            }
            finally {
                this.protocol = null;
                this.packetFetcher = null;
                this.inputStream = null;
                lock.unlock();
            }
        }
        if (this.statement != null) {
            ((MariaDbStatement)this.statement).checkCloseOnCompletion(this);
            this.statement = null;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not permit on a closed resultset", "HY000");
        }
        if (this.rowPointer < this.resultSetSize - 1) {
            ++this.rowPointer;
            return true;
        }
        if (this.streaming) {
            if (this.isEof) {
                return false;
            }
            try {
                this.nextStreamingValue();
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
            catch (QueryException queryException) {
                throw new SQLException(queryException);
            }
            this.rowPointer = 0;
            return this.resultSetSize > 0;
        }
        this.rowPointer = this.resultSetSize;
        return false;
    }

    protected byte[] checkObjectRange(int position) throws SQLException {
        if (this.rowPointer < 0) {
            this.throwError("Current position is before the first row", ExceptionCode.INVALID_PARAMETER_VALUE);
        }
        if (this.rowPointer >= this.resultSetSize) {
            this.throwError("Current position is after the last row", ExceptionCode.INVALID_PARAMETER_VALUE);
        }
        byte[][] row = this.resultSet.get(this.rowPointer);
        if (position <= 0 || position > row.length) {
            this.throwError("No such column: " + position, ExceptionCode.INVALID_PARAMETER_VALUE);
        }
        byte[] vo = row[position - 1];
        this.lastGetWasNull = this.isNull(vo, this.columnsInformation[position - 1].getType());
        return vo;
    }

    private void throwError(String message, ExceptionCode exceptionCode) throws SQLException {
        if (this.statement == null) {
            throw new SQLException(message, exceptionCode.sqlState);
        }
        ExceptionMapper.throwException(new QueryException(message, ExceptionCode.INVALID_PARAMETER_VALUE), (MariaDbConnection)this.statement.getConnection(), this.statement);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime > 0 ? this.rowPointer == -1 && this.resultSetSize > 0 : this.rowPointer == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        return this.dataFetchTime > 0 && this.rowPointer >= this.resultSetSize && this.resultSetSize > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime == 1 && this.rowPointer == 0 && this.resultSetSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.dataFetchTime > 0 && this.isEof) {
            return this.rowPointer == this.resultSetSize - 1 && this.resultSetSize > 0;
        }
        if (this.streaming) {
            try {
                this.nextStreamingValue();
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
            catch (QueryException queryException) {
                throw new SQLException(queryException);
            }
            return this.rowPointer == this.resultSetSize - 1 && this.resultSetSize > 0;
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = this.resultSetSize;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = 0;
        return this.resultSetSize > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = this.resultSetSize - 1;
        return this.rowPointer > 0;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.streaming) {
            return 0;
        }
        return this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (row >= 0 && row <= this.resultSetSize) {
            this.rowPointer = row - 1;
            return true;
        }
        if (row < 0) {
            this.rowPointer = this.resultSetSize + row;
        }
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        int newPos = this.rowPointer + rows;
        if (newPos > -1 && newPos <= this.resultSetSize) {
            this.rowPointer = newPos;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (this.rowPointer > -1) {
            --this.rowPointer;
            return this.rowPointer != -1;
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1001) {
            throw new SQLException("Invalid operation. Allowed direction are ResultSet.FETCH_FORWARD and ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (this.streaming && this.fetchSize == 0) {
            try {
                while (this.readNextValue(this.resultSet)) {
                }
            }
            catch (IOException ioException) {
                throw new SQLException(ioException);
            }
            catch (QueryException queryException) {
                throw new SQLException(queryException);
            }
            ++this.dataFetchTime;
            this.streaming = false;
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetScrollType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    private void checkClose() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not permit on a closed resultset", "HY000");
        }
    }

    public boolean isCallableResult() {
        return this.callableResult;
    }

    public void setCallableResult(boolean callableResult) {
        this.callableResult = callableResult;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getInputStream(this.checkObjectRange(columnIndex));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        byte[] rawByte = this.checkObjectRange(columnIndex);
        return this.getString(rawByte, this.columnsInformation[columnIndex - 1], this.cal);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    private String getString(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        return this.getString(rawBytes, columnInfo, null);
    }

    private String getString(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws SQLException {
        if (rawBytes == null) {
            return null;
        }
        switch (columnInfo.getType()) {
            case BIT: {
                if (!this.options.tinyInt1isBit || columnInfo.getLength() != 1L) break;
                return rawBytes[0] == 0 ? "0" : "1";
            }
            case TINYINT: {
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getTinyInt(rawBytes, columnInfo));
            }
            case SMALLINT: {
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getSmallInt(rawBytes, columnInfo));
            }
            case INTEGER: 
            case MEDIUMINT: {
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getMediumInt(rawBytes, columnInfo));
            }
            case BIGINT: {
                if (!this.isBinaryEncoded) break;
                if (!columnInfo.isSigned()) {
                    return String.valueOf(this.getBigInteger(rawBytes, columnInfo));
                }
                return String.valueOf(this.getLong(rawBytes, columnInfo));
            }
            case DOUBLE: {
                return String.valueOf(this.getDouble(rawBytes, columnInfo));
            }
            case FLOAT: {
                return String.valueOf(this.getFloat(rawBytes, columnInfo));
            }
            case TIME: {
                return this.getTimeString(rawBytes, columnInfo);
            }
            case DATE: {
                if (!this.isBinaryEncoded) break;
                try {
                    Date date = this.getDate(rawBytes, columnInfo, cal);
                    return date == null ? null : date.toString();
                }
                catch (ParseException date) {
                    break;
                }
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    try {
                        Date date = this.getDate(rawBytes, columnInfo, cal);
                        return date == null ? null : date.toString();
                    }
                    catch (ParseException date) {
                        // empty catch block
                    }
                }
                if (!this.isBinaryEncoded) break;
                return String.valueOf(this.getSmallInt(rawBytes, columnInfo));
            }
            case TIMESTAMP: 
            case DATETIME: {
                try {
                    Timestamp timestamp = this.getTimestamp(rawBytes, columnInfo, cal);
                    return timestamp == null ? null : timestamp.toString();
                }
                catch (ParseException timestamp) {
                    break;
                }
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getBigDecimal(rawBytes, columnInfo);
                return bigDecimal == null ? null : bigDecimal.toString();
            }
            case GEOMETRY: {
                return new String(rawBytes);
            }
            case NULL: {
                return null;
            }
            default: {
                return new String(rawBytes, StandardCharsets.UTF_8);
            }
        }
        return new String(rawBytes, StandardCharsets.UTF_8);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] rawBytes = this.checkObjectRange(columnIndex);
        if (rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(rawBytes);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    private int getInt(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        long value;
        if (rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            return this.parseInt(rawBytes, columnInfo);
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt(rawBytes, columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt(rawBytes, columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = (rawBytes[0] & 0xFF) + ((rawBytes[1] & 0xFF) << 8) + ((rawBytes[2] & 0xFF) << 16) + ((rawBytes[3] & 0xFF) << 24);
                if (columnInfo.isSigned()) {
                    return (int)value;
                }
                if (value >= 0L) break;
                value &= 0xFFFFFFFFL;
                break;
            }
            case BIGINT: {
                value = this.getLong(rawBytes, columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getFloat(rawBytes, columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getDouble(rawBytes, columnInfo);
                break;
            }
            default: {
                return this.parseInt(rawBytes, columnInfo);
            }
        }
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, value, columnInfo);
        return (int)value;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
    }

    private long getLong(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        long value;
        if (rawBytes == null) {
            return 0L;
        }
        if (!this.isBinaryEncoded) {
            return this.parseLong(rawBytes, columnInfo);
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt(rawBytes, columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt(rawBytes, columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt(rawBytes, columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(rawBytes[0] & 0xFF) + ((long)(rawBytes[1] & 0xFF) << 8) + ((long)(rawBytes[2] & 0xFF) << 16) + ((long)(rawBytes[3] & 0xFF) << 24) + ((long)(rawBytes[4] & 0xFF) << 32) + ((long)(rawBytes[5] & 0xFF) << 40) + ((long)(rawBytes[6] & 0xFF) << 48) + ((long)(rawBytes[7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)(value2 >> 0)});
                if (unsignedValue.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + unsignedValue + " is not in Long range", "22003", 1264);
                }
                return unsignedValue.longValue();
            }
            case FLOAT: {
                Float floatValue = Float.valueOf(this.getFloat(rawBytes, columnInfo));
                if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + floatValue + " is not in Long range", "22003", 1264);
                }
                return floatValue.longValue();
            }
            case DOUBLE: {
                Double doubleValue = this.getDouble(rawBytes, columnInfo);
                if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + doubleValue + " is not in Long range", "22003", 1264);
                }
                return doubleValue.longValue();
            }
            default: {
                return this.parseLong(rawBytes, columnInfo);
            }
        }
        this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, value, columnInfo);
        return value;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
    }

    private float getFloat(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        long value;
        if (rawBytes == null) {
            return 0.0f;
        }
        if (!this.isBinaryEncoded) {
            return Float.valueOf(new String(rawBytes, StandardCharsets.UTF_8)).floatValue();
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt(rawBytes, columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt(rawBytes, columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt(rawBytes, columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(rawBytes[0] & 0xFF) + ((long)(rawBytes[1] & 0xFF) << 8) + ((long)(rawBytes[2] & 0xFF) << 16) + ((long)(rawBytes[3] & 0xFF) << 24) + ((long)(rawBytes[4] & 0xFF) << 32) + ((long)(rawBytes[5] & 0xFF) << 40) + ((long)(rawBytes[6] & 0xFF) << 48) + ((long)(rawBytes[7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)(value2 >> 0)});
                return unsignedValue.floatValue();
            }
            case FLOAT: {
                int valueFloat = (rawBytes[0] & 0xFF) + ((rawBytes[1] & 0xFF) << 8) + ((rawBytes[2] & 0xFF) << 16) + ((rawBytes[3] & 0xFF) << 24);
                return Float.intBitsToFloat(valueFloat);
            }
            case DOUBLE: {
                return (float)this.getDouble(rawBytes, columnInfo);
            }
            default: {
                return Float.valueOf(new String(rawBytes, StandardCharsets.UTF_8)).floatValue();
            }
        }
        return Float.valueOf(String.valueOf(value)).floatValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
    }

    private double getDouble(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        if (rawBytes == null) {
            return 0.0;
        }
        if (!this.isBinaryEncoded) {
            return Double.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0];
            }
            case TINYINT: {
                return this.getTinyInt(rawBytes, columnInfo);
            }
            case SMALLINT: 
            case YEAR: {
                return this.getSmallInt(rawBytes, columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getMediumInt(rawBytes, columnInfo);
            }
            case BIGINT: {
                long valueLong = (long)(rawBytes[0] & 0xFF) + ((long)(rawBytes[1] & 0xFF) << 8) + ((long)(rawBytes[2] & 0xFF) << 16) + ((long)(rawBytes[3] & 0xFF) << 24) + ((long)(rawBytes[4] & 0xFF) << 32) + ((long)(rawBytes[5] & 0xFF) << 40) + ((long)(rawBytes[6] & 0xFF) << 48) + ((long)(rawBytes[7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return valueLong;
                }
                return new BigInteger(1, new byte[]{(byte)(valueLong >> 56), (byte)(valueLong >> 48), (byte)(valueLong >> 40), (byte)(valueLong >> 32), (byte)(valueLong >> 24), (byte)(valueLong >> 16), (byte)(valueLong >> 8), (byte)(valueLong >> 0)}).doubleValue();
            }
            case FLOAT: {
                return this.getFloat(rawBytes, columnInfo);
            }
            case DOUBLE: {
                long valueDouble = (long)(rawBytes[0] & 0xFF) + ((long)(rawBytes[1] & 0xFF) << 8) + ((long)(rawBytes[2] & 0xFF) << 16) + ((long)(rawBytes[3] & 0xFF) << 24) + ((long)(rawBytes[4] & 0xFF) << 32) + ((long)(rawBytes[5] & 0xFF) << 40) + ((long)(rawBytes[6] & 0xFF) << 48) + ((long)(rawBytes[7] & 0xFF) << 56);
                return Double.longBitsToDouble(valueDouble);
            }
        }
        return Double.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    private BigDecimal getBigDecimal(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        if (rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigDecimal(new String(rawBytes, StandardCharsets.UTF_8));
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return BigDecimal.valueOf(rawBytes[0]);
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getTinyInt(rawBytes, columnInfo));
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getSmallInt(rawBytes, columnInfo));
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getMediumInt(rawBytes, columnInfo));
            }
            case BIGINT: {
                long value = (long)(rawBytes[0] & 0xFF) + ((long)(rawBytes[1] & 0xFF) << 8) + ((long)(rawBytes[2] & 0xFF) << 16) + ((long)(rawBytes[3] & 0xFF) << 24) + ((long)(rawBytes[4] & 0xFF) << 32) + ((long)(rawBytes[5] & 0xFF) << 40) + ((long)(rawBytes[6] & 0xFF) << 48) + ((long)(rawBytes[7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(value))).setScale(columnInfo.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)}))).setScale(columnInfo.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf(this.getFloat(rawBytes, columnInfo));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.getDouble(rawBytes, columnInfo));
            }
        }
        return new BigDecimal(new String(rawBytes, StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.checkObjectRange(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this.getDate(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse column as date, was: \"" + this.getString(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]) + "\"", e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getDate(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse as date");
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    private Date getDate(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws ParseException {
        if (rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(rawBytes, StandardCharsets.UTF_8);
            String zeroDate = zeroDate;
            if (rawValue.equals(zeroDate)) {
                return null;
            }
            switch (columnInfo.getType()) {
                case TIMESTAMP: 
                case DATETIME: {
                    Timestamp timestamp = this.getTimestamp(rawBytes, columnInfo, cal);
                    if (timestamp == null) {
                        return null;
                    }
                    return new Date(timestamp.getTime());
                }
                case TIME: {
                    Time time = this.getTime(rawBytes, columnInfo, cal);
                    if (time == null) {
                        return null;
                    }
                    return new Date(time.getTime());
                }
                case DATE: {
                    return new Date(Integer.parseInt(rawValue.substring(0, 4)) - 1900, Integer.parseInt(rawValue.substring(5, 7)) - 1, Integer.parseInt(rawValue.substring(8, 10)));
                }
                case YEAR: {
                    int year = Integer.parseInt(rawValue);
                    if (rawBytes.length == 2 && columnInfo.getLength() == 2L) {
                        year = year <= 69 ? (year += 2000) : (year += 1900);
                    }
                    return new Date(year - 1900, 0, 1);
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (cal != null) {
                sdf.setCalendar(cal);
            }
            java.util.Date utilDate = sdf.parse(rawValue);
            return new Date(utilDate.getTime());
        }
        return this.binaryDate(rawBytes, columnInfo, cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.getTime(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse column as time, was: \"" + this.getString(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]) + "\"", e);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getTime(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse time", e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    private Time getTime(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws ParseException {
        if (rawBytes == null) {
            return null;
        }
        String raw = new String(rawBytes, StandardCharsets.UTF_8);
        String zeroDate = zeroDate;
        if (raw.equals(zeroDate)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String[] rawPart;
            if (columnInfo.getType() == MariaDbType.TIMESTAMP || columnInfo.getType() == MariaDbType.DATETIME) {
                Timestamp timestamp = this.getTimestamp(rawBytes, columnInfo, cal);
                return timestamp == null ? null : new Time(timestamp.getTime());
            }
            if (columnInfo.getType() == MariaDbType.DATE) {
                Calendar zeroCal = Calendar.getInstance();
                zeroCal.set(1970, 0, 1, 0, 0, 0);
                zeroCal.set(14, 0);
                return new Time(zeroCal.getTimeInMillis());
            }
            if (!this.options.useLegacyDatetimeCode && (raw.startsWith("-") || raw.split(":").length != 3 || raw.indexOf(":") > 3)) {
                throw new ParseException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss", 0);
            }
            boolean negate = raw.startsWith("-");
            if (negate) {
                raw = raw.substring(1);
            }
            if ((rawPart = raw.split(":")).length == 3) {
                int hour = Integer.parseInt(rawPart[0]);
                int minutes = Integer.parseInt(rawPart[1]);
                int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
                Calendar calendar = Calendar.getInstance();
                if (this.options.useLegacyDatetimeCode) {
                    calendar.setLenient(true);
                }
                calendar.clear();
                calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
                int nanoseconds = this.extractNanos(raw);
                calendar.set(14, nanoseconds / 1000000);
                return new Time(calendar.getTimeInMillis());
            }
            throw new ParseException(raw + " cannot be parse as time. time must have \"99:99:99\" format", 0);
        }
        return this.binaryTime(rawBytes, columnInfo, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.getTimestamp(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse timestamp", e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this.getTimestamp(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not parse column as timestamp, was: \"" + this.getString(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]) + "\"", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getTimestamp(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws ParseException {
        if (rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            String rawValue = new String(rawBytes, StandardCharsets.UTF_8);
            if (rawValue.startsWith(zeroTimestamp)) {
                return null;
            }
            switch (columnInfo.getType()) {
                case TIME: {
                    Timestamp tt = new Timestamp(this.getTime(rawBytes, columnInfo, cal).getTime());
                    tt.setNanos(this.extractNanos(rawValue));
                    return tt;
                }
            }
            try {
                Timestamp timestamp;
                Calendar calendar;
                int hour = 0;
                int minutes = 0;
                int seconds = 0;
                int year = Integer.parseInt(rawValue.substring(0, 4));
                int month = Integer.parseInt(rawValue.substring(5, 7));
                int day = Integer.parseInt(rawValue.substring(8, 10));
                if (rawValue.length() >= 19) {
                    hour = Integer.parseInt(rawValue.substring(11, 13));
                    minutes = Integer.parseInt(rawValue.substring(14, 16));
                    seconds = Integer.parseInt(rawValue.substring(17, 19));
                }
                int nanoseconds = this.extractNanos(rawValue);
                Calendar calendar2 = calendar = this.options.useLegacyDatetimeCode ? Calendar.getInstance() : cal;
                synchronized (calendar2) {
                    calendar.set(1, year);
                    calendar.set(2, month - 1);
                    calendar.set(5, day);
                    calendar.set(11, hour);
                    calendar.set(12, minutes);
                    calendar.set(13, seconds);
                    calendar.set(14, nanoseconds / 1000000);
                    timestamp = new Timestamp(calendar.getTime().getTime());
                }
                timestamp.setNanos(nanoseconds);
                return timestamp;
            }
            catch (NumberFormatException n) {
                throw new ParseException("Value \"" + rawValue + "\" cannot be parse as Timestamp", 0);
            }
            catch (StringIndexOutOfBoundsException s) {
                throw new ParseException("Value \"" + rawValue + "\" cannot be parse as Timestamp", 0);
            }
        }
        return this.binaryTimestamp(rawBytes, columnInfo, cal);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getInputStream(this.checkObjectRange(columnIndex));
    }

    @Override
    public String getCursorName() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MariaDbResultSetMetaData(this.columnsInformation, this.dataTypeMappingFlags, this.returnTableAlias);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.getObject(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], this.dataTypeMappingFlags, this.cal);
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not get object: " + e.getMessage(), "S1009", e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Class type cannot be null");
        }
        if (type.equals(String.class)) {
            return (T)this.getString(parameterIndex);
        }
        if (type.equals(Integer.class)) {
            this.getInt(parameterIndex);
        } else {
            if (type.equals(Long.class)) {
                return (T)Long.valueOf(this.getLong(parameterIndex));
            }
            if (type.equals(Short.class)) {
                return (T)Short.valueOf(this.getShort(parameterIndex));
            }
            if (type.equals(Double.class)) {
                return (T)Double.valueOf(this.getDouble(parameterIndex));
            }
            if (type.equals(Float.class)) {
                return (T)Float.valueOf(this.getFloat(parameterIndex));
            }
            if (type.equals(Byte.class)) {
                return (T)Byte.valueOf(this.getByte(parameterIndex));
            }
            if (type.equals(byte[].class)) {
                return (T)this.getBytes(parameterIndex);
            }
            if (type.equals(Date.class)) {
                return (T)this.getDate(parameterIndex);
            }
            if (type.equals(Time.class)) {
                return (T)this.getTime(parameterIndex);
            }
            if (type.equals(Timestamp.class)) {
                return (T)this.getTimestamp(parameterIndex);
            }
            if (type.equals(Boolean.class)) {
                return (T)Boolean.valueOf(this.getBoolean(parameterIndex));
            }
            if (type.equals(Blob.class)) {
                return (T)this.getBlob(parameterIndex);
            }
            if (type.equals(Clob.class)) {
                return (T)this.getClob(parameterIndex);
            }
            if (type.equals(NClob.class)) {
                return (T)this.getNClob(parameterIndex);
            }
            if (type.equals(InputStream.class)) {
                return (T)this.getBinaryStream(parameterIndex);
            }
            if (type.equals(Reader.class)) {
                return (T)this.getCharacterStream(parameterIndex);
            }
            if (type.equals(BigDecimal.class)) {
                return (T)this.getBigDecimal(parameterIndex);
            }
            if (type.equals(BigInteger.class)) {
                return (T)this.getBigInteger(this.checkObjectRange(parameterIndex), this.columnsInformation[parameterIndex - 1]);
            }
            if (type.equals(Clob.class)) {
                return (T)this.getClob(parameterIndex);
            }
        }
        Object obj = this.getObject(parameterIndex);
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isInstance(type)) {
            return (T)obj;
        }
        throw new SQLException("result cannot be cast as  '" + type.getName() + "' (is '" + obj.getClass().getName() + "'");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> arg1) throws SQLException {
        return (T)this.getObject(this.findColumn(columnLabel));
    }

    private Object getObject(byte[] rawBytes, ColumnInformation columnInfo, int dataTypeMappingFlags, Calendar cal) throws SQLException, ParseException {
        if (rawBytes == null) {
            return null;
        }
        switch (columnInfo.getType()) {
            case BIT: {
                if (columnInfo.getLength() == 1L) {
                    return rawBytes[0] != 0;
                }
                return rawBytes;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && columnInfo.getLength() == 1L) {
                    if (!this.isBinaryEncoded) {
                        return rawBytes[0] != 48;
                    }
                    return rawBytes[0] != 0;
                }
                return this.getInt(rawBytes, columnInfo);
            }
            case INTEGER: {
                if (!columnInfo.isSigned()) {
                    return this.getLong(rawBytes, columnInfo);
                }
                return this.getInt(rawBytes, columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.getBigInteger(rawBytes, columnInfo);
                }
                return this.getLong(rawBytes, columnInfo);
            }
            case DOUBLE: {
                return this.getDouble(rawBytes, columnInfo);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getTimestamp(rawBytes, columnInfo, cal);
            }
            case DATE: {
                return this.getDate(rawBytes, columnInfo, cal);
            }
            case VARCHAR: {
                if (columnInfo.isBinary()) {
                    return rawBytes;
                }
                return this.getString(rawBytes, columnInfo);
            }
            case DECIMAL: {
                return this.getBigDecimal(rawBytes, columnInfo);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                return rawBytes;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((dataTypeMappingFlags & 2) != 0) {
                    return this.getDate(rawBytes, columnInfo, cal);
                }
                return this.getShort(rawBytes, columnInfo);
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInt(rawBytes, columnInfo);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(rawBytes, columnInfo));
            }
            case TIME: {
                return this.getTime(rawBytes, columnInfo, cal);
            }
            case VARSTRING: 
            case STRING: {
                if (columnInfo.isBinary()) {
                    return rawBytes;
                }
                return this.getString(rawBytes, columnInfo);
            }
            case OLDDECIMAL: {
                return this.getString(rawBytes, columnInfo);
            }
            case GEOMETRY: {
                return rawBytes;
            }
            case ENUM: {
                break;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
        }
        throw new RuntimeException(columnInfo.getType().toString());
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.columnNameMap.getIndex(columnLabel) + 1;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.getString(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1]);
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting row updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting inserts are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Row deletes are not supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateByte(String columnLabel, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateShort(String columnLabel, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateInt(String columnLabel, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateFloat(String columnLabel, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDouble(String columnLabel, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateString(String columnLabel, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateDate(String columnLabel, Date value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTime(String columnLabel, Time value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateLong(String columnLabel, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Row refresh is not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Getting REFs not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.checkObjectRange(columnIndex);
        if (bytes == null) {
            return null;
        }
        return new MariaDbBlob(bytes);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        byte[] bytes = this.checkObjectRange(columnIndex);
        if (bytes == null) {
            return null;
        }
        return new MariaDbClob(bytes);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getString(this.checkObjectRange(columnIndex), this.columnsInformation[columnIndex - 1], this.cal));
        }
        catch (MalformedURLException e) {
            throw ExceptionMapper.getSqlException("Could not parse as URL");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void updateNString(int columnIndex, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        byte[] bytes = this.checkObjectRange(columnIndex);
        if (bytes == null) {
            return null;
        }
        return new MariaDbClob(bytes);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Updates not supported");
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        return this.getBoolean(this.checkObjectRange(index), this.columnsInformation[index - 1]);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    private boolean getBoolean(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        if (rawBytes == null) {
            return false;
        }
        if (!this.isBinaryEncoded) {
            if (rawBytes.length == 1 && rawBytes[0] == 0) {
                return false;
            }
            String rawVal = new String(rawBytes, StandardCharsets.UTF_8);
            return !"false".equals(rawVal) && !"0".equals(rawVal);
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0] != 0;
            }
            case TINYINT: {
                return this.getTinyInt(rawBytes, columnInfo) != 0;
            }
            case SMALLINT: 
            case YEAR: {
                return this.getSmallInt(rawBytes, columnInfo) != 0;
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getMediumInt(rawBytes, columnInfo) != 0L;
            }
            case BIGINT: {
                return this.getLong(rawBytes, columnInfo) != 0L;
            }
            case FLOAT: {
                return this.getFloat(rawBytes, columnInfo) != 0.0f;
            }
            case DOUBLE: {
                return this.getDouble(rawBytes, columnInfo) != 0.0;
            }
        }
        String rawVal = new String(rawBytes, StandardCharsets.UTF_8);
        return !"false".equals(rawVal) && !"0".equals(rawVal);
    }

    @Override
    public byte getByte(int index) throws SQLException {
        return this.getByte(this.checkObjectRange(index), this.columnsInformation[index - 1]);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    private byte getByte(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        long value;
        if (rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            if (columnInfo.getType() == MariaDbType.BIT) {
                return rawBytes[0];
            }
            return this.parseByte(rawBytes, columnInfo);
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt(rawBytes, columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getSmallInt(rawBytes, columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt(rawBytes, columnInfo);
                break;
            }
            case BIGINT: {
                value = this.getLong(rawBytes, columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getFloat(rawBytes, columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getDouble(rawBytes, columnInfo);
                break;
            }
            default: {
                return this.parseByte(rawBytes, columnInfo);
            }
        }
        this.rangeCheck(Byte.class, -128L, 127L, value, columnInfo);
        return (byte)value;
    }

    @Override
    public short getShort(int index) throws SQLException {
        return this.getShort(this.checkObjectRange(index), this.columnsInformation[index - 1]);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    private short getShort(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        long value;
        if (rawBytes == null) {
            return 0;
        }
        if (!this.isBinaryEncoded) {
            return this.parseShort(rawBytes, columnInfo);
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return rawBytes[0];
            }
            case TINYINT: {
                value = this.getTinyInt(rawBytes, columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = (rawBytes[0] & 0xFF) + ((rawBytes[1] & 0xFF) << 8);
                if (columnInfo.isSigned()) {
                    return (short)value;
                }
                value &= 0xFFFFL;
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getMediumInt(rawBytes, columnInfo);
                break;
            }
            case BIGINT: {
                value = this.getLong(rawBytes, columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getFloat(rawBytes, columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getDouble(rawBytes, columnInfo);
                break;
            }
            default: {
                return this.parseShort(rawBytes, columnInfo);
            }
        }
        this.rangeCheck(Short.class, -32768L, 32767L, value, columnInfo);
        return (short)value;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void setReturnTableAlias(boolean returnTableAlias) {
        this.returnTableAlias = returnTableAlias;
    }

    private String getTimeString(byte[] rawBytes, ColumnInformation columnInfo) {
        if (rawBytes == null) {
            return null;
        }
        if (rawBytes.length == 0) {
            if (columnInfo.getDecimals() == 0) {
                return "00:00:00";
            }
            String value = "00:00:00.";
            int decimal = columnInfo.getDecimals();
            while (decimal-- > 0) {
                value = value + "0";
            }
            return value;
        }
        String rawValue = new String(rawBytes, StandardCharsets.UTF_8);
        if (zeroDate.equals(rawValue)) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            if (this.options.maximizeMysqlCompatibility && this.options.useLegacyDatetimeCode && rawValue.indexOf(".") > 0) {
                return rawValue.substring(0, rawValue.indexOf("."));
            }
            return rawValue;
        }
        byte hour = rawBytes[5];
        int day = rawBytes[1] & 0xFF | (rawBytes[2] & 0xFF) << 8 | (rawBytes[3] & 0xFF) << 16 | (rawBytes[4] & 0xFF) << 24;
        int timeHour = hour + day * 24;
        String hourString = timeHour < 10 ? "0" + timeHour : Integer.toString(timeHour);
        byte minutes = rawBytes[6];
        String minuteString = minutes < 10 ? "0" + minutes : Integer.toString(minutes);
        byte seconds = rawBytes[7];
        String secondString = seconds < 10 ? "0" + seconds : Integer.toString(seconds);
        int microseconds = 0;
        if (rawBytes.length > 8) {
            microseconds = rawBytes[8] & 0xFF | (rawBytes[9] & 0xFF) << 8 | (rawBytes[10] & 0xFF) << 16 | (rawBytes[11] & 0xFF) << 24;
        }
        String microsecondString = Integer.toString(microseconds);
        while (microsecondString.length() < 6) {
            microsecondString = "0" + microsecondString;
        }
        boolean negative = rawBytes[0] == 1;
        return (negative ? "-" : "") + hourString + ":" + minuteString + ":" + secondString + "." + microsecondString;
    }

    private void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnInformation columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    private int getTinyInt(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        int value = rawBytes[0];
        if (!columnInfo.isSigned()) {
            value = rawBytes[0] & 0xFF;
        }
        return value;
    }

    private int getSmallInt(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        int value = (rawBytes[0] & 0xFF) + ((rawBytes[1] & 0xFF) << 8);
        if (!columnInfo.isSigned()) {
            return value & 0xFFFF;
        }
        return (short)value;
    }

    private long getMediumInt(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        long value = (rawBytes[0] & 0xFF) + ((rawBytes[1] & 0xFF) << 8) + ((rawBytes[2] & 0xFF) << 16) + ((rawBytes[3] & 0xFF) << 24);
        if (!columnInfo.isSigned()) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    private byte parseByte(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        try {
            switch (columnInfo.getType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(127.0f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Byte range", "22003", 1264);
                    }
                    return floatValue.byteValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(127.0) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Byte range", "22003", 1264);
                    }
                    return doubleValue.byteValue();
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case YEAR: {
                    long result = 0L;
                    int length = rawBytes.length;
                    boolean negate = false;
                    int begin = 0;
                    if (length > 0 && rawBytes[0] == 45) {
                        negate = true;
                        begin = 1;
                    }
                    while (begin < length) {
                        result = result * 10L + (long)rawBytes[begin] - 48L;
                        ++begin;
                    }
                    result = negate ? -1L * result : result;
                    this.rangeCheck(Byte.class, -128L, 127L, result, columnInfo);
                    return (byte)result;
                }
            }
            return Byte.parseByte(new String(rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(rawBytes, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Byte.parseByte(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Byte range", "22003", 1264);
        }
    }

    private short parseShort(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        try {
            switch (columnInfo.getType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(32767.0f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Short range", "22003", 1264);
                    }
                    return floatValue.shortValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(32767.0) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Short range", "22003", 1264);
                    }
                    return doubleValue.shortValue();
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case YEAR: {
                    long result = 0L;
                    int length = rawBytes.length;
                    boolean negate = false;
                    int begin = 0;
                    if (length > 0 && rawBytes[0] == 45) {
                        negate = true;
                        begin = 1;
                    }
                    while (begin < length) {
                        result = result * 10L + (long)rawBytes[begin] - 48L;
                        ++begin;
                    }
                    result = negate ? -1L * result : result;
                    this.rangeCheck(Short.class, -32768L, 32767L, result, columnInfo);
                    return (short)result;
                }
            }
            return Short.parseShort(new String(rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(rawBytes, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Short.parseShort(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Short range", "22003", 1264);
        }
    }

    private int parseInt(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        try {
            switch (columnInfo.getType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(2.1474836E9f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Integer range", "22003", 1264);
                    }
                    return floatValue.intValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(2.147483647E9) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Integer range", "22003", 1264);
                    }
                    return doubleValue.intValue();
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case YEAR: {
                    long result = 0L;
                    int length = rawBytes.length;
                    boolean negate = false;
                    int begin = 0;
                    if (length > 0 && rawBytes[0] == 45) {
                        negate = true;
                        begin = 1;
                    }
                    while (begin < length) {
                        result = result * 10L + (long)rawBytes[begin] - 48L;
                        ++begin;
                    }
                    result = negate ? -1L * result : result;
                    this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, result, columnInfo);
                    return (int)result;
                }
            }
            return Integer.parseInt(new String(rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(rawBytes, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Integer.parseInt(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Integer range", "22003", 1264);
        }
    }

    private long parseLong(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        try {
            switch (columnInfo.getType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return floatValue.longValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(rawBytes, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(rawBytes, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return doubleValue.longValue();
                }
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case YEAR: {
                    long result = 0L;
                    int length = rawBytes.length;
                    boolean negate = false;
                    int begin = 0;
                    if (length > 0 && rawBytes[0] == 45) {
                        negate = true;
                        begin = 1;
                    }
                    while (begin < length) {
                        result = result * 10L + (long)rawBytes[begin] - 48L;
                        ++begin;
                    }
                    return negate ? -1L * result : result;
                }
            }
            return Long.parseLong(new String(rawBytes, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(rawBytes, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Long.parseLong(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in Long range", "22003", 1264);
        }
    }

    private BigInteger getBigInteger(byte[] rawBytes, ColumnInformation columnInfo) throws SQLException {
        if (rawBytes == null) {
            return null;
        }
        if (!this.isBinaryEncoded) {
            return new BigInteger(new String(rawBytes, StandardCharsets.UTF_8));
        }
        switch (columnInfo.getType()) {
            case BIT: {
                return BigInteger.valueOf(rawBytes[0]);
            }
            case TINYINT: {
                return BigInteger.valueOf(columnInfo.isSigned() ? rawBytes[0] : rawBytes[0] & 0xFF);
            }
            case SMALLINT: 
            case YEAR: {
                int valueShort = rawBytes[0] & 0xFF | (rawBytes[1] & 0xFF) << 8;
                return BigInteger.valueOf(columnInfo.isSigned() ? valueShort : valueShort & 0xFFFF);
            }
            case INTEGER: 
            case MEDIUMINT: {
                int valueInt = (rawBytes[0] & 0xFF) + ((rawBytes[1] & 0xFF) << 8) + ((rawBytes[2] & 0xFF) << 16) + ((rawBytes[3] & 0xFF) << 24);
                return BigInteger.valueOf(columnInfo.isSigned() ? (long)valueInt : (valueInt >= 0 ? (long)valueInt : (long)valueInt & 0xFFFFFFFFL));
            }
            case BIGINT: {
                long value = (long)(rawBytes[0] & 0xFF) + ((long)(rawBytes[1] & 0xFF) << 8) + ((long)(rawBytes[2] & 0xFF) << 16) + ((long)(rawBytes[3] & 0xFF) << 24) + ((long)(rawBytes[4] & 0xFF) << 32) + ((long)(rawBytes[5] & 0xFF) << 40) + ((long)(rawBytes[6] & 0xFF) << 48) + ((long)(rawBytes[7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return BigInteger.valueOf(value);
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)(value >> 0)});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getFloat(rawBytes, columnInfo));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getDouble(rawBytes, columnInfo));
            }
        }
        return new BigInteger(new String(rawBytes, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date binaryDate(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws ParseException {
        Date dt;
        Calendar calendar;
        switch (columnInfo.getType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getTimestamp(rawBytes, columnInfo, cal);
                return timestamp == null ? null : new Date(timestamp.getTime());
            }
        }
        if (rawBytes.length == 0) {
            return null;
        }
        int year = rawBytes[0] & 0xFF | (rawBytes[1] & 0xFF) << 8;
        if (rawBytes.length == 2 && columnInfo.getLength() == 2L) {
            year = year <= 69 ? (year += 2000) : (year += 1900);
        }
        byte month = 1;
        byte day = 1;
        if (rawBytes.length >= 4) {
            month = rawBytes[2];
            day = rawBytes[3];
        }
        Calendar calendar2 = calendar = Calendar.getInstance();
        synchronized (calendar2) {
            calendar.clear();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dt = new Date(calendar.getTimeInMillis());
        }
        return dt;
    }

    private Time binaryTime(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws ParseException {
        switch (columnInfo.getType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp ts = this.binaryTimestamp(rawBytes, columnInfo, cal);
                return ts == null ? null : new Time(ts.getTime());
            }
            case DATE: {
                Calendar tmpCalendar = Calendar.getInstance();
                tmpCalendar.clear();
                tmpCalendar.set(1970, 0, 1, 0, 0, 0);
                tmpCalendar.set(14, 0);
                return new Time(tmpCalendar.getTimeInMillis());
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int day = 0;
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        boolean negate = false;
        if (rawBytes.length > 0) {
            boolean bl = negate = (rawBytes[0] & 0xFF) == 1;
        }
        if (rawBytes.length > 4) {
            day = (rawBytes[1] & 0xFF) + ((rawBytes[2] & 0xFF) << 8) + ((rawBytes[3] & 0xFF) << 16) + ((rawBytes[4] & 0xFF) << 24);
        }
        if (rawBytes.length > 7) {
            hour = rawBytes[5];
            minutes = rawBytes[6];
            seconds = rawBytes[7];
        }
        calendar.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
        int nanoseconds = 0;
        if (rawBytes.length > 8) {
            nanoseconds = (rawBytes[8] & 0xFF) + ((rawBytes[9] & 0xFF) << 8) + ((rawBytes[10] & 0xFF) << 16) + ((rawBytes[11] & 0xFF) << 24);
        }
        calendar.set(14, nanoseconds / 1000);
        return new Time(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp binaryTimestamp(byte[] rawBytes, ColumnInformation columnInfo, Calendar cal) throws ParseException {
        Timestamp tt;
        Calendar calendar;
        if (rawBytes.length == 0) {
            return null;
        }
        int day = 0;
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        int microseconds = 0;
        if (columnInfo.getType() == MariaDbType.TIME) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.clear();
            boolean negate = false;
            if (rawBytes.length > 0) {
                boolean bl = negate = (rawBytes[0] & 0xFF) == 1;
            }
            if (rawBytes.length > 4) {
                day = (rawBytes[1] & 0xFF) + ((rawBytes[2] & 0xFF) << 8) + ((rawBytes[3] & 0xFF) << 16) + ((rawBytes[4] & 0xFF) << 24);
            }
            if (rawBytes.length > 7) {
                hour = rawBytes[5];
                minutes = rawBytes[6];
                seconds = rawBytes[7];
            }
            if (rawBytes.length > 8) {
                microseconds = (rawBytes[8] & 0xFF) + ((rawBytes[9] & 0xFF) << 8) + ((rawBytes[10] & 0xFF) << 16) + ((rawBytes[11] & 0xFF) << 24);
            }
            calendar2.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
            Timestamp tt2 = new Timestamp(calendar2.getTimeInMillis());
            tt2.setNanos(microseconds * 1000);
            return tt2;
        }
        int year = rawBytes[0] & 0xFF | (rawBytes[1] & 0xFF) << 8;
        byte month = rawBytes[2];
        day = rawBytes[3];
        if (rawBytes.length > 4) {
            hour = rawBytes[4];
            minutes = rawBytes[5];
            seconds = rawBytes[6];
            if (rawBytes.length > 7) {
                microseconds = (rawBytes[7] & 0xFF) + ((rawBytes[8] & 0xFF) << 8) + ((rawBytes[9] & 0xFF) << 16) + ((rawBytes[10] & 0xFF) << 24);
            }
        }
        Calendar calendar3 = calendar = this.options.useLegacyDatetimeCode ? Calendar.getInstance() : cal;
        synchronized (calendar3) {
            calendar.set(year, month - 1, day, hour, minutes, seconds);
            tt = new Timestamp(calendar.getTimeInMillis());
        }
        tt.setNanos(microseconds * 1000);
        return tt;
    }

    private int extractNanos(String timestring) throws ParseException {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new ParseException("cannot parse subsecond part in timestamp string '" + timestring + "'", i);
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    public InputStream getInputStream(byte[] rawBytes) {
        if (rawBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(new String(rawBytes, StandardCharsets.UTF_8).getBytes());
    }

    private boolean isNull(byte[] rawBytes, MariaDbType dataType) {
        return rawBytes == null || this.isBinaryEncoded && (dataType == MariaDbType.DATE || dataType == MariaDbType.TIMESTAMP || dataType == MariaDbType.DATETIME) && rawBytes.length == 0 || !this.isBinaryEncoded && (dataType == MariaDbType.TIMESTAMP || dataType == MariaDbType.DATETIME) && zeroTimestamp.equals(new String(rawBytes, StandardCharsets.UTF_8)) || !this.isBinaryEncoded && dataType == MariaDbType.DATE && zeroDate.equals(new String(rawBytes, StandardCharsets.UTF_8));
    }
}

