/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.Deque;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class SingleExecutionResult
implements ExecutionResult {
    private MariaSelectResultSet result = null;
    private Statement statement = null;
    private boolean moreResultAvailable;
    private int fetchSize;
    private boolean selectPossible;
    private boolean canHaveCallableResultset;
    private Deque<ExecutionResult> cachedExecutionResults;
    private long insertId;
    private long affectedRows = -1L;

    public SingleExecutionResult(Statement statement, int fetchSize, boolean selectPossible, boolean canHaveCallableResultset) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = canHaveCallableResultset;
    }

    public SingleExecutionResult(Statement statement, int fetchSize, boolean selectPossible, boolean canHaveCallableResultset, boolean canHaveMoreResults) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = canHaveCallableResultset;
        this.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
    }

    public SingleExecutionResult(Statement statement, int fetchSize, boolean selectPossible, boolean canHaveCallableResultset, long affectedRows, long insertId) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = canHaveCallableResultset;
        this.insertId = insertId;
        this.affectedRows = affectedRows;
    }

    public SingleExecutionResult(Statement statement, int fetchSize, boolean selectPossible, boolean canHaveCallableResultset, MariaSelectResultSet result) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = canHaveCallableResultset;
        this.result = result;
        this.insertId = -2L;
        this.affectedRows = -1L;
    }

    @Override
    public void addResultSet(MariaSelectResultSet result, boolean moreResultAvailable) {
        this.result = result;
        this.insertId = -2L;
        this.affectedRows = -1L;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void addStats(long affectedRows, long insertId, boolean moreResultAvailable) {
        this.insertId = insertId;
        this.affectedRows = affectedRows;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public long[] getInsertIds() {
        return new long[]{this.insertId};
    }

    public long getInsertId() {
        return this.insertId;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    @Override
    public boolean hasMoreThanOneAffectedRows() {
        return this.affectedRows > 1L;
    }

    @Override
    public int getFirstAffectedRows() {
        return (int)this.affectedRows;
    }

    public void addStatsError() {
    }

    @Override
    public MariaSelectResultSet getResultSet() {
        return this.result;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public boolean hasMoreResultAvailable() {
        return this.moreResultAvailable;
    }

    protected void setMoreResultAvailable(boolean moreResultAvailable) {
        this.moreResultAvailable = moreResultAvailable;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void close() throws SQLException {
        if (this.result != null) {
            this.result.close();
        }
    }

    @Override
    public boolean isSelectPossible() {
        return this.selectPossible;
    }

    @Override
    public boolean isCanHaveCallableResultset() {
        return this.canHaveCallableResultset;
    }

    @Override
    public Deque<ExecutionResult> getCachedExecutionResults() {
        return this.cachedExecutionResults;
    }

    @Override
    public boolean isSingleExecutionResult() {
        return true;
    }
}

