/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiFixedIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiVariableIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MariaDbStatement
implements Statement,
Cloneable {
    private static final ScheduledExecutorService timeoutScheduler = SchedulerServiceProviderHolder.getTimeoutScheduler();
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected Future<?> timerTaskFuture;
    protected ResultSet batchResultSet = null;
    protected volatile boolean closed = false;
    boolean isTimedout;
    volatile boolean executing;
    private List<String> batchQueries;
    private boolean warningsCleared;
    protected int queryTimeout;
    private int fetchSize;
    protected int maxRows;
    protected final ReentrantLock lock;
    protected ExecutionResult executionResult = null;
    protected int resultSetScrollType;
    protected boolean mustCloseOnCompletion = false;
    protected Options options;

    public MariaDbStatement(MariaDbConnection connection, int resultSetScrollType) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.resultSetScrollType = resultSetScrollType;
        this.lock = this.connection.lock;
        this.options = this.protocol.getOptions();
    }

    public MariaDbStatement clone() throws CloneNotSupportedException {
        MariaDbStatement clone = (MariaDbStatement)super.clone();
        clone.connection = this.connection;
        clone.protocol = this.protocol;
        clone.timerTaskFuture = null;
        clone.batchQueries = new ArrayList<String>();
        clone.executionResult = null;
        clone.closed = false;
        clone.warningsCleared = true;
        clone.fetchSize = 0;
        clone.maxRows = 0;
        return clone;
    }

    public static void unloadDriver() {
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    protected void setTimerTask() {
        assert (this.timerTaskFuture == null);
        this.timerTaskFuture = timeoutScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryProlog() throws SQLException {
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prolog(this.executionResult, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void stopTimeoutTask() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }

    protected void executeQueryEpilog(QueryException queryException) throws SQLException {
        this.stopTimeoutTask();
        if (this.isTimedout) {
            this.isTimedout = false;
            queryException = new QueryException("Query timed out", 1317, "JZ0002", queryException);
        }
        if (queryException == null) {
            return;
        }
        if (queryException.getSqlState() != null && queryException.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwException(queryException, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(String sql, int fetchSize) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            ExecutionResult internalExecutionResult = this.options.allowMultiQueries || this.options.rewriteBatchedStatements ? new MultiVariableIntExecutionResult(this, 1, fetchSize, true) : new SingleExecutionResult((Statement)this, fetchSize, true, false, true);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), internalExecutionResult, Utils.nativeSql(sql, this.connection.noBackslashEscapes), this.resultSetScrollType);
            this.executionResult = internalExecutionResult;
            boolean bl = this.executionResult.getResultSet() != null;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, this.fetchSize);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return this.executionResult.getResultSet();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            boolean hasMoreResult = false;
            if (this.executionResult != null) {
                hasMoreResult = this.executionResult.hasMoreResultAvailable();
                if (this.executionResult.getFetchSize() > 0) {
                    this.executionResult.close();
                }
                this.executionResult = null;
            }
            if (hasMoreResult) {
                this.connection.lock.lock();
                try {
                    this.skipMoreResults();
                }
                finally {
                    this.protocol = null;
                    this.connection.lock.unlock();
                }
            } else {
                this.protocol = null;
            }
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ResultSet retrieveCallableResult() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResultSet() != null && this.executionResult.getResultSet().isCallableResult()) {
            MariaSelectResultSet resultSet = this.executionResult.getResultSet();
            this.getMoreResults();
            return resultSet;
        }
        for (ExecutionResult batchExecutionResult : this.executionResult.getCachedExecutionResults()) {
            if (batchExecutionResult.getResultSet() == null || batchExecutionResult.getResultSet() == null || !batchExecutionResult.getResultSet().isCallableResult()) continue;
            MariaSelectResultSet resultSet = batchExecutionResult.getResultSet();
            this.executionResult.getCachedExecutionResults().remove(batchExecutionResult);
            return resultSet;
        }
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClose();
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.executionResult != null && this.executionResult.getResultSet() == null) {
            int autoIncrementIncrement = this.connection.getAutoIncrementIncrement();
            if (this.executionResult.hasMoreThanOneAffectedRows()) {
                long[] data;
                if (this.executionResult.isSingleExecutionResult()) {
                    int updateCount = this.executionResult.getFirstAffectedRows();
                    data = new long[updateCount];
                    for (int i = 0; i < updateCount; ++i) {
                        data[i] = ((SingleExecutionResult)this.executionResult).getInsertId() + (long)(i * autoIncrementIncrement);
                    }
                } else {
                    MultiExecutionResult multiExecution = (MultiExecutionResult)this.executionResult;
                    int size = 0;
                    int affectedRowslength = multiExecution.getAffectedRows().length;
                    for (int i = 0; i < affectedRowslength; ++i) {
                        size += multiExecution.getAffectedRows()[i];
                    }
                    data = new long[size];
                    for (int affectedRows = 0; affectedRows < affectedRowslength; ++affectedRows) {
                        for (int i = 0; i < multiExecution.getAffectedRows()[affectedRows]; ++i) {
                            data[i] = multiExecution.getInsertIds()[affectedRows] + (long)(i * autoIncrementIncrement);
                        }
                    }
                }
                return MariaSelectResultSet.createGeneratedData(data, this.connection.getProtocol(), true);
            }
            return MariaSelectResultSet.createGeneratedData(this.executionResult.getInsertIds(), this.connection.getProtocol(), true);
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        if (this.executionResult != null) {
            return this.executionResult.getResultSet();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.executionResult == null) {
            return -1;
        }
        if (this.executionResult.isSingleExecutionResult()) {
            return (int)((SingleExecutionResult)this.executionResult).getAffectedRows();
        }
        return ((MultiExecutionResult)this.executionResult).getFirstAffectedRows();
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.executionResult != null) {
            if (this.executionResult.getFetchSize() == 0) {
                this.executionResult = this.executionResult.getCachedExecutionResults() == null ? null : this.executionResult.getCachedExecutionResults().poll();
                return this.executionResult != null && this.executionResult.getResultSet() != null;
            }
            this.checkClose();
            this.lock.lock();
            try {
                this.executionResult.close();
                SingleExecutionResult internalExecutionResult = new SingleExecutionResult(this, this.fetchSize, true, false);
                if (internalExecutionResult.hasMoreResultAvailable()) {
                    this.protocol.getMoreResults(internalExecutionResult);
                    this.executionResult = internalExecutionResult;
                    boolean bl = this.executionResult.getResultSet() != null;
                    return bl;
                }
                this.executionResult = null;
                boolean bl = false;
                return bl;
            }
            catch (QueryException queryException) {
                ExceptionMapper.throwException(queryException, this.connection, this);
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        if (rows == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetScrollType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        if (sql == null) {
            throw ExceptionMapper.getSqlException("null cannot be set to addBatch( String sql)");
        }
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        if (this.batchQueries == null || this.batchQueries.size() == 0) {
            return new int[0];
        }
        MultiFixedIntExecutionResult internalExecutionResult = new MultiFixedIntExecutionResult(this, this.batchQueries.size(), 0, false);
        boolean multipleExecution = false;
        this.lock.lock();
        try {
            QueryException exception = null;
            this.executing = true;
            this.executeQueryProlog();
            try {
                if (this.options.rewriteBatchedStatements) {
                    boolean batchQueryMultiRewritable = true;
                    for (String query : this.batchQueries) {
                        if (ClientPrepareResult.isRewritableBatch(query, this.connection.noBackslashEscapes)) continue;
                        batchQueryMultiRewritable = false;
                        break;
                    }
                    if (batchQueryMultiRewritable) {
                        multipleExecution = true;
                        this.protocol.executeBatchMultiple(this.protocol.isMasterConnection(), internalExecutionResult, this.batchQueries, this.resultSetScrollType);
                        internalExecutionResult.updateResultsMultiple(this.batchQueries.size(), false);
                    } else {
                        this.protocol.executeBatch(this.protocol.isMasterConnection(), internalExecutionResult, this.batchQueries, this.resultSetScrollType);
                    }
                } else {
                    this.protocol.executeBatch(this.protocol.isMasterConnection(), internalExecutionResult, this.batchQueries, this.resultSetScrollType);
                }
            }
            catch (QueryException e) {
                exception = e;
            }
            finally {
                if (exception != null && multipleExecution) {
                    internalExecutionResult.updateResultsMultiple(this.batchQueries.size(), true);
                }
                this.executionResult = internalExecutionResult;
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
            int[] nArray = internalExecutionResult.getAffectedRows();
            return nArray;
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.mustCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.mustCloseOnCompletion;
    }

    public void checkCloseOnCompletion(ResultSet resultSet) throws SQLException {
        if (this.mustCloseOnCompletion && !this.closed && this.executionResult != null && resultSet.equals(this.executionResult.getResultSet())) {
            this.close();
        }
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }
}

