/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.MariaDbThreadFactory;

public class DynamicSizedSchedulerImpl
extends ScheduledThreadPoolExecutor
implements DynamicSizedSchedulerInterface {
    public DynamicSizedSchedulerImpl(int corePoolSize) {
        super(corePoolSize, new MariaDbThreadFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolSize(int newSize) {
        DynamicSizedSchedulerImpl dynamicSizedSchedulerImpl = this;
        synchronized (dynamicSizedSchedulerImpl) {
            super.setCorePoolSize(newSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustPoolSize(int delta) {
        DynamicSizedSchedulerImpl dynamicSizedSchedulerImpl = this;
        synchronized (dynamicSizedSchedulerImpl) {
            super.setCorePoolSize(Math.max(0, super.getCorePoolSize() + delta));
        }
    }

    @Override
    public Future<?> addThreadAndExecute(Runnable task) {
        return this.addThreadAndSchedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> addThreadAndSchedule(Runnable task, long delay, TimeUnit unit) {
        this.adjustPoolSize(1);
        PoolSizeDecreaseFuture result = new PoolSizeDecreaseFuture(task);
        if (delay == 0L) {
            super.execute(result);
        } else {
            super.schedule(result, delay, unit);
        }
        return result;
    }

    private class PoolSizeDecreaseFuture
    extends FutureTask<Object> {
        public PoolSizeDecreaseFuture(Runnable runnable) {
            super(runnable, null);
        }

        @Override
        protected void done() {
            DynamicSizedSchedulerImpl.this.adjustPoolSize(-1);
        }
    }
}

