/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.dao;

import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;

public class PrepareResult {
    private final int statementId;
    private final ColumnInformation[] columns;
    private final ColumnInformation[] parameters;
    private volatile int useTime = 1;
    private volatile boolean isClosing;

    public PrepareResult(int statementId, ColumnInformation[] columns, ColumnInformation[] parameters) {
        this.statementId = statementId;
        this.columns = columns;
        this.parameters = parameters;
    }

    public synchronized boolean addUse() {
        if (this.isClosing) {
            return false;
        }
        ++this.useTime;
        return true;
    }

    public synchronized void removeUse() {
        --this.useTime;
    }

    public synchronized boolean setClosedIfUnused() {
        if (this.useTime > 0) {
            return false;
        }
        this.isClosing = true;
        return true;
    }

    public synchronized int getUseTime() {
        return this.useTime;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnInformation[] getColumns() {
        return this.columns;
    }

    public ColumnInformation[] getParameters() {
        return this.parameters;
    }
}

