/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.SQLException;
import java.sql.Statement;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;

public abstract class ExecutionResult {
    protected MariaSelectResultSet result = null;
    private Statement statement = null;
    private PrepareResult failureObject = null;
    private boolean moreResultAvailable;
    private int fetchSize;
    private boolean selectPossible;
    private boolean canHaveCallableResultset;

    public ExecutionResult(Statement statement, int fetchSize, boolean selectPossible, boolean canHaveCallableResultset) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = canHaveCallableResultset;
    }

    public MariaSelectResultSet getResult() {
        return this.result;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public PrepareResult getFailureObject() {
        return this.failureObject;
    }

    public void setFailureObject(PrepareResult failureObject) {
        this.failureObject = failureObject;
    }

    public boolean hasMoreResultAvailable() {
        return this.moreResultAvailable;
    }

    protected void setMoreResultAvailable(boolean moreResultAvailable) {
        this.moreResultAvailable = moreResultAvailable;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void close() throws SQLException {
        if (this.result != null) {
            this.result.close();
        }
    }

    public abstract void addResult(MariaSelectResultSet var1, boolean var2);

    public abstract void addStats(long var1, long var3, boolean var5);

    public abstract long[] getInsertIds();

    public abstract boolean hasMoreThanOneAffectedRows();

    public abstract int getFirstAffectedRows();

    public abstract void addStatsError();

    public boolean isSelectPossible() {
        return this.selectPossible;
    }

    public boolean isCanHaveCallableResultset() {
        return this.canHaveCallableResultset;
    }
}

