/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.read.RawPacket;
import org.mariadb.jdbc.internal.packet.read.ReadResultPacketFactory;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.LocalInfilePacket;
import org.mariadb.jdbc.internal.packet.result.OkPacket;
import org.mariadb.jdbc.internal.packet.result.ResultSetPacket;
import org.mariadb.jdbc.internal.packet.send.SendChangeDbPacket;
import org.mariadb.jdbc.internal.packet.send.SendClosePrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendExecutePrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendPingPacket;
import org.mariadb.jdbc.internal.packet.send.SendPrepareParameterPacket;
import org.mariadb.jdbc.internal.packet.send.SendPrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendTextQueryPacket;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.stream.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.PrepareStatementCache;
import org.mariadb.jdbc.internal.util.buffer.Reader;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareStatementCacheKey;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private int transactionIsolationLevel = 0;
    private InputStream localInfileInputStream;
    private int maxRows;

    public AbstractQueryProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] bit = new byte[bb.remaining()];
        bb.mark();
        bb.get(bit);
        bb.reset();
        return AbstractQueryProtocol.hexdump(bit, offset);
    }

    @Override
    public PrepareResult prepare(String sql) throws QueryException {
        this.checkClose();
        try {
            PrepareResult pr;
            PrepareStatementCacheKey prepareStatementCacheKey = new PrepareStatementCacheKey(this.database, sql);
            if (this.urlParser.getOptions().cachePrepStmts && this.prepareStatementCache.containsKey(prepareStatementCacheKey) && (pr = (PrepareResult)this.prepareStatementCache.get(prepareStatementCacheKey)).addUse()) {
                return pr;
            }
            SendPrepareStatementPacket sendPrepareStatementPacket = new SendPrepareStatementPacket(sql);
            sendPrepareStatementPacket.send(this.writer);
            ByteBuffer byteBuffer = this.packetFetcher.getReusableBuffer();
            if (byteBuffer.get(0) == -1) {
                ErrorPacket ep = new ErrorPacket(byteBuffer);
                String message = ep.getMessage();
                throw new QueryException("Error preparing query: " + message, ep.getErrorNumber(), ep.getSqlState());
            }
            byte bit = byteBuffer.get(0);
            if (bit == 0) {
                Reader reader = new Reader(byteBuffer);
                reader.readByte();
                int statementId = reader.readInt();
                int numColumns = reader.readShort();
                int numParams = reader.readShort();
                reader.readByte();
                this.hasWarnings = reader.readShort() > 0;
                ColumnInformation[] params = new ColumnInformation[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new ColumnInformation(this.packetFetcher.getRawPacket().getByteBuffer());
                    }
                    this.readEofPacket();
                }
                ColumnInformation[] columns = new ColumnInformation[numColumns];
                if (numColumns > 0) {
                    for (int i = 0; i < numColumns; ++i) {
                        columns[i] = new ColumnInformation(this.packetFetcher.getRawPacket().getByteBuffer());
                    }
                    this.readEofPacket();
                }
                PrepareResult prepareResult = new PrepareResult(statementId, columns, params);
                if (this.urlParser.getOptions().cachePrepStmts && sql != null && sql.length() < this.urlParser.getOptions().prepStmtCacheSqlLimit) {
                    this.prepareStatementCache.put(prepareStatementCacheKey, prepareResult);
                }
                return prepareResult;
            }
            throw new QueryException("Unexpected packet returned by server, first byte " + bit);
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void closePreparedStatement(int statementId) throws QueryException {
        this.lock.lock();
        try {
            this.writer.startPacket(0);
            this.writer.write(25);
            this.writer.write(statementId);
            this.writer.finishPacket();
        }
        catch (IOException e) {
            throw new QueryException(e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean getAutocommit() {
        this.lock.lock();
        try {
            boolean bl = (this.serverStatus & ServerStatus.AUTOCOMMIT) != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & ServerStatus.IN_TRANSACTION) != 0;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void rollback() {
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery(new MariaDbQuery("ROLLBACK"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCatalog(String database) throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendChangeDbPacket packet = new SendChangeDbPacket(database);
            packet.send(this.writer);
            ByteBuffer byteBuffer = this.packetFetcher.getReusableBuffer();
            if (byteBuffer.get(0) == -1) {
                AbstractResultPacket rs = ReadResultPacketFactory.createResultPacket(byteBuffer);
                ErrorPacket ep = (ErrorPacket)rs;
                throw new QueryException("Could not select database '" + database + "' : " + ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw new QueryException("Could not select database '" + database + "' :" + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean ping() throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendPingPacket pingPacket = new SendPingPacket();
            try {
                pingPacket.send(this.writer);
                ByteBuffer byteBuffer = this.packetFetcher.getReusableBuffer();
                boolean bl = byteBuffer.get(0) == 0;
                return bl;
            }
            catch (IOException e) {
                throw new QueryException("Could not ping: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ExecutionResult executeQuery(Query query) throws QueryException {
        query.validate();
        SingleExecutionResult executionResult = new SingleExecutionResult(null, 0, true, false);
        this.executeQueryInternal(executionResult, new SendTextQueryPacket(query), 1003, query);
        return executionResult;
    }

    @Override
    public void executeQuery(Query query, ExecutionResult executionResult, int resultSetScrollType, int fetchSize) throws QueryException {
        query.validate();
        this.executeQueryInternal(executionResult, new SendTextQueryPacket(query), resultSetScrollType, query);
    }

    @Override
    public void executeMultiQueries(Deque<Query> queries, ExecutionResult executionResult, int resultSetScrollType, boolean isRewritable, int rewriteOffset) throws QueryException {
        for (Query query : queries) {
            query.validate();
        }
        QueryException queryException = null;
        do {
            try {
                SendTextQueryPacket packet = new SendTextQueryPacket(queries, isRewritable, rewriteOffset);
                this.executeQueryInternal(executionResult, packet, resultSetScrollType, queries);
            }
            catch (QueryException exception) {
                if (this.getOptions().continueBatchOnError) {
                    if (queryException != null) continue;
                    queryException = exception;
                    continue;
                }
                throw exception;
            }
        } while (!queries.isEmpty());
        if (queryException != null) {
            throw queryException;
        }
    }

    @Override
    public void executeQueries(Deque<Query> queries, ExecutionResult executionResult, int resultSetScrollType) throws QueryException {
        for (Query query : queries) {
            query.validate();
        }
        QueryException queryException = null;
        do {
            try {
                Query query;
                query = queries.poll();
                SendTextQueryPacket packet = new SendTextQueryPacket(query);
                this.executeQueryInternal(executionResult, packet, resultSetScrollType, query);
            }
            catch (QueryException exception) {
                if (this.getOptions().continueBatchOnError) {
                    if (queryException != null) continue;
                    queryException = exception;
                    continue;
                }
                throw exception;
            }
        } while (!queries.isEmpty());
        if (queryException != null) {
            throw queryException;
        }
    }

    private void executeQueryInternal(ExecutionResult executionResult, SendTextQueryPacket packet, int resultSetScrollType, Object queriesObj) throws QueryException {
        this.checkClose();
        try {
            this.resetMoreResults();
            packet.send(this.writer);
            this.getResult(executionResult, resultSetScrollType, false);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        catch (QueryException qex) {
            String queryString = null;
            if (queriesObj != null) {
                Query query;
                if (queriesObj instanceof Query) {
                    queryString = ((Query)queriesObj).toString();
                } else if (queriesObj instanceof ArrayDeque && (query = (Query)((ArrayDeque)queriesObj).peek()) != null) {
                    queryString = query.toString();
                }
            }
            if (queryString != null) {
                if (queryString.length() > 1024) {
                    queryString = queryString.substring(0, 1024);
                }
                qex.setMessage(qex.getMessage() + "\nQuery is: " + queryString);
            }
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    @Override
    public void getResult(ExecutionResult executionResult, int resultSetScrollType, boolean binaryProtocol) throws QueryException {
        AbstractResultPacket resultPacket;
        RawPacket rawPacket = null;
        try {
            rawPacket = this.packetFetcher.getReusableRawPacket();
            resultPacket = ReadResultPacketFactory.createResultPacket(rawPacket.getByteBuffer());
            if (resultPacket.getResultType() == AbstractResultPacket.ResultType.LOCALINFILE) {
                InputStream is;
                if (this.localInfileInputStream == null) {
                    if (!this.getUrlParser().getOptions().allowLocalInfile) {
                        this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                        throw new QueryException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", -1, ExceptionMapper.SqlStates.FEATURE_NOT_SUPPORTED.getSqlState());
                    }
                    LocalInfilePacket localInfilePacket = (LocalInfilePacket)resultPacket;
                    String localInfile = localInfilePacket.getFileName();
                    try {
                        URL url = new URL(localInfile);
                        is = url.openStream();
                    }
                    catch (IOException ioe) {
                        try {
                            is = new FileInputStream(localInfile);
                        }
                        catch (FileNotFoundException f) {
                            this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                            ReadResultPacketFactory.createResultPacket(this.packetFetcher);
                            throw new QueryException("Could not send file : " + f.getMessage(), -1, "22000", f);
                        }
                    }
                } else {
                    is = this.localInfileInputStream;
                    this.localInfileInputStream = null;
                }
                this.writer.sendFile(is, rawPacket.getPacketSeq() + 1);
                is.close();
                resultPacket = ReadResultPacketFactory.createResultPacket(this.packetFetcher);
            }
        }
        catch (SocketTimeoutException ste) {
            this.close();
            throw new QueryException("Could not read resultset: " + ste.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), ste);
        }
        catch (IOException e) {
            try {
                if (this.writer != null && rawPacket != null) {
                    this.writer.writeEmptyPacket(rawPacket.getPacketSeq() + 1);
                    ReadResultPacketFactory.createResultPacket(this.packetFetcher);
                }
            }
            catch (IOException localInfilePacket) {
                // empty catch block
            }
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                this.resetMoreResults();
                this.hasWarnings = false;
                executionResult.addStatsError();
                ErrorPacket ep = (ErrorPacket)resultPacket;
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OkPacket okpacket = (OkPacket)resultPacket;
                this.serverStatus = okpacket.getServerStatus();
                this.setMoreResults((this.serverStatus & ServerStatus.MORE_RESULTS_EXISTS) != 0, binaryProtocol);
                this.hasWarnings = okpacket.getWarnings() > 0;
                executionResult.addStats(okpacket.getAffectedRows(), okpacket.getInsertId(), this.hasMoreResults());
                break;
            }
            case RESULTSET: {
                this.hasWarnings = false;
                ResultSetPacket resultSetPacket = (ResultSetPacket)resultPacket;
                try {
                    MariaSelectResultSet mariaSelectResultSet = MariaSelectResultSet.createResult(executionResult.getStatement(), resultSetPacket, this.packetFetcher, this, binaryProtocol, resultSetScrollType, executionResult.getFetchSize(), executionResult.isCanHaveCallableResultset());
                    if (!executionResult.isSelectPossible()) {
                        throw new QueryException("Select command are not permitted via executeBatch() command");
                    }
                    executionResult.addResult(mariaSelectResultSet, this.hasMoreResults());
                    break;
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
            default: {
                throw new QueryException("Could not parse result", -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState());
            }
        }
    }

    @Override
    public void executePreparedQueryAfterFailover(String sql, ExecutionResult executionResult, ParameterHolder[] parameters, PrepareResult prepareResult, MariaDbType[] parameterTypeHeader, int resultSetScrollType) throws QueryException {
        PrepareResult prepareResultNew = this.prepare(sql);
        this.executePreparedQuery(sql, executionResult, parameters, prepareResultNew, parameterTypeHeader, resultSetScrollType);
        executionResult.setFailureObject(prepareResult);
    }

    @Override
    public void executePreparedQuery(String sql, ExecutionResult executionResult, ParameterHolder[] parameters, PrepareResult prepareResult, MariaDbType[] parameterTypeHeader, int resultSetScrollType) throws QueryException {
        this.checkClose();
        this.resetMoreResults();
        try {
            int parameterCount = parameters.length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                SendPrepareParameterPacket sendPrepareParameterPacket = new SendPrepareParameterPacket(i, (LongDataParameterHolder)parameters[i], prepareResult.getStatementId(), this.charset);
                sendPrepareParameterPacket.send(this.writer);
            }
            SendExecutePrepareStatementPacket packet = new SendExecutePrepareStatementPacket(prepareResult.getStatementId(), parameters, parameterCount, parameterTypeHeader);
            packet.send(this.writer);
            this.getResult(executionResult, resultSetScrollType, true);
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        catch (QueryException qex) {
            if (sql.length() > 1024) {
                qex.setMessage(qex.getMessage() + "\nQuery is: " + sql.substring(0, 1024));
            } else {
                qex.setMessage(qex.getMessage() + "\nQuery is: " + sql);
            }
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
    }

    @Override
    public void releasePrepareStatement(String sql, int statementId) throws QueryException {
        PrepareStatementCacheKey prepareStatementCacheKey = new PrepareStatementCacheKey(this.database, sql);
        if (this.urlParser.getOptions().cachePrepStmts && this.prepareStatementCache.containsKey(prepareStatementCacheKey)) {
            PrepareResult pr = (PrepareResult)this.prepareStatementCache.get(prepareStatementCacheKey);
            if (pr != null) {
                pr.removeUse();
            }
        } else {
            this.forceReleasePrepareStatement(statementId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceReleasePrepareStatement(int statementId) throws QueryException {
        this.checkClose();
        this.lock.lock();
        try {
            SendClosePrepareStatementPacket packet = new SendClosePrepareStatementPacket(statementId);
            try {
                packet.send(this.writer);
            }
            catch (IOException e) {
                throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancelCurrentQuery() throws QueryException, IOException {
        MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new ReentrantLock());
        copiedProtocol.setHostAddress(this.getHostAddress());
        copiedProtocol.connect();
        copiedProtocol.executeQuery(new MariaDbQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    @Override
    public void getMoreResults(ExecutionResult executionResult) throws QueryException {
        if (!this.hasMoreResults()) {
            return;
        }
        this.getResult(executionResult, 1003, this.activeResult != null ? this.activeResult.isBinaryProtocol() : this.moreResultsTypeBinary);
    }

    @Override
    public boolean hasUnreadData() {
        this.lock.lock();
        try {
            boolean bl = this.activeResult != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setInternalMaxRows(int max) {
        if (this.maxRows != max) {
            this.maxRows = max;
        }
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws QueryException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery(new MariaDbQuery("set @@SQL_SELECT_LIMIT=DEFAULT"));
            } else {
                this.executeQuery(new MariaDbQuery("set @@SQL_SELECT_LIMIT=" + max));
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            this.getOptions().socketTimeout = timeout;
            this.socket.setSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws QueryException {
        this.lock.lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new QueryException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(new MariaDbQuery(query));
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws QueryException {
        if (!this.connected) {
            throw new QueryException("Connection is close", 1220, "08000");
        }
    }

    @Override
    public void closeIfActiveResult() throws SQLException {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
    }

    @Override
    public PrepareStatementCache prepareStatementCache() {
        return this.prepareStatementCache;
    }
}

