/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.send.SendChangeDbPacket;
import org.mariadb.jdbc.internal.packet.send.SendClosePrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendExecutePrepareStatementPacket;
import org.mariadb.jdbc.internal.packet.send.SendPingPacket;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.CachedSelectResult;
import org.mariadb.jdbc.internal.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.queryresults.UpdateResult;
import org.mariadb.jdbc.internal.stream.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.PrepareStatementCache;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private int transactionIsolationLevel = 0;
    private InputStream localInfileInputStream;
    private int maxRows;

    public AbstractQueryProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] bit = new byte[bb.remaining()];
        bb.mark();
        bb.get(bit);
        bb.reset();
        return AbstractQueryProtocol.hexdump(bit, offset);
    }

    @Override
    public PrepareResult prepare(String sql, boolean forceNew) throws QueryException {
        this.lock.lock();
        try {
            PrepareResult pr;
            if (this.activeResult != null) {
                throw new QueryException("There is an open result set on the current connection, which must be closed prior to executing a query");
            }
            this.checkClose();
            String key = null;
            if (!forceNew && this.urlParser.getOptions().cachePrepStmts && (pr = (PrepareResult)this.prepareStatementCache.get(key = this.database + "-" + sql)) != null && pr.incrementShareCounter()) {
                PrepareResult prepareResult = pr;
                return prepareResult;
            }
            this.writer.sendPreparePacket(sql);
            Buffer buffer = this.packetFetcher.getReusableBuffer();
            byte firstByte = buffer.getByteAt(0);
            if (firstByte == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                String message = ep.getMessage();
                throw new QueryException("Error preparing query: " + message, ep.getErrorNumber(), ep.getSqlState());
            }
            if (firstByte == 0) {
                buffer.readByte();
                int statementId = buffer.readInt();
                int numColumns = buffer.readShort();
                int numParams = buffer.readShort();
                buffer.readByte();
                this.hasWarnings = buffer.readShort() > 0;
                ColumnInformation[] params = new ColumnInformation[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new ColumnInformation(this.packetFetcher.getPacket());
                    }
                    this.readEofPacket();
                }
                ColumnInformation[] columns = new ColumnInformation[numColumns];
                if (numColumns > 0) {
                    for (int i = 0; i < numColumns; ++i) {
                        columns[i] = new ColumnInformation(this.packetFetcher.getPacket());
                    }
                    this.readEofPacket();
                }
                PrepareResult prepareResult = new PrepareResult(statementId, columns, params, this);
                if (this.urlParser.getOptions().cachePrepStmts && sql != null && sql.length() < this.urlParser.getOptions().prepStmtCacheSqlLimit) {
                    PrepareResult cachedPrepareResult = this.prepareStatementCache.put(key, prepareResult, forceNew);
                    PrepareResult prepareResult2 = cachedPrepareResult != null ? cachedPrepareResult : prepareResult;
                    return prepareResult2;
                }
                PrepareResult prepareResult3 = prepareResult;
                return prepareResult3;
            }
            try {
                throw new QueryException("Unexpected packet returned by server, first byte " + firstByte);
            }
            catch (IOException e) {
                throw new QueryException(e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean getAutocommit() {
        this.lock.lock();
        try {
            boolean bl = (this.serverStatus & ServerStatus.AUTOCOMMIT) != 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & ServerStatus.IN_TRANSACTION) != 0;
    }

    @Override
    public boolean hasMoreResults() {
        return this.moreResults;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void rollback() {
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery("ROLLBACK", false);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCatalog(String database) throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendChangeDbPacket packet = new SendChangeDbPacket(database);
            packet.send(this.writer);
            Buffer buffer = this.packetFetcher.getReusableBuffer();
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new QueryException("Could not select database '" + database + "' : " + ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw new QueryException("Could not select database '" + database + "' :" + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean ping() throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendPingPacket pingPacket = new SendPingPacket();
            try {
                pingPacket.send(this.writer);
                Buffer buffer = this.packetFetcher.getReusableBuffer();
                boolean bl = buffer.getByteAt(0) == 0;
                return bl;
            }
            catch (IOException e) {
                throw new QueryException("Could not ping: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private AbstractQueryResult sendLocalFile(String fileName) throws IOException, QueryException {
        InputStream is;
        int seq = 2;
        if (this.localInfileInputStream == null) {
            if (!this.getUrlParser().getOptions().allowLocalInfile) {
                this.writer.writeEmptyPacket(seq++);
                throw new QueryException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", -1, ExceptionMapper.SqlStates.FEATURE_NOT_SUPPORTED.getSqlState());
            }
            try {
                URL url = new URL(fileName);
                is = url.openStream();
            }
            catch (IOException ioe) {
                try {
                    is = new FileInputStream(fileName);
                }
                catch (FileNotFoundException f) {
                    this.writer.writeEmptyPacket(seq++);
                    this.packetFetcher.getReusableBuffer();
                    throw new QueryException("Could not send file : " + f.getMessage(), -1, "22000", f);
                }
            }
        } else {
            is = this.localInfileInputStream;
            this.localInfileInputStream = null;
        }
        this.writer.sendFile(is, seq);
        is.close();
        return this.getResult(false, false);
    }

    @Override
    public AbstractQueryResult executePreparedQueryAfterFailover(PrepareResult oldPrepareResult, String sql, ParameterHolder[] parameters, MariaDbType[] parameterTypeHeader, boolean isStreaming) throws QueryException {
        PrepareResult prepareResult = this.prepare(sql, true);
        for (int i = 0; i < parameterTypeHeader.length; ++i) {
            parameterTypeHeader[i] = null;
        }
        oldPrepareResult.failover(prepareResult.getStatementId(), this);
        return this.executePreparedQuery(oldPrepareResult, sql, parameters, parameterTypeHeader, isStreaming);
    }

    @Override
    public AbstractQueryResult executePreparedQuery(PrepareResult prepareResult, String sql, ParameterHolder[] parameters, MariaDbType[] parameterTypeHeader, boolean isStreaming) throws QueryException {
        this.checkClose();
        this.moreResults = false;
        try {
            int parameterCount = parameters.length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                this.writer.startPacket(0);
                this.writer.buffer.put((byte)24);
                this.writer.buffer.putInt(prepareResult.getStatementId());
                this.writer.buffer.putShort((short)i);
                ((LongDataParameterHolder)parameters[i]).writeBinary(this.writer);
                this.writer.finishPacket();
            }
            SendExecutePrepareStatementPacket packet = new SendExecutePrepareStatementPacket(prepareResult.getStatementId(), parameters, parameterCount, parameterTypeHeader);
            packet.send(this.writer);
            return this.getResult(isStreaming, true);
        }
        catch (QueryException qex) {
            if (qex.getCause() instanceof SocketTimeoutException) {
                throw new QueryException("Connection timed out", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), qex);
            }
            throw qex;
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void releasePrepareStatement(PrepareResult prepareResult, String sql) throws QueryException {
        prepareResult.decrementShareCounter();
        if (prepareResult.canBeDeallocate()) {
            this.forceReleasePrepareStatement(prepareResult.getStatementId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceReleasePrepareStatement(int statementId) throws QueryException {
        this.lock.lock();
        try {
            this.checkClose();
            SendClosePrepareStatementPacket packet = new SendClosePrepareStatementPacket(statementId);
            try {
                packet.send(this.writer);
            }
            catch (IOException e) {
                throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void cancelCurrentQuery() throws QueryException, IOException {
        MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new ReentrantLock());
        copiedProtocol.setHostAddress(this.getHostAddress());
        copiedProtocol.connect();
        copiedProtocol.executeQuery("KILL QUERY " + this.serverThreadId, false);
        copiedProtocol.close();
    }

    @Override
    public AbstractQueryResult getMoreResults(boolean streaming) throws QueryException {
        if (!this.moreResults) {
            return null;
        }
        return this.getResult(streaming, this.activeResult != null ? this.activeResult.isBinaryProtocol() : false);
    }

    @Override
    public void setInternalMaxRows(int max) {
        if (this.maxRows != max) {
            this.maxRows = max;
        }
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws QueryException {
        if (this.maxRows != max) {
            if (max == 0) {
                this.executeQuery("set @@SQL_SELECT_LIMIT=DEFAULT", false);
            } else {
                this.executeQuery("set @@SQL_SELECT_LIMIT=" + max, false);
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            this.getOptions().socketTimeout = timeout;
            this.socket.setSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws QueryException {
        this.lock.lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new QueryException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(query, false);
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws QueryException {
        if (!this.connected) {
            throw new QueryException("Connection is close", 1220, "08000");
        }
    }

    @Override
    public void closeIfActiveResult() {
        if (this.activeResult != null) {
            this.activeResult.close();
        }
    }

    @Override
    public PrepareStatementCache prepareStatementCache() {
        return this.prepareStatementCache;
    }

    @Override
    public AbstractQueryResult executeQuery(String sql, boolean streaming) throws QueryException {
        this.checkClose();
        try {
            this.writer.sendTextPacket(sql);
            return this.getResult(streaming, false);
        }
        catch (QueryException queryException) {
            if (this.getOptions().dumpQueriesOnException || queryException.getErrorCode() == 1064) {
                String sqlQuery = sql;
                if (sqlQuery.length() > 1024) {
                    sqlQuery = sqlQuery.substring(0, 1024);
                }
                queryException.setMessage(queryException.getMessage() + "\nQuery is : " + sqlQuery);
            }
            throw queryException;
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public AbstractQueryResult executeQuery(List<String> queries, boolean streaming, boolean isRewritable, int rewriteOffset) throws QueryException {
        this.moreResults = false;
        AbstractQueryResult result = null;
        String firstSql = null;
        int currentIndex = 0;
        int totalQueries = queries.size();
        try {
            do {
                String sql;
                firstSql = sql = queries.get(currentIndex++);
                if (totalQueries == 1) {
                    this.writer.sendTextPacket(sql);
                } else {
                    byte[] sqlByte;
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    if (!isRewritable) {
                        this.writer.write(sql.getBytes("UTF-8"));
                        while (currentIndex < totalQueries && this.writer.checkRewritableLength((sqlByte = queries.get(currentIndex++).getBytes("UTF-8")).length)) {
                            this.writer.write(59);
                            this.writer.write(sqlByte);
                        }
                    } else {
                        this.writer.write(sql.getBytes("UTF-8"));
                        while (currentIndex < totalQueries && this.writer.checkRewritableLength(1 + (sqlByte = queries.get(currentIndex).substring(rewriteOffset).getBytes("UTF-8")).length)) {
                            this.writer.write(44);
                            this.writer.write(sqlByte);
                            ++currentIndex;
                        }
                    }
                }
                this.writer.finishPacket();
                AbstractQueryResult resultTmp = this.getResult(streaming, false);
                if (result == null) {
                    result = resultTmp;
                    continue;
                }
                result.addResult(resultTmp);
            } while (currentIndex < totalQueries);
        }
        catch (QueryException queryException) {
            if (this.getOptions().dumpQueriesOnException || queryException.getErrorCode() == 1064) {
                String sql = firstSql;
                if (sql.length() > 1024) {
                    sql = sql.substring(0, 1024);
                }
                queryException.setMessage(queryException.getMessage() + "\nQuery is : " + sql);
            }
            throw queryException;
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractQueryResult executeQueries(List<String> queryParts, List<ParameterHolder[]> parameterList, boolean streaming, boolean isRewritable) throws QueryException {
        this.checkClose();
        ParameterHolder[] parameters = null;
        int paramCount = queryParts.size() - 3;
        int currentIndex = 0;
        int totalParameterList = parameterList.size();
        try {
            void var10_16;
            for (ParameterHolder[] parameterHolderArray : parameterList) {
                for (ParameterHolder ph : parameterHolderArray) {
                    if (ph != null) continue;
                    parameters = parameterHolderArray;
                    throw new QueryException("You need to set exactly " + paramCount + " parameters on the prepared statement");
                }
            }
            parameters = parameterList.get(currentIndex++);
            ArrayList<byte[]> queryPartsUtf8 = new ArrayList<byte[]>(queryParts.size());
            for (String part : queryParts) {
                queryPartsUtf8.add(part.getBytes("UTF-8"));
            }
            this.moreResults = false;
            Object var10_15 = null;
            do {
                int i;
                this.writer.startPacket(0);
                this.writer.write(3);
                if (totalParameterList == 1) {
                    this.writer.write((byte[])queryPartsUtf8.get(0));
                    this.writer.write((byte[])queryPartsUtf8.get(1));
                    for (i = 0; i < paramCount; ++i) {
                        parameters[i].writeTo(this.writer);
                        this.writer.write((byte[])queryPartsUtf8.get(i + 2));
                    }
                    this.writer.write((byte[])queryPartsUtf8.get(paramCount + 2));
                } else if (!isRewritable) {
                    this.writer.write((byte[])queryPartsUtf8.get(0));
                    this.writer.write((byte[])queryPartsUtf8.get(1));
                    for (i = 0; i < paramCount; ++i) {
                        parameters[i].writeTo(this.writer);
                        this.writer.write((byte[])queryPartsUtf8.get(i + 2));
                    }
                    this.writer.write((byte[])queryPartsUtf8.get(paramCount + 2));
                    while (currentIndex < totalParameterList) {
                        parameters = parameterList.get(currentIndex++);
                        this.writer.write(59);
                        this.writer.write((byte[])queryPartsUtf8.get(0));
                        this.writer.write((byte[])queryPartsUtf8.get(1));
                        for (i = 0; i < paramCount; ++i) {
                            parameters[i].writeTo(this.writer);
                            this.writer.write((byte[])queryPartsUtf8.get(i + 2));
                        }
                        this.writer.write((byte[])queryPartsUtf8.get(paramCount + 2));
                    }
                } else {
                    this.writer.write((byte[])queryPartsUtf8.get(0));
                    this.writer.write((byte[])queryPartsUtf8.get(1));
                    int lastPartLength = ((byte[])queryPartsUtf8.get(paramCount + 2)).length;
                    for (int i2 = 0; i2 < paramCount; ++i2) {
                        parameters[i2].writeTo(this.writer);
                        this.writer.write((byte[])queryPartsUtf8.get(i2 + 2));
                    }
                    while (currentIndex < totalParameterList) {
                        void var13_28;
                        parameters = parameterList.get(currentIndex);
                        int parameterLength = 1;
                        for (ParameterHolder parameter : parameters) {
                            parameterLength = (int)((long)parameterLength + parameter.getApproximateTextProtocolLength());
                        }
                        if (!this.writer.checkRewritableLength(parameterLength + lastPartLength)) break;
                        this.writer.write(44);
                        this.writer.write((byte[])queryPartsUtf8.get(1));
                        boolean bl = false;
                        while (var13_28 < paramCount) {
                            parameters[var13_28].writeTo(this.writer);
                            this.writer.write((byte[])queryPartsUtf8.get((int)(var13_28 + 2)));
                            ++var13_28;
                        }
                        ++currentIndex;
                    }
                    this.writer.write((byte[])queryPartsUtf8.get(paramCount + 2));
                }
                this.writer.finishPacket();
                AbstractQueryResult resultTmp = this.getResult(streaming, false);
                if (var10_16 == null) {
                    AbstractQueryResult abstractQueryResult = resultTmp;
                    continue;
                }
                var10_16.addResult(resultTmp);
            } while (totalParameterList < totalParameterList);
            return var10_16;
        }
        catch (QueryException queryException) {
            if (this.getOptions().dumpQueriesOnException || queryException.getErrorCode() == 1064) {
                StringBuilder stringBuilder = new StringBuilder(queryParts.get(0)).append(queryParts.get(1));
                for (int i = 0; i < paramCount; ++i) {
                    if (parameters != null && parameters.length > i) {
                        stringBuilder.append(parameters[i]).append(queryParts.get(i + 2));
                        continue;
                    }
                    stringBuilder.append("?").append(queryParts.get(i + 2));
                }
                stringBuilder.append(queryParts.get(paramCount + 2));
                String sql = stringBuilder.toString();
                if (sql.length() > 1024) {
                    sql = sql.substring(0, 1024);
                }
                queryException.setMessage(queryException.getMessage() + "\nQuery is : " + sql);
            }
            throw queryException;
        }
        catch (MaxAllowedPacketException e) {
            if (e.isMustReconnect()) {
                this.connect();
            }
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), e);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public AbstractQueryResult getResult(boolean streaming, boolean binaryProtocol) throws QueryException {
        Buffer buffer;
        try {
            buffer = this.packetFetcher.getReusableBuffer();
        }
        catch (IOException e) {
            try {
                if (this.writer != null) {
                    this.writer.writeEmptyPacket(this.packetFetcher.getLastPacketSeq() + 1);
                    this.packetFetcher.getReusableBuffer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (buffer.getByteAt(0)) {
            case 0: {
                buffer.skipByte();
                long affectedRows = buffer.getLengthEncodedBinary();
                long insertId = buffer.getLengthEncodedBinary();
                this.serverStatus = buffer.readShort();
                this.hasWarnings = buffer.readShort() > 0;
                this.moreResults = (this.serverStatus & ServerStatus.MORE_RESULTS_EXISTS) != 0;
                return new UpdateResult(affectedRows, insertId);
            }
            case -1: {
                String message;
                String sqlState;
                this.moreResults = false;
                this.hasWarnings = false;
                buffer.skipByte();
                short errorNumber = buffer.readShort();
                if (buffer.readByte() == 35) {
                    sqlState = new String(buffer.readRawBytes(5));
                    message = buffer.readString(StandardCharsets.UTF_8);
                } else {
                    message = new String(buffer.buf, StandardCharsets.UTF_8);
                    sqlState = "HY000";
                }
                throw new QueryException(message, errorNumber, sqlState);
            }
            case -5: {
                buffer.getLengthEncodedBinary();
                String fileName = buffer.readString(StandardCharsets.UTF_8);
                try {
                    return this.sendLocalFile(fileName);
                }
                catch (IOException e) {
                    try {
                        if (this.writer != null) {
                            this.writer.writeEmptyPacket(this.packetFetcher.getLastPacketSeq() + 1);
                            this.packetFetcher.getReusableBuffer();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new QueryException("Could not read resultset: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
            case -2: {
                if (buffer.remaining() >= 9) break;
                throw new QueryException("Could not parse result", -1, ExceptionMapper.SqlStates.INTERRUPTED_EXCEPTION.getSqlState());
            }
        }
        this.hasWarnings = false;
        long fieldCount = buffer.getLengthEncodedBinary();
        try {
            StreamingSelectResult streamingResult = StreamingSelectResult.createStreamingSelectResult(fieldCount, this.packetFetcher, this, binaryProtocol);
            if (streaming) {
                return streamingResult;
            }
            return CachedSelectResult.createCachedSelectResult(streamingResult);
        }
        catch (IOException e) {
            throw new QueryException("Could not read result set: " + e.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void prologProxy(PrepareResult prepareResult, boolean isStreaming, int maxRows, boolean hasProxy, MariaDbConnection connection, Statement statement) throws SQLException {
        this.prolog(isStreaming, maxRows, hasProxy, connection, statement);
    }

    @Override
    public void prolog(boolean isStreaming, int maxRows, boolean hasProxy, MariaDbConnection connection, Statement statement) throws SQLException {
        if (this.explicitClosed) {
            throw new SQLException("execute() is called on closed connection");
        }
        if (!hasProxy && this.shouldReconnectWithoutProxy()) {
            try {
                this.connectWithoutProxy();
            }
            catch (QueryException qe) {
                ExceptionMapper.throwException(qe, connection, statement);
            }
        }
        try {
            this.setMaxRows(maxRows);
            this.closeIfActiveResult();
            if (isStreaming && this.hasMoreResults()) {
                this.getMoreResults(isStreaming);
            }
        }
        catch (QueryException qe) {
            ExceptionMapper.throwException(qe, connection, statement);
        }
        connection.reenableWarnings();
    }
}

