/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.queryresults.MariaDbValueObject;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.buffer.Buffer;

public class TextRowPacket
implements RowPacket {
    private final ColumnInformation[] columnInformation;
    private final Options options;
    private final int columnInformationLength;

    public TextRowPacket(ColumnInformation[] columnInformation, Options options, int columnInformationLength) {
        this.columnInformationLength = columnInformationLength;
        this.columnInformation = columnInformation;
        this.options = options;
    }

    @Override
    public ValueObject[] getRow(ReadPacketFetcher packetFetcher, Buffer buffer) throws IOException {
        ValueObject[] valueObjects = new ValueObject[this.columnInformationLength];
        for (int i = 0; i < this.columnInformationLength; ++i) {
            while (buffer.remaining() == 0) {
                buffer.appendPacket(packetFetcher.getPacket());
            }
            long valueLen = buffer.getLengthEncodedBinary();
            if (valueLen == -1L) {
                valueObjects[i] = new MariaDbValueObject(null, this.columnInformation[i], this.options);
                continue;
            }
            while ((long)buffer.remaining() < valueLen) {
                buffer.appendPacket(packetFetcher.getPacket());
            }
            valueObjects[i] = new MariaDbValueObject(buffer.readRawBytes((int)valueLen), this.columnInformation[i], this.options);
        }
        return valueObjects;
    }
}

