/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbResultSet;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.queryresults.UpdateResult;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbStatement
implements Statement {
    private static volatile Timer timer;
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected boolean autoGeneratedKeys;
    protected boolean binaryData = false;
    protected AbstractQueryResult queryResult;
    protected TimerTask timerTask;
    protected boolean isRewriteable = true;
    protected int rewriteOffset = -1;
    protected ResultSet batchResultSet = null;
    protected volatile boolean closed = false;
    boolean isTimedout;
    volatile boolean executing;
    private List<String> batchQueries;
    Deque<Object> cachedResultSets;
    private boolean warningsCleared;
    protected int queryTimeout;
    private int fetchSize;
    protected boolean isStreaming = false;
    protected int maxRows;
    protected final ReentrantLock lock;

    public MariaDbStatement(MariaDbConnection connection, int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys == 1;
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.lock = this.connection.lock;
        this.cachedResultSets = new ArrayDeque<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Timer getTimer() {
        Timer result = timer;
        if (result != null) return result;
        Class<MariaDbStatement> clazz = MariaDbStatement.class;
        synchronized (MariaDbStatement.class) {
            result = timer;
            if (result != null) return result;
            timer = result = new Timer("MariaDB-JDBC-Timer", true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void unloadDriver() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public boolean isStreaming() {
        return this.fetchSize == Integer.MIN_VALUE;
    }

    protected void setTimerTask() {
        assert (this.timerTask == null);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        MariaDbStatement.getTimer().schedule(this.timerTask, this.queryTimeout * 1000);
    }

    protected void executeQueryProlog() throws SQLException {
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prolog(this.isStreaming, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        this.cachedResultSets.clear();
        if (this.queryTimeout != 0) {
            this.setTimerTask();
        }
    }

    protected void cacheMoreResults() throws SQLException {
        if (this.isStreaming()) {
            return;
        }
        AbstractQueryResult saveResult = this.queryResult;
        try {
            while (this.protocol.hasMoreResults()) {
                this.queryResult = this.protocol.getMoreResults(false);
                this.cachedResultSets.add(this.queryResult);
            }
        }
        catch (QueryException e) {
            throw ExceptionMapper.createException(e, this.connection, this);
        }
        this.queryResult = saveResult;
    }

    protected void executeQueryEpilog(QueryException queryException) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            queryException = new QueryException("Query timed out", 1317, "JZ0002", queryException);
        }
        if (queryException == null) {
            return;
        }
        if (queryException.getSqlState() != null && queryException.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwException(queryException, this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(List<String> queries, boolean isRewritable, int rewriteOffset) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            this.queryResult = this.protocol.executeQuery(queries, this.isStreaming(), isRewritable, rewriteOffset);
            this.cacheMoreResults();
            boolean bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal(String sql) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            this.queryResult = this.protocol.executeQuery(sql, this.isStreaming());
            if (this.autoGeneratedKeys && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
                this.batchResultSet = (MariaDbResultSet)this.getInternalGeneratedKeys();
            }
            this.cacheMoreResults();
            boolean bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.autoGeneratedKeys = false;
        return this.executeInternal(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.autoGeneratedKeys = autoGeneratedKeys == 1;
        return this.executeInternal(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.autoGeneratedKeys = true;
        return this.executeInternal(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.autoGeneratedKeys = true;
        return this.executeInternal(sql);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.autoGeneratedKeys = true;
        if (this.executeInternal(sql)) {
            return this.getResultSet();
        }
        return MariaDbResultSet.EMPTY;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.autoGeneratedKeys = false;
        if (this.executeInternal(sql)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean bl = this.autoGeneratedKeys = autoGeneratedKeys == 1;
        if (this.executeInternal(sql)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.autoGeneratedKeys = true;
        if (this.executeInternal(sql)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.autoGeneratedKeys = true;
        if (this.executeInternal(sql)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.queryResult != null) {
                this.queryResult.close();
                this.queryResult = null;
            }
            this.cachedResultSets.clear();
            if (this.isStreaming()) {
                while (this.getInternalMoreResults(true)) {
                }
            }
            this.protocol = null;
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClose();
        try {
            if (!this.executing) {
                return;
            }
            this.protocol.cancelCurrentQuery();
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (!this.autoGeneratedKeys) {
            throw new SQLException("getGeneratedKeys error. Statement.RETURN_GENERATED_KEYS must be precised on connection.prepareStatement(String sql, int autoGeneratedKeys) or statement.executeUpdate(String sql, int autoGeneratedKeys)");
        }
        if (this.batchResultSet != null) {
            return this.batchResultSet;
        }
        return this.getInternalGeneratedKeys();
    }

    protected ResultSet getInternalGeneratedKeys() throws SQLException {
        if (this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
            long insertId = ((UpdateResult)this.queryResult).getInsertId();
            if (insertId == 0L) {
                return MariaDbResultSet.createEmptyGeneratedKeysResultSet(this.connection);
            }
            int updateCount = this.getUpdateCount();
            return MariaDbResultSet.createGeneratedKeysResultSet(insertId, updateCount, this.connection, this.binaryData);
        }
        return MariaDbResultSet.EMPTY;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        if (this.queryResult == null || this.queryResult.getResultSetType() != ResultSetType.SELECT) {
            return null;
        }
        return new MariaDbResultSet(this.queryResult, this, this.protocol);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.queryResult == null || this.queryResult.getResultSetType() == ResultSetType.SELECT) {
            return -1;
        }
        return (int)((UpdateResult)this.queryResult).getUpdateCount();
    }

    protected boolean getInternalMoreResults(boolean streaming) throws SQLException {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            if (this.protocol != null) {
                this.queryResult = this.protocol.getMoreResults(streaming);
                if (this.queryResult == null) {
                    return false;
                }
                this.warningsCleared = false;
                this.connection.reenableWarnings();
                return this.queryResult.getResultSetType() == ResultSetType.SELECT;
            }
            return false;
        }
        catch (QueryException e) {
            ExceptionMapper.throwException(e, this.connection, this);
            return false;
        }
    }

    public boolean getInternalMoreResults() throws SQLException {
        if (!this.isStreaming()) {
            if (this.cachedResultSets.isEmpty()) {
                this.queryResult = null;
                return false;
            }
            Object obj = this.cachedResultSets.remove();
            if (obj instanceof QueryException) {
                ExceptionMapper.throwException((QueryException)obj, this.connection, this);
            }
            this.queryResult = (AbstractQueryResult)obj;
            if (this.batchResultSet != null) {
                this.batchResultSet = ((MariaDbResultSet)this.batchResultSet).joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
            }
            return this.queryResult.getResultSetType() == ResultSetType.SELECT;
        }
        return this.getInternalMoreResults(false);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClose();
        return this.getInternalMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClose();
        return this.getInternalMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        String sqlQuery = sql;
        if (this.isRewriteable && (this.protocol.getOptions().rewriteBatchedStatements || this.protocol.getOptions().allowMultiQueries)) {
            int sqlRewriteOffset = this.isRewritable(sql, this.connection.noBackslashEscapes);
            if (this.rewriteOffset == -1) {
                this.rewriteOffset = sqlRewriteOffset;
            } else {
                this.isRewriteable = this.isRewriteable && this.rewriteOffset == sqlRewriteOffset;
            }
        }
        this.batchQueries.add(sqlQuery);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
        this.isRewriteable = true;
        this.rewriteOffset = -1;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int batchQueriesCount;
        this.checkClose();
        if (this.batchQueries == null || this.batchQueries.size() == 0) {
            return new int[0];
        }
        int[] ret = new int[this.batchQueries.size()];
        MariaDbResultSet rs = null;
        this.cachedResultSets.clear();
        this.lock.lock();
        try {
            int size = this.batchQueries.size();
            if (this.isRewriteable && (this.protocol.getOptions().allowMultiQueries || this.protocol.getOptions().rewriteBatchedStatements)) {
                this.batchResultSet = null;
                boolean rewrittenBatch = this.isRewriteable && this.protocol.getOptions().rewriteBatchedStatements;
                this.executeInternal(this.batchQueries, rewrittenBatch, rewrittenBatch && this.rewriteOffset != -1 ? this.rewriteOffset : 0);
                int[] nArray = rewrittenBatch ? this.getUpdateCountsForReWrittenBatch(size) : this.getUpdateRewrittenCounts();
                return nArray;
            }
            for (batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                String sql = this.batchQueries.get(batchQueriesCount);
                this.executeInternal(sql);
                int updateCount = this.getUpdateCount();
                ret[batchQueriesCount] = updateCount == -1 ? -2 : updateCount;
                if (!this.autoGeneratedKeys) continue;
                rs = batchQueriesCount == 0 ? (MariaDbResultSet)this.getInternalGeneratedKeys() : rs.joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, batchQueriesCount), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
        this.batchResultSet = rs;
        return ret;
    }

    protected int[] getUpdateRewrittenCounts() throws SQLException {
        int[] result = new int[this.cachedResultSets.size() + 1];
        int count = 0;
        int updateCount = this.getUpdateCount();
        result[count++] = updateCount == -1 ? -2 : updateCount;
        if (this.autoGeneratedKeys) {
            this.batchResultSet = this.getInternalGeneratedKeys();
        }
        while (!this.cachedResultSets.isEmpty()) {
            Object obj = this.cachedResultSets.remove();
            if (obj instanceof QueryException) {
                ExceptionMapper.throwException((QueryException)obj, this.connection, this);
            } else if (obj instanceof SQLException) {
                throw (SQLException)obj;
            }
            this.queryResult = (AbstractQueryResult)obj;
            updateCount = this.getUpdateCount();
            result[count++] = updateCount == -1 ? -2 : updateCount;
            if (!this.autoGeneratedKeys) continue;
            if (this.batchResultSet == null) {
                this.batchResultSet = this.getInternalGeneratedKeys();
                continue;
            }
            this.batchResultSet = ((MariaDbResultSet)this.batchResultSet).joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
        }
        if (!this.autoGeneratedKeys) {
            this.cachedResultSets.clear();
        }
        return result;
    }

    protected int[] getUpdateCountsForReWrittenBatch(int size) throws SQLException {
        int totalUpdateCount = 0;
        this.batchResultSet = this.getInternalGeneratedKeys();
        int updateCount = this.getUpdateCount();
        totalUpdateCount += updateCount != -1 ? updateCount : 0;
        while (!this.cachedResultSets.isEmpty()) {
            Object obj = this.cachedResultSets.remove();
            if (obj instanceof QueryException) {
                ExceptionMapper.throwException((QueryException)obj, this.connection, this);
            }
            this.queryResult = (AbstractQueryResult)obj;
            updateCount = this.getUpdateCount();
            totalUpdateCount += updateCount != -1 ? updateCount : 0;
            if (!this.autoGeneratedKeys) continue;
            this.batchResultSet = ((MariaDbResultSet)this.batchResultSet).joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
        }
        this.cachedResultSets.clear();
        int[] result = new int[size];
        int resultVal = totalUpdateCount == size ? 1 : -2;
        for (int count = 0; count < size; ++count) {
            result[count] = resultVal;
        }
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }

    private int isRewritable(String queryString, boolean noBackslashEscapes) {
        this.isRewriteable = true;
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        int valueIndex = -1;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean semicolon = false;
        char[] query = queryString.toCharArray();
        for (int i = 0; i < query.length; ++i) {
            if (state == LexState.Escape) {
                state = LexState.String;
                continue;
            }
            char car = query[i];
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    semicolon = true;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != LexState.Normal || valueIndex != -1 || query.length <= i + 6 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T') break;
                    this.isRewriteable = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != LexState.Normal || valueIndex != -1 || lastChar != ')' && (byte)lastChar > 40 || query.length <= i + 7 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E' || query[i + 5] != 's' && query[i + 5] != 'S' || query[i + 6] != '(' && (byte)query[i + 6] > 40) break;
                    valueIndex = i + 6;
                    i += 6;
                    break;
                }
                default: {
                    if (!(state != LexState.Normal || !isFirstChar || lastChar != '\u0000' && (byte)lastChar < 40 || car != 'I' && car != 'i')) {
                        isInsert = true;
                        isFirstChar = false;
                    }
                    if (state != LexState.Normal || !semicolon || (byte)lastChar < 40) break;
                    this.isRewriteable = false;
                }
            }
            lastChar = car;
        }
        if (semicolon || !isInsert || valueIndex == -1) {
            this.isRewriteable = false;
        }
        return valueIndex;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        Parameter,
        EOLComment,
        Backtick;

    }
}

