/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbResultSet;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbClientPreparedStatement
extends AbstractMariaDbPrepareStatement {
    private final String sqlQuery;
    private List<String> queryParts;
    private ParameterHolder[] parameters;
    private List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private int paramCount;
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbClientPreparedStatement(MariaDbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection, autoGeneratedKeys);
        this.sqlQuery = sql;
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.queryParts = this.createRewritableParts(sql, connection.noBackslashEscapes);
        this.paramCount = this.queryParts.size() - 3;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.executeInternal()) {
            return this.getResultSet();
        }
        return MariaDbResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.executeInternal()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal() throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            this.queryResult = this.protocol.executeQueries(this.queryParts, Collections.singletonList(this.parameters), this.isStreaming(), false);
            this.cacheMoreResults();
            boolean bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.parameterList.add(this.parameters);
        this.clearParameters();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int batchQueriesCount;
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        int[] ret = new int[size];
        MariaDbResultSet rs = null;
        this.cachedResultSets.clear();
        this.lock.lock();
        try {
            if (this.isRewriteable && (this.protocol.getOptions().allowMultiQueries || this.protocol.getOptions().rewriteBatchedStatements)) {
                this.batchResultSet = null;
                boolean rewrittenBatch = this.isRewriteable && this.protocol.getOptions().rewriteBatchedStatements;
                this.executeRewriteQuery(rewrittenBatch);
                int[] nArray = rewrittenBatch ? this.getUpdateCountsForReWrittenBatch(size) : this.getUpdateRewrittenCounts();
                return nArray;
            }
            for (batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                this.parameters = this.parameterList.get(batchQueriesCount);
                this.executeInternal();
                int updateCount = this.getUpdateCount();
                ret[batchQueriesCount] = updateCount == -1 ? -2 : updateCount;
                rs = batchQueriesCount == 0 ? (MariaDbResultSet)this.getInternalGeneratedKeys() : rs.joinResultSets((MariaDbResultSet)this.getInternalGeneratedKeys());
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, batchQueriesCount), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
        this.batchResultSet = rs;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeRewriteQuery(boolean isRewritable) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            this.queryResult = this.protocol.executeQueries(this.queryParts, this.parameterList, this.isStreaming(), isRewritable);
            this.cacheMoreResults();
            boolean bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.loadMetadata();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.paramCount + 1) {
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.loadMetadata();
        }
        return this.parameterMetaData;
    }

    private void loadMetadata() throws SQLException {
        MariaDbServerPreparedStatement serverPreparedStatement = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 2);
        serverPreparedStatement.close();
        this.resultSetMetaData = serverPreparedStatement.getMetaData();
        this.parameterMetaData = serverPreparedStatement.getParameterMetaData();
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    public String toString() {
        return this.sqlQuery;
    }

    private List<String> createRewritableParts(String queryString, boolean noBackslashEscapes) {
        this.isRewriteable = true;
        ArrayList<String> partList = new ArrayList<String>();
        MariaDbStatement.LexState state = MariaDbStatement.LexState.Normal;
        char lastChar = '\u0000';
        StringBuilder sb = new StringBuilder();
        boolean singleQuotes = false;
        int valueIndex = -1;
        int isInParenthesis = 0;
        boolean isAfterValue = false;
        boolean skipChar = false;
        boolean addPartPreValue = false;
        boolean addPartAfterValue = false;
        boolean isFirstChar = true;
        boolean isInsert = false;
        boolean semicolon = false;
        char[] query = queryString.toCharArray();
        for (int i = 0; i < query.length; ++i) {
            boolean isParam = false;
            if (state == MariaDbStatement.LexState.Escape) {
                sb.append(query[i]);
                state = MariaDbStatement.LexState.String;
                continue;
            }
            char car = query[i];
            switch (car) {
                case '*': {
                    if (state != MariaDbStatement.LexState.Normal || lastChar != '/') break;
                    state = MariaDbStatement.LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == MariaDbStatement.LexState.SlashStarComment && lastChar == '*') {
                        state = MariaDbStatement.LexState.Normal;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.Normal || lastChar != '/') break;
                    state = MariaDbStatement.LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    state = MariaDbStatement.LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != MariaDbStatement.LexState.Normal || lastChar != '-') break;
                    state = MariaDbStatement.LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != MariaDbStatement.LexState.EOLComment) break;
                    state = MariaDbStatement.LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == MariaDbStatement.LexState.Normal) {
                        state = MariaDbStatement.LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.String || singleQuotes) break;
                    state = MariaDbStatement.LexState.Normal;
                    break;
                }
                case ';': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    semicolon = true;
                    break;
                }
                case '\'': {
                    if (state == MariaDbStatement.LexState.Normal) {
                        state = MariaDbStatement.LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.String || !singleQuotes) break;
                    state = MariaDbStatement.LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != MariaDbStatement.LexState.String) break;
                    state = MariaDbStatement.LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    isParam = true;
                    if (!isAfterValue) break;
                    this.isRewriteable = false;
                    break;
                }
                case '`': {
                    if (state == MariaDbStatement.LexState.Backtick) {
                        state = MariaDbStatement.LexState.Normal;
                        break;
                    }
                    if (state != MariaDbStatement.LexState.Normal) break;
                    state = MariaDbStatement.LexState.Backtick;
                    break;
                }
                case 'S': 
                case 's': {
                    if (state != MariaDbStatement.LexState.Normal || valueIndex != -1 || query.length <= i + 6 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'c' && query[i + 4] != 'C' || query[i + 5] != 't' && query[i + 5] != 'T') break;
                    this.isRewriteable = false;
                    break;
                }
                case 'V': 
                case 'v': {
                    if (state != MariaDbStatement.LexState.Normal || valueIndex != -1 || lastChar != ')' && (byte)lastChar > 40 || query.length <= i + 7 || query[i + 1] != 'a' && query[i + 1] != 'A' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'e' && query[i + 4] != 'E' || query[i + 5] != 's' && query[i + 5] != 'S' || query[i + 6] != '(' && (byte)query[i + 6] > 40) break;
                    sb.append(car);
                    sb.append(query[i + 1]);
                    sb.append(query[i + 2]);
                    sb.append(query[i + 3]);
                    sb.append(query[i + 4]);
                    sb.append(query[i + 5]);
                    partList.add(sb.toString());
                    sb.setLength(0);
                    valueIndex = (i += 5) + 6;
                    skipChar = true;
                    break;
                }
                case '(': {
                    if (state != MariaDbStatement.LexState.Normal) break;
                    ++isInParenthesis;
                    break;
                }
                case ')': {
                    if (state != MariaDbStatement.LexState.Normal || --isInParenthesis != 0 || valueIndex == -1 || addPartAfterValue) break;
                    isAfterValue = true;
                    sb.append(car);
                    partList.add(sb.toString());
                    sb.setLength(0);
                    skipChar = true;
                    addPartAfterValue = true;
                    break;
                }
                default: {
                    if (state == MariaDbStatement.LexState.Normal && isFirstChar && (byte)car >= 40) {
                        if (car == 'I' || car == 'i') {
                            isInsert = true;
                        }
                        isFirstChar = false;
                    }
                    if (state != MariaDbStatement.LexState.Normal || !semicolon || (byte)lastChar < 40) break;
                    this.isRewriteable = false;
                }
            }
            lastChar = car;
            if (isParam) {
                partList.add(sb.toString());
                sb.setLength(0);
                if (valueIndex == -1 && !addPartPreValue) {
                    partList.add("");
                    isAfterValue = true;
                }
                addPartPreValue = true;
                continue;
            }
            if (skipChar) {
                skipChar = false;
                continue;
            }
            sb.append(car);
        }
        if (!addPartPreValue) {
            partList.add("");
        }
        if (!addPartAfterValue) {
            partList.add("");
        }
        partList.add(sb.toString());
        if (!isInsert) {
            this.isRewriteable = false;
        }
        return partList;
    }
}

