/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.util.Utils;

class CallableParameterMetaData
implements ParameterMetaData {
    private static Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?([\\w\\d]+)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private static Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private CallParameter[] params;
    private MariaDbConnection con;
    private String name;
    private boolean valid;
    private boolean isFunction;
    private boolean noAccessToMetadata;

    public CallableParameterMetaData(CallParameter[] params, MariaDbConnection con, String name, boolean isFunction) {
        this.params = params;
        this.con = con;
        this.name = name;
        this.isFunction = isFunction;
    }

    public void readMetadataFromDbIfRequired() throws SQLException {
        if (this.noAccessToMetadata || this.valid) {
            return;
        }
        try {
            this.readMetadata();
            this.valid = true;
        }
        catch (SQLException e) {
            this.noAccessToMetadata = true;
            throw e;
        }
    }

    int mapMariaDbTypeToJdbc(String str) {
        switch (str = str.toUpperCase()) {
            case "BIT": {
                return -7;
            }
            case "TINYINT": {
                return -6;
            }
            case "SMALLINT": {
                return 5;
            }
            case "MEDIUMINT": {
                return 4;
            }
            case "INT": {
                return 4;
            }
            case "INTEGER": {
                return 4;
            }
            case "LONG": {
                return 4;
            }
            case "BIGINT": {
                return -5;
            }
            case "INT24": {
                return 4;
            }
            case "REAL": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "DECIMAL": {
                return 3;
            }
            case "NUMERIC": {
                return 2;
            }
            case "DOUBLE": {
                return 8;
            }
            case "CHAR": {
                return 1;
            }
            case "VARCHAR": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "YEAR": {
                return 5;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "DATETIME": {
                return 93;
            }
            case "TINYBLOB": {
                return -2;
            }
            case "BLOB": {
                return -4;
            }
            case "MEDIUMBLOB": {
                return -4;
            }
            case "LONGBLOB": {
                return -4;
            }
            case "TINYTEXT": {
                return 12;
            }
            case "TEXT": {
                return -1;
            }
            case "MEDIUMTEXT": {
                return -1;
            }
            case "LONGTEXT": {
                return -1;
            }
            case "ENUM": {
                return 12;
            }
            case "SET": {
                return 12;
            }
            case "GEOMETRY": {
                return -4;
            }
            case "VARBINARY": {
                return -3;
            }
        }
        return 1111;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] queryMetaInfos() throws SQLException {
        String dbname = "database()";
        String procedureNameNoDb = this.name;
        int dotIndex = this.name.indexOf(46);
        if (dotIndex > 0) {
            dbname = this.name.substring(0, dotIndex);
            dbname = dbname.replace("`", "");
            dbname = "'" + Utils.escapeString(dbname, this.con.noBackslashEscapes) + "'";
            procedureNameNoDb = this.name.substring(dotIndex + 1);
        }
        procedureNameNoDb = procedureNameNoDb.replace("`", "");
        procedureNameNoDb = "'" + Utils.escapeString(procedureNameNoDb, this.con.noBackslashEscapes) + "'";
        Statement st = this.con.createStatement();
        ResultSet rs = null;
        try {
            String query = "select param_list,returns from mysql.proc where db=" + dbname + " and name=" + procedureNameNoDb;
            rs = st.executeQuery(query);
            if (!rs.next()) {
                throw new SQLException("procedure or function " + this.name + " does not exist");
            }
            String paramList = rs.getString(1);
            String functionReturn = rs.getString(2);
            String[] stringArray = new String[]{paramList, functionReturn};
            return stringArray;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    private void parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = this.params[1];
        callParameter.isOutput = true;
        callParameter.isSigned = matcher.group(1) == null;
        callParameter.typeName = matcher.group(2).trim();
        callParameter.sqlType = this.mapMariaDbTypeToJdbc(callParameter.typeName);
        String scale = matcher.group(3);
        if (scale != null) {
            scale = scale.replace("(", "").replace(")", "").replace(" ", "");
            callParameter.scale = Integer.valueOf(scale);
        }
    }

    private void parseParamList(String paramList) throws SQLException {
        int paramIndex;
        String splitter = ",";
        StringTokenizer tokenizer = new StringTokenizer(paramList, splitter, false);
        int n = paramIndex = this.isFunction ? 2 : 1;
        while (tokenizer.hasMoreTokens()) {
            if (paramIndex >= this.params.length) {
                throw new SQLException("Invalid placeholder count in CallableStatement");
            }
            String paramDef = tokenizer.nextToken();
            Pattern pattern = Pattern.compile(".*\\([^)]*");
            Matcher matcher = pattern.matcher(paramDef);
            while (matcher.matches()) {
                paramDef = paramDef + splitter + tokenizer.nextToken();
                matcher = pattern.matcher(paramDef);
            }
            Matcher matcher2 = PARAMETER_PATTERN.matcher(paramDef);
            if (!matcher2.matches()) {
                throw new SQLException("cannot parse parameter definition :" + paramDef);
            }
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            CallParameter callParameter = this.params[paramIndex];
            callParameter.name = matcher2.group(2).trim();
            callParameter.isSigned = matcher2.group(3) == null;
            callParameter.typeName = matcher2.group(4).trim().toUpperCase();
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.isInput = true;
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.isOutput = true;
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.isOutput = true;
                callParameter.isInput = true;
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.name);
            }
            callParameter.sqlType = this.mapMariaDbTypeToJdbc(callParameter.typeName);
            String scale = matcher2.group(5);
            if (scale != null) {
                if ((scale = scale.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    scale = scale.substring(0, scale.indexOf(","));
                }
                callParameter.scale = Integer.valueOf(scale);
            }
            ++paramIndex;
        }
    }

    public void readMetadata() throws SQLException {
        if (this.noAccessToMetadata || this.valid) {
            return;
        }
        String[] metaInfos = this.queryMetaInfos();
        String paramList = metaInfos[0];
        String functionReturn = metaInfos[1];
        if (this.isFunction) {
            this.parseFunctionReturnParam(functionReturn);
        }
        this.parseParamList(paramList);
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.length - 1;
    }

    CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index >= this.params.length) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDbIfRequired();
        return this.params[index];
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam((int)param).isNullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam((int)param).isSigned;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam((int)param).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam((int)param).scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam((int)param).sqlType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam((int)param).typeName;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam((int)param).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter callParameter = this.getParam(param);
        if (callParameter.isInput && callParameter.isOutput) {
            return 2;
        }
        if (callParameter.isInput) {
            return 1;
        }
        if (callParameter.isOutput) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam((int)param).name;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

