/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.NullParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class SendExecutePrepareStatementPacket
implements InterfaceSendPacket {
    private final int parameterCount;
    private final ParameterHolder[] parameters;
    private final int statementId;
    private MariaDbType[] parameterTypeHeader;

    public SendExecutePrepareStatementPacket(int statementId, ParameterHolder[] parameters, int parameterCount, MariaDbType[] parameterTypeHeader) {
        this.parameterCount = parameterCount;
        this.parameters = parameters;
        this.statementId = statementId;
        this.parameterTypeHeader = parameterTypeHeader;
    }

    @Override
    public int send(OutputStream os) throws IOException {
        PacketOutputStream buffer = (PacketOutputStream)os;
        buffer.startPacket(0, true);
        buffer.buffer.put((byte)23);
        buffer.buffer.putInt(this.statementId);
        buffer.buffer.put((byte)0);
        buffer.buffer.putInt(1);
        if (this.parameterCount > 0) {
            int i;
            int nullCount = (this.parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < this.parameterCount; ++i2) {
                if (!(this.parameters[i2] instanceof NullParameter)) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            buffer.buffer.put(nullBitsBuffer);
            boolean mustSendHeaderType = false;
            if (this.parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < this.parameterCount; ++i) {
                    if (this.parameterTypeHeader[i].equals((Object)this.parameters[i].getMariaDbType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                buffer.buffer.put((byte)1);
                for (i = 0; i < this.parameterCount; ++i) {
                    this.parameterTypeHeader[i] = this.parameters[i].getMariaDbType();
                    this.parameters[i].writeBufferType(buffer);
                }
            } else {
                buffer.buffer.put((byte)0);
            }
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            if (!(this.parameters[i] instanceof NotLongDataParameterHolder)) continue;
            ((NotLongDataParameterHolder)this.parameters[i]).writeBinary(buffer);
        }
        buffer.finishPacket();
        return 0;
    }
}

