/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.AbstractMastersListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MastersFailoverListener
extends AbstractMastersListener {
    private final HaMode mode;

    public MastersFailoverListener(UrlParser urlParser) {
        super(urlParser);
        this.mode = urlParser.getHaMode();
    }

    @Override
    public void initializeConnection() throws QueryException {
        this.currentProtocol = null;
        this.reconnectFailedConnection(new SearchFilter(true, false));
    }

    @Override
    public void preExecute() throws QueryException {
        if (this.currentProtocol != null && this.currentProtocol.isClosed()) {
            if (!this.isExplicitClosed() && this.urlParser.getOptions().autoReconnect) {
                try {
                    this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), false, !this.currentReadOnlyAsked.get(), this.currentReadOnlyAsked.get()));
                }
                catch (QueryException queryException) {}
            } else {
                throw new QueryException("Connection is closed", -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState());
            }
        }
    }

    @Override
    public boolean shouldReconnect() {
        return this.isMasterHostFail();
    }

    @Override
    public void preClose() throws SQLException {
        if (!this.isExplicitClosed()) {
            this.proxy.lock.lock();
            this.setExplicitClosed(true);
            try {
                if (this.scheduledFailover != null) {
                    this.scheduledFailover.cancel(true);
                    this.isLooping.set(false);
                }
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.currentProtocol != null && this.currentProtocol.isConnected()) {
                    this.currentProtocol.close();
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args) throws Throwable {
        boolean alreadyClosed;
        block13: {
            alreadyClosed = !this.currentProtocol.isConnected();
            try {
                if (this.currentProtocol != null && this.currentProtocol.isConnected() && this.currentProtocol.ping()) {
                    if (this.currentProtocol.inTransaction()) {
                        this.currentProtocol.rollback();
                    }
                    return new HandleErrorResult(true);
                }
            }
            catch (QueryException e) {
                this.proxy.lock.lock();
                try {
                    this.currentProtocol.close();
                }
                finally {
                    this.proxy.lock.unlock();
                }
                if (!this.setMasterHostFail()) break block13;
                this.addToBlacklist(this.currentProtocol.getHostAddress());
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, false));
            if (!HaMode.NONE.equals((Object)this.mode)) {
                this.launchFailLoopIfNotlaunched(true);
            }
            if (alreadyClosed) {
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            if (!HaMode.NONE.equals((Object)this.mode)) {
                this.launchFailLoopIfNotlaunched(true);
            }
            return new HandleErrorResult();
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
        if (HaMode.FAILOVER.equals((Object)this.mode)) {
            loopAddress.removeAll(blacklist.keySet());
            Collections.shuffle(loopAddress);
            LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
            Collections.shuffle(blacklistShuffle);
            loopAddress.addAll(blacklistShuffle);
        } else {
            loopAddress.removeAll(blacklist.keySet());
            loopAddress.addAll(blacklist.keySet());
        }
        if (this.currentProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.currentProtocol.getHostAddress());
        }
        MasterProtocol.loop(this, loopAddress, blacklist, searchFilter);
        this.resetMasterFailoverData();
    }

    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws QueryException {
        if (this.urlParser.getOptions().assureReadOnly && this.currentReadOnlyAsked.compareAndSet(mustBeReadOnly == false, mustBeReadOnly)) {
            this.setSessionReadOnly(mustBeReadOnly, this.currentProtocol);
        }
    }

    @Override
    public void foundActiveMaster(Protocol protocol) throws QueryException {
        if (this.isExplicitClosed()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
            }
            finally {
                this.proxy.lock.unlock();
            }
            return;
        }
        this.syncConnection(this.currentProtocol, protocol);
        this.proxy.lock.lock();
        try {
            if (this.currentProtocol != null && !this.currentProtocol.isClosed()) {
                this.currentProtocol.close();
            }
            this.currentProtocol = protocol;
        }
        finally {
            this.proxy.lock.unlock();
        }
        this.resetMasterFailoverData();
        this.stopFailover();
    }

    @Override
    public void throwFailoverMessage(QueryException queryException, boolean reconnected) throws QueryException {
        HostAddress hostAddress = this.currentProtocol != null ? this.currentProtocol.getHostAddress() : null;
        String firstPart = "Communications link failure with primary" + (hostAddress != null ? " host " + hostAddress.host + ":" + hostAddress.port : "") + ". ";
        String error = "";
        if (this.urlParser.getOptions().autoReconnect) {
            error = this.isMasterHostFail() ? error + " Driver will reconnect automatically in a few millisecond or during next query if append before" : error + " Driver as successfully reconnect connection";
        } else if (reconnected) {
            error = error + " Driver as reconnect connection";
        } else if (this.shouldReconnect()) {
            error = error + " Driver will try to reconnect automatically in a few millisecond or during next query if append before";
        }
        if (queryException == null) {
            throw new QueryException(firstPart + error, -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState());
        }
        error = queryException.getMessage() + ". " + error;
        queryException.setMessage(firstPart + error);
        throw queryException;
    }

    @Override
    public void reconnect() throws QueryException {
        this.reconnectFailedConnection(new SearchFilter(true, false));
    }
}

