/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.lang.invoke.WrongMethodTypeException;
import java.util.Properties;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public enum DefaultOptions {
    USER("user", "1.0.0"),
    PASSWORD("password", "1.0.0"),
    CONNECT_TIMOUT("connectTimeout", (Integer)null, new Integer(0), (Integer)Integer.MAX_VALUE, "1.1.8"),
    PIPE("pipe", "1.1.3"),
    LOCAL_SOCKET("localSocket", "1.1.4"),
    SHARED_MEMORY("sharedMemory", "1.1.4"),
    TCP_NO_DELAY("tcpNoDelay", Boolean.FALSE, "1.0.0"),
    TCP_ABORTIVE_CLOSE("tcpAbortiveClose", Boolean.FALSE, "1.1.1"),
    LOCAL_SOCKET_ADDRESS("localSocketAddress", "1.1.8"),
    SOCKET_TIMEOUT("socketTimeout", new Integer[]{10000, null, null, null, null, null}, new Integer(0), (Integer)Integer.MAX_VALUE, "1.1.8"),
    INTERACTIVE_CLIENT("interactiveClient", Boolean.FALSE, "1.1.8"),
    DUMP_QUERY_ON_EXCEPTION("dumpQueriesOnException", Boolean.FALSE, "1.1.0"),
    USE_OLD_ALIAS_METADATA_BEHAVIOR("useOldAliasMetadataBehavior", Boolean.FALSE, "1.1.9"),
    ALLOW_LOCAL_INFILE("allowLocalInfile", Boolean.TRUE, "1.2.1"),
    SESSION_VARIABLES("sessionVariables", "1.1.0"),
    CREATE_DATABASE_IF_NOT_EXISTS("createDatabaseIfNotExist", Boolean.FALSE, "1.1.8"),
    SERVER_TIMEZONE("serverTimezone", "1.1.8"),
    NULL_CATALOG_MEANS_CURRENT("nullCatalogMeansCurrent", Boolean.TRUE, "1.1.8"),
    TINY_INT_IS_BIT("tinyInt1isBit", Boolean.TRUE, "1.0.0"),
    YEAR_IS_DATE_TYPE("yearIsDateType", Boolean.TRUE, "1.0.0"),
    USE_SSL("useSsl", Boolean.FALSE, "1.1.0"),
    USER_COMPRESSION("useCompression", Boolean.FALSE, "1.0.0"),
    ALLOW_MULTI_QUERIES("allowMultiQueries", Boolean.FALSE, "1.0.0"),
    REWRITE_BATCHED_STATEMENTS("rewriteBatchedStatements", Boolean.FALSE, "1.1.8"),
    TCP_KEEP_ALIVE("tcpKeepAlive", Boolean.FALSE, "1.0.0"),
    TCP_RCV_BUF("tcpRcvBuf", (Integer)null, new Integer(0), (Integer)Integer.MAX_VALUE, "1.0.0"),
    TCP_SND_BUF("tcpSndBuf", (Integer)null, new Integer(0), (Integer)Integer.MAX_VALUE, "1.0.0"),
    SOCKET_FACTORY("socketFactory", "1.0.0"),
    PIN_GLOBAL_TX_TO_PHYSICAL_CONNECTION("pinGlobalTxToPhysicalConnection", Boolean.FALSE, "1.1.8"),
    TRUST_SERVER_CERTIFICATE("trustServerCertificate", Boolean.FALSE, "1.1.1"),
    SERVER_SSL_CERT("serverSslCert", "1.1.3"),
    USE_FRACTIONAL_SECONDS("useFractionalSeconds", Boolean.TRUE, "1.0.0"),
    AUTO_RECONNECT("autoReconnect", Boolean.FALSE, "1.2.0"),
    FAIL_ON_READ_ONLY("failOnReadOnly", Boolean.FALSE, "1.2.0"),
    SECONDS_BEFORE_RETRY_MASTER("secondsBeforeRetryMaster", new Integer(50), new Integer(0), (Integer)Integer.MAX_VALUE, "1.2.0"),
    QUERY_BEFORE_RETRY_MASTER("queriesBeforeRetryMaster", new Integer(30), new Integer(0), (Integer)Integer.MAX_VALUE, "1.2.0"),
    RETRY_ALL_DOWN("retriesAllDown", new Integer(120), new Integer(0), (Integer)Integer.MAX_VALUE, "1.2.0"),
    FAILOVER_LOOP_RETRIES("failoverLoopRetries", new Integer(120), new Integer(0), (Integer)Integer.MAX_VALUE, "1.2.0"),
    VALID_CONNECTION_TIMEOUT("validConnectionTimeout", new Integer(120), new Integer(0), (Integer)Integer.MAX_VALUE, "1.2.0"),
    LOAD_BALANCE_BLACKLIST_TIMEOUT("loadBalanceBlacklistTimeout", new Integer(50), new Integer(0), (Integer)Integer.MAX_VALUE, "1.2.0"),
    CACHEPREPSTMTS("cachePrepStmts", Boolean.TRUE, "1.3.0"),
    PREPSTMTCACHESIZE("prepStmtCacheSize", new Integer(250), new Integer(0), (Integer)Integer.MAX_VALUE, "1.3.0"),
    PREPSTMTCACHESQLLIMIT("prepStmtCacheSqlLimit", new Integer(2048), new Integer(0), (Integer)Integer.MAX_VALUE, "1.3.0"),
    ASSUREREADONLY("assureReadOnly", Boolean.FALSE, "1.3.0"),
    USELEGACYDATETIMECODE("useLegacyDatetimeCode", Boolean.TRUE, "1.3.0"),
    MAXIMIZEMYSQLCOMPATIBILITY("maximizeMysqlCompatibility", Boolean.FALSE, "1.3.0"),
    ALWAYSAUTOGENERATEKEYS("alwaysAutoGeneratedKeys", Boolean.FALSE, "1.3.0"),
    USESERVERPREPSTMTS("useServerPrepStmts", Boolean.TRUE, "1.3.0");

    protected final String name;
    protected final Object objType;
    protected final Object defaultValue;
    protected final Object minValue;
    protected final Object maxValue;
    protected final String implementationVersion;
    protected Object value = null;

    private DefaultOptions(String name, String implementationVersion) {
        this.name = name;
        this.implementationVersion = implementationVersion;
        this.objType = String.class;
        this.defaultValue = null;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String name, Boolean defaultValue, String implementationVersion) {
        this.name = name;
        this.objType = Boolean.class;
        this.defaultValue = defaultValue;
        this.implementationVersion = implementationVersion;
        this.minValue = null;
        this.maxValue = null;
    }

    private DefaultOptions(String name, Integer defaultValue, Integer minValue, Integer maxValue, String implementationVersion) {
        this.name = name;
        this.objType = Integer.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.implementationVersion = implementationVersion;
    }

    private DefaultOptions(String name, Integer[] defaultValue, Integer minValue, Integer maxValue, String implementationVersion) {
        this.name = name;
        this.objType = Integer.class;
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.implementationVersion = implementationVersion;
    }

    public static Options defaultValues(HaMode haMode) {
        return DefaultOptions.parse(haMode, "", new Properties());
    }

    public static Options addProperty(HaMode haMode, String name, String value, Options options) {
        Properties additionnalProperties = new Properties();
        additionnalProperties.put(name, value);
        return DefaultOptions.parse(haMode, additionnalProperties, options);
    }

    public static Options addProperty(HaMode haMode, Properties additionnalProperties, Options options) {
        return DefaultOptions.parse(haMode, additionnalProperties, options);
    }

    public static Options parse(HaMode haMode, String urlParameters, Options options) {
        Properties prop = new Properties();
        return DefaultOptions.parse(haMode, urlParameters, prop, options);
    }

    public static Options parse(HaMode haMode, String urlParameters, Properties properties) {
        return DefaultOptions.parse(haMode, urlParameters, properties, null);
    }

    public static Options parse(HaMode haMode, String urlParameters, Properties properties, Options options) {
        if (!"".equals(urlParameters)) {
            String[] parameters;
            for (String parameter : parameters = urlParameters.split("&")) {
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + parameter);
                }
                if (properties.containsKey(parameter.substring(0, pos))) continue;
                properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
            }
        }
        return DefaultOptions.parse(haMode, properties, options);
    }

    private static Options parse(HaMode haMode, Properties properties, Options options) {
        boolean initial = false;
        if (options == null) {
            options = new Options();
            initial = true;
        }
        try {
            for (DefaultOptions o : DefaultOptions.values()) {
                String propertyValue = properties.getProperty(o.name);
                if (propertyValue == null) {
                    if (o.name.equals("createDatabaseIfNotExist")) {
                        propertyValue = properties.getProperty("createDB");
                    } else if (o.name.equals("useSsl")) {
                        propertyValue = properties.getProperty("useSSL");
                    }
                }
                if (propertyValue != null) {
                    Object value;
                    if (o.objType.equals(String.class)) {
                        Options.class.getField(o.name).set(options, propertyValue);
                        continue;
                    }
                    if (o.objType.equals(Boolean.class)) {
                        value = propertyValue.toLowerCase();
                        if ("1".equals(value)) {
                            value = "true";
                        } else if ("0".equals(value)) {
                            value = "false";
                        }
                        if (!"true".equals(value) && !"false".equals(value)) {
                            throw new IllegalArgumentException("Optional parameter " + o.name + " must be boolean (true/false or 0/1) was \"" + propertyValue + "\"");
                        }
                        Options.class.getField(o.name).set(options, Boolean.valueOf((String)value));
                        continue;
                    }
                    if (!o.objType.equals(Integer.class)) continue;
                    try {
                        value = Integer.parseInt(propertyValue);
                        if (((Integer)value).compareTo((Integer)o.minValue) < 0 || ((Integer)value).compareTo((Integer)o.maxValue) > 0) {
                            throw new IllegalArgumentException("Optional parameter " + o.name + " must be greater or equal to " + o.minValue + ((Integer)o.maxValue != Integer.MAX_VALUE ? " and smaller than " + o.maxValue : " ") + ", was \"" + propertyValue + "\"");
                        }
                        Options.class.getField(o.name).set(options, value);
                        continue;
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException("Optional parameter " + o.name + " must be Integer, was \"" + propertyValue + "\"");
                    }
                }
                if (!initial) continue;
                if (o.defaultValue instanceof Integer[]) {
                    Options.class.getField(o.name).set(options, ((Integer[])o.defaultValue)[haMode.ordinal()]);
                    continue;
                }
                Options.class.getField(o.name).set(options, o.defaultValue);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException n) {
            n.printStackTrace();
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive : " + s.getMessage());
        }
        return options;
    }

    public static Properties getProperties(Options options) {
        Properties prop = new Properties();
        try {
            for (DefaultOptions o : DefaultOptions.values()) {
                try {
                    Object obj = Options.class.getField(o.name).get(options);
                    if (obj == null) continue;
                    prop.put(o.name, String.valueOf(Options.class.getField(o.name).get(options)).toString());
                }
                catch (NoSuchFieldException exe) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static String getProperties(String optionName, Options options) {
        try {
            return String.valueOf(Options.class.getField(optionName).get(options));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setIntValue(Integer value) {
        this.value = value;
    }

    private void setBooleanValue(Boolean value) {
        this.value = value;
    }

    public int intValue() {
        if (this.objType.equals(Integer.class)) {
            if (this.value != null) {
                return (Integer)this.value;
            }
            return (Integer)this.defaultValue;
        }
        throw new WrongMethodTypeException("Method " + this.name + " is of type " + this.objType + " intValue() does not apply");
    }

    public boolean boolValue() {
        if (this.objType.equals(Boolean.class)) {
            if (this.value != null) {
                return (Boolean)this.value;
            }
            return (Boolean)this.defaultValue;
        }
        throw new WrongMethodTypeException("Method " + this.name + " is of type " + this.objType + " intValue() does not apply");
    }

    public String stringValue() {
        if (this.objType.equals(String.class)) {
            return (String)this.value;
        }
        throw new WrongMethodTypeException("Method " + this.name + " is of type " + this.objType + " intValue() does not apply");
    }
}

