/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Time;
import java.util.Calendar;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;

public class TimeParameter
extends NotLongDataParameterHolder {
    private Time time;
    private Calendar calendar;
    private boolean fractionalSeconds;

    public TimeParameter(Time time, Calendar cal, boolean fractionalSeconds, Options options) {
        this.time = time;
        this.calendar = cal;
        this.fractionalSeconds = fractionalSeconds;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.writeTime(os, this.time, this.calendar, this.fractionalSeconds);
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return 15L;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.time);
        this.calendar.set(5, 1);
        writeBuffer.writeTimeLength(this.calendar, this.fractionalSeconds);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.TIME;
    }
}

