/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MastersSlavesProtocol
extends MasterProtocol {
    boolean masterConnection = false;
    boolean mustBeMasterConnection = false;

    public MastersSlavesProtocol(UrlParser url, ReentrantLock lock) {
        super(url, lock);
    }

    public static void loop(MastersSlavesListener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        int maxConnectionTry = listener.getRetriesAllDown();
        QueryException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0) {
            MastersSlavesProtocol protocol = MastersSlavesProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed() || !listener.isSecondaryHostFail() && !listener.isMasterHostFail()) {
                return;
            }
            --maxConnectionTry;
            try {
                protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                loopAddresses.remove(0);
                protocol.connect();
                blacklist.remove(protocol.getHostAddress());
                if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                    if (MastersSlavesProtocol.foundMaster(listener, protocol, searchFilter)) {
                        return;
                    }
                } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                    if (MastersSlavesProtocol.foundSecondary(listener, protocol, searchFilter)) {
                        return;
                    }
                } else {
                    protocol.close();
                }
            }
            catch (QueryException e) {
                lastQueryException = e;
                blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
            }
            if (!searchFilter.isSearchForMaster() && !searchFilter.isSearchForSlave()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new LinkedList<HostAddress>(addresses);
            listener.checkMasterStatus(searchFilter);
        }
        if (searchFilter.isSearchForMaster() || searchFilter.isSearchForSlave()) {
            String error = "No active connection found for replica";
            if (searchFilter.isSearchForMaster()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new QueryException(error, lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
            }
            throw new QueryException(error);
        }
    }

    private static boolean foundMaster(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        searchFilter.setSearchForMaster(false);
        listener.foundActiveMaster(protocol);
        if (!searchFilter.isSearchForSlave()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFail();
    }

    private static boolean foundSecondary(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) throws QueryException {
        searchFilter.setSearchForSlave(false);
        protocol.setMustBeMasterConnection(false);
        listener.foundActiveSecondary(protocol);
        if (!searchFilter.isSearchForMaster()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlySlave() || !listener.isMasterHostFail();
    }

    public static MastersSlavesProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        MastersSlavesProtocol newProtocol = new MastersSlavesProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean mustBeMasterConnection() {
        return this.mustBeMasterConnection;
    }

    public void setMustBeMasterConnection(boolean mustBeMasterConnection) {
        this.mustBeMasterConnection = mustBeMasterConnection;
    }
}

