/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class BigIntParameter
extends NotLongDataParameterHolder {
    private BigDecimal value;

    public BigIntParameter(BigInteger value) {
        this.value = new BigDecimal(value);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.write(os, this.value);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.value.toPlainString().getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeStringLength(this.value.toPlainString());
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.VARSTRING;
    }
}

