/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLValueObject;

public class MySQLBinaryRowPacket {
    private final ValueObject[] columns;
    private final Reader reader;
    private final MySQLColumnInformation[] columnInformation;
    private final Options options;

    public MySQLBinaryRowPacket(RawPacket rawPacket, MySQLColumnInformation[] columnInformation2, Options options) throws IOException {
        this.columns = new ValueObject[columnInformation2.length];
        this.reader = new Reader(rawPacket);
        this.columnInformation = columnInformation2;
        this.options = options;
    }

    public void appendPacketIfNeeded(PacketFetcher packetFetcher) throws IOException {
        long encLength = this.reader.getSilentLengthEncodedBinary();
        long remaining = this.reader.getRemainingSize();
        while (encLength > remaining) {
            this.reader.appendPacket(packetFetcher.getRawPacket());
            encLength = this.reader.getSilentLengthEncodedBinary();
            remaining = this.reader.getRemainingSize();
        }
    }

    public void appendPacketIfNeeded(PacketFetcher packetFetcher, long encLength) throws IOException {
        long remaining = this.reader.getRemainingSize();
        while (encLength > remaining) {
            this.reader.appendPacket(packetFetcher.getRawPacket());
            encLength = this.reader.getSilentLengthEncodedBinary();
        }
    }

    public ValueObject[] getRow(PacketFetcher packetFetcher) throws IOException {
        this.reader.skipByte();
        int nullCount = (this.columnInformation.length + 9) / 8;
        byte[] nullBitsBuffer = this.reader.readRawBytes(nullCount);
        block10: for (int i = 0; i < this.columnInformation.length; ++i) {
            if ((nullBitsBuffer[(i + 2) / 8] & 1 << (i + 2) % 8) > 0) {
                this.columns[i] = new MySQLValueObject(null, this.columnInformation[i], true, this.options);
                continue;
            }
            switch (this.columnInformation[i].getType()) {
                case VARCHAR: 
                case BIT: 
                case ENUM: 
                case SET: 
                case TINYBLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case BLOB: 
                case VARSTRING: 
                case STRING: 
                case GEOMETRY: 
                case OLDDECIMAL: 
                case DECIMAL: {
                    this.appendPacketIfNeeded(packetFetcher);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytes(), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case BIGINT: {
                    this.appendPacketIfNeeded(packetFetcher, 8L);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytesWithLength(8L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case INTEGER: 
                case MEDIUMINT: {
                    this.appendPacketIfNeeded(packetFetcher, 4L);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytesWithLength(4L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case SMALLINT: 
                case YEAR: {
                    this.appendPacketIfNeeded(packetFetcher, 2L);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytesWithLength(2L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case TINYINT: {
                    this.appendPacketIfNeeded(packetFetcher, 1L);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytesWithLength(1L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case DOUBLE: {
                    this.appendPacketIfNeeded(packetFetcher, 8L);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytesWithLength(8L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case FLOAT: {
                    this.appendPacketIfNeeded(packetFetcher, 4L);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytesWithLength(4L), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                case TIME: 
                case DATE: 
                case DATETIME: 
                case TIMESTAMP: {
                    this.appendPacketIfNeeded(packetFetcher);
                    this.columns[i] = new MySQLValueObject(this.reader.getLengthEncodedBytes(), this.columnInformation[i], true, this.options);
                    continue block10;
                }
                default: {
                    this.columns[i] = new MySQLValueObject(null, this.columnInformation[i], true, this.options);
                }
            }
        }
        return this.columns;
    }
}

