/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Time;
import java.util.Calendar;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class TimeParameter
extends NotLongDataParameterHolder {
    Time time;
    Calendar calendar;
    boolean fractionalSeconds;
    Options options;

    public TimeParameter(Time time, Calendar cal, boolean fractionalSeconds, Options options) {
        this.time = time;
        this.calendar = cal;
        this.fractionalSeconds = fractionalSeconds;
        this.options = options;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.writeTime(os, this.time, this.calendar, this.fractionalSeconds);
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.time);
        this.calendar.set(5, 1);
        writeBuffer.writeTimeLength(this.calendar, this.fractionalSeconds);
    }

    @Override
    public MySQLType getMySQLType() {
        return MySQLType.TIME;
    }
}

