/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.mapstruct.ap.spi.BuilderInfo;
import org.mapstruct.ap.spi.BuilderProvider;
import org.mapstruct.ap.spi.MapStructProcessingEnvironment;
import org.mapstruct.ap.spi.MoreThanOneBuilderCreationMethodException;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class DefaultBuilderProvider
implements BuilderProvider {
    private static final Pattern JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");
    protected Elements elementUtils;
    protected Types typeUtils;

    @Override
    public void init(MapStructProcessingEnvironment processingEnvironment) {
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtils = processingEnvironment.getTypeUtils();
    }

    @Override
    public BuilderInfo findBuilderInfo(TypeMirror type) {
        TypeElement typeElement = this.getTypeElement(type);
        if (typeElement == null) {
            return null;
        }
        return this.findBuilderInfo(typeElement);
    }

    protected TypeElement getTypeElement(TypeMirror type) {
        DeclaredType declaredType = this.getDeclaredType(type);
        return this.getTypeElement(declaredType);
    }

    private TypeElement getTypeElement(DeclaredType declaredType) {
        if (declaredType == null) {
            return null;
        }
        return declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    private DeclaredType getDeclaredType(TypeMirror type) {
        if (type.getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(type);
        }
        return type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
    }

    protected BuilderInfo findBuilderInfo(TypeElement typeElement) {
        return this.findBuilderInfo(typeElement, true);
    }

    protected BuilderInfo findBuilderInfo(TypeElement typeElement, boolean checkParent) {
        if (this.shouldIgnore(typeElement)) {
            return null;
        }
        ArrayList<BuilderInfo> methodBuilderInfos = new ArrayList<BuilderInfo>();
        ArrayList<BuilderInfo> innerClassBuilderInfos = new ArrayList<BuilderInfo>();
        for (Element element : typeElement.getEnclosedElements()) {
            TypeElement classElement;
            BuilderInfo builderInfo;
            if (ElementKind.METHOD == element.getKind()) {
                ExecutableElement method = (ExecutableElement)element;
                builderInfo = this.determineMethodBuilderInfo(method, typeElement);
                if (builderInfo == null) continue;
                methodBuilderInfos.add(builderInfo);
                continue;
            }
            if (ElementKind.CLASS != element.getKind() || !methodBuilderInfos.isEmpty() || (builderInfo = this.determineInnerClassBuilderInfo(classElement = (TypeElement)element, typeElement)) == null) continue;
            innerClassBuilderInfos.add(builderInfo);
        }
        if (methodBuilderInfos.size() == 1) {
            return (BuilderInfo)methodBuilderInfos.get(0);
        }
        if (methodBuilderInfos.size() > 1) {
            throw new MoreThanOneBuilderCreationMethodException(typeElement.asType(), methodBuilderInfos);
        }
        if (innerClassBuilderInfos.size() == 1) {
            return (BuilderInfo)innerClassBuilderInfos.get(0);
        }
        if (innerClassBuilderInfos.size() > 1) {
            throw new MoreThanOneBuilderCreationMethodException(typeElement.asType(), innerClassBuilderInfos);
        }
        if (checkParent) {
            return this.findBuilderInfo(typeElement.getSuperclass());
        }
        return null;
    }

    private BuilderInfo determineMethodBuilderInfo(ExecutableElement method, TypeElement typeElement) {
        TypeElement builderElement;
        Collection<ExecutableElement> buildMethods;
        if (this.isPossibleBuilderCreationMethod(method, typeElement) && !(buildMethods = this.findBuildMethods(builderElement = this.getTypeElement(method.getReturnType()), typeElement)).isEmpty()) {
            return new BuilderInfo.Builder().builderCreationMethod(method).buildMethod(buildMethods).build();
        }
        return null;
    }

    private BuilderInfo determineInnerClassBuilderInfo(TypeElement innerClassElement, TypeElement typeElement) {
        if (innerClassElement.getModifiers().contains((Object)Modifier.PUBLIC) && innerClassElement.getModifiers().contains((Object)Modifier.STATIC) && innerClassElement.getSimpleName().toString().endsWith("Builder")) {
            for (Element element : innerClassElement.getEnclosedElements()) {
                ExecutableElement constructor;
                if (ElementKind.CONSTRUCTOR != element.getKind() || !(constructor = (ExecutableElement)element).getParameters().isEmpty()) continue;
                Collection<ExecutableElement> buildMethods = this.findBuildMethods(innerClassElement, typeElement);
                if (!buildMethods.isEmpty()) {
                    return new BuilderInfo.Builder().builderCreationMethod(constructor).buildMethod(buildMethods).build();
                }
                return null;
            }
        }
        return null;
    }

    protected boolean isPossibleBuilderCreationMethod(ExecutableElement method, TypeElement typeElement) {
        return method.getParameters().isEmpty() && method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getModifiers().contains((Object)Modifier.STATIC) && method.getReturnType().getKind() != TypeKind.VOID && !this.typeUtils.isSameType(this.typeUtils.erasure(method.getReturnType()), this.typeUtils.erasure(typeElement.asType()));
    }

    protected Collection<ExecutableElement> findBuildMethods(TypeElement builderElement, TypeElement typeElement) {
        if (this.shouldIgnore(builderElement) || typeElement == null) {
            return Collections.emptyList();
        }
        DeclaredType builderType = this.getDeclaredType(builderElement.asType());
        if (builderType == null) {
            return Collections.emptyList();
        }
        return this.findBuildMethods(builderElement, builderType, typeElement);
    }

    private Collection<ExecutableElement> findBuildMethods(TypeElement builderElement, DeclaredType builderType, TypeElement typeElement) {
        if (this.shouldIgnore(builderElement)) {
            return Collections.emptyList();
        }
        List<ExecutableElement> builderMethods = ElementFilter.methodsIn(builderElement.getEnclosedElements());
        ArrayList<ExecutableElement> buildMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement buildMethod : builderMethods) {
            if (!this.isBuildMethod(buildMethod, builderType, typeElement)) continue;
            buildMethods.add(buildMethod);
        }
        if (!buildMethods.isEmpty()) {
            return buildMethods;
        }
        Collection<ExecutableElement> parentClassBuildMethods = this.findBuildMethods(this.getTypeElement(builderElement.getSuperclass()), builderType, typeElement);
        if (!parentClassBuildMethods.isEmpty()) {
            return parentClassBuildMethods;
        }
        List<? extends TypeMirror> interfaces = builderElement.getInterfaces();
        if (interfaces.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExecutableElement> interfaceBuildMethods = new ArrayList<ExecutableElement>();
        for (TypeMirror typeMirror : interfaces) {
            interfaceBuildMethods.addAll(this.findBuildMethods(this.getTypeElement(typeMirror), builderType, typeElement));
        }
        return interfaceBuildMethods;
    }

    @Deprecated
    protected boolean isBuildMethod(ExecutableElement buildMethod, TypeElement typeElement) {
        return buildMethod.getParameters().isEmpty() && buildMethod.getModifiers().contains((Object)Modifier.PUBLIC) && this.typeUtils.isAssignable(buildMethod.getReturnType(), typeElement.asType());
    }

    protected boolean isBuildMethod(ExecutableElement buildMethod, DeclaredType builderType, TypeElement typeElement) {
        if (!buildMethod.getParameters().isEmpty()) {
            return false;
        }
        if (!buildMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return false;
        }
        TypeMirror buildMethodType = this.typeUtils.asMemberOf(builderType, buildMethod);
        if (buildMethodType instanceof ExecutableType) {
            return this.typeUtils.isAssignable(((ExecutableType)buildMethodType).getReturnType(), typeElement.asType());
        }
        return false;
    }

    protected boolean shouldIgnore(TypeElement typeElement) {
        return typeElement == null || JAVA_JAVAX_PACKAGE.matcher(typeElement.getQualifiedName()).matches();
    }
}

