/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.metadata.Attributes;
import kotlin.metadata.KmClass;
import kotlin.metadata.jvm.KotlinClassMetadata;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.MapStructProcessingEnvironment;
import org.mapstruct.ap.spi.MethodType;
import org.mapstruct.ap.spi.util.IntrospectorUtils;

public class DefaultAccessorNamingStrategy
implements AccessorNamingStrategy {
    private static final Pattern JAVA_JAVAX_PACKAGE;
    private static final boolean KOTLIN_METADATA_JVM_PRESENT;
    protected Elements elementUtils;
    protected Types typeUtils;

    @Override
    public void init(MapStructProcessingEnvironment processingEnvironment) {
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtils = processingEnvironment.getTypeUtils();
    }

    @Override
    public MethodType getMethodType(ExecutableElement method) {
        if (this.isGetterMethod(method)) {
            return MethodType.GETTER;
        }
        if (this.isSetterMethod(method)) {
            return MethodType.SETTER;
        }
        if (this.isAdderMethod(method)) {
            return MethodType.ADDER;
        }
        if (this.isPresenceCheckMethod(method)) {
            return MethodType.PRESENCE_CHECKER;
        }
        return MethodType.OTHER;
    }

    public boolean isGetterMethod(ExecutableElement method) {
        if (!method.getParameters().isEmpty()) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        boolean isNonBooleanGetterName = methodName.startsWith("get") && methodName.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
        boolean isBooleanGetterName = methodName.startsWith("is") && methodName.length() > 2;
        boolean returnTypeIsBoolean = method.getReturnType().getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(DefaultAccessorNamingStrategy.getQualifiedName(method.getReturnType()));
        return isNonBooleanGetterName || isBooleanGetterName && returnTypeIsBoolean;
    }

    public boolean isSetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("set") && methodName.length() > 3 || this.isFluentSetter(method);
    }

    protected boolean isFluentSetter(ExecutableElement method) {
        if (method.getParameters().size() != 1) {
            return false;
        }
        Element methodOwnerElement = method.getEnclosingElement();
        if (!this.canMethodOwnerBeUsedInFluentSetter(methodOwnerElement)) {
            return false;
        }
        return !this.isAdderWithUpperCase4thCharacter(method) && this.typeUtils.isAssignable(method.getReturnType(), methodOwnerElement.asType());
    }

    private boolean canMethodOwnerBeUsedInFluentSetter(Element methodOwnerElement) {
        if (!(methodOwnerElement instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)methodOwnerElement;
        if (JAVA_JAVAX_PACKAGE.matcher(typeElement.getQualifiedName().toString()).matches()) {
            return false;
        }
        return !this.isKotlinDataClass(typeElement);
    }

    private boolean isKotlinDataClass(TypeElement typeElement) {
        if (!KOTLIN_METADATA_JVM_PRESENT) {
            return false;
        }
        Metadata kotlinMetadata = typeElement.getAnnotation(Metadata.class);
        if (kotlinMetadata == null) {
            return false;
        }
        KotlinClassMetadata classMetadata = KotlinClassMetadata.readLenient((Metadata)kotlinMetadata);
        if (classMetadata instanceof KotlinClassMetadata.Class) {
            return Attributes.isData((KmClass)((KotlinClassMetadata.Class)classMetadata).getKmClass());
        }
        return false;
    }

    private boolean isAdderWithUpperCase4thCharacter(ExecutableElement method) {
        return this.isAdderMethod(method) && Character.isUpperCase(method.getSimpleName().toString().charAt(3));
    }

    public boolean isAdderMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("add") && methodName.length() > 3;
    }

    public boolean isPresenceCheckMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("has") && methodName.length() > 3;
    }

    @Override
    public String getPropertyName(ExecutableElement getterOrSetterMethod) {
        String methodName = getterOrSetterMethod.getSimpleName().toString();
        if (this.isFluentSetter(getterOrSetterMethod)) {
            if (methodName.startsWith("set") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                return IntrospectorUtils.decapitalize(methodName.substring(3));
            }
            return methodName;
        }
        return IntrospectorUtils.decapitalize(methodName.substring(methodName.startsWith("is") ? 2 : 3));
    }

    @Override
    public String getElementName(ExecutableElement adderMethod) {
        String methodName = adderMethod.getSimpleName().toString();
        return IntrospectorUtils.decapitalize(methodName.substring(3));
    }

    protected static String getQualifiedName(TypeMirror type) {
        DeclaredType declaredType = type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        TypeElement typeElement = declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
        return typeElement != null ? typeElement.getQualifiedName().toString() : null;
    }

    @Override
    public String getCollectionGetterName(String property) {
        throw new IllegalStateException("This method is not intended to be called anymore and will be removed in future versions.");
    }

    static {
        boolean kotlinMetadataJvmPresent;
        JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");
        try {
            Class.forName("kotlin.metadata.jvm.KotlinClassMetadata", false, AccessorNamingStrategy.class.getClassLoader());
            kotlinMetadataJvmPresent = true;
        }
        catch (ClassNotFoundException e) {
            kotlinMetadataJvmPresent = false;
        }
        KOTLIN_METADATA_JVM_PRESENT = kotlinMetadataJvmPresent;
    }
}

