/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.annotation.AnnotationElement;
import org.mapstruct.ap.internal.processor.AnnotationBasedComponentModelProcessor;

public class SpringComponentProcessor
extends AnnotationBasedComponentModelProcessor {
    private static final String SPRING_COMPONENT_ANNOTATION = "org.springframework.stereotype.Component";
    private static final String SPRING_PRIMARY_ANNOTATION = "org.springframework.context.annotation.Primary";

    @Override
    protected String getComponentModelIdentifier() {
        return "spring";
    }

    @Override
    protected List<Annotation> getTypeAnnotations(Mapper mapper) {
        ArrayList<Annotation> typeAnnotations = new ArrayList<Annotation>();
        if (!this.isAlreadyAnnotatedAsSpringStereotype(mapper)) {
            typeAnnotations.add(this.component());
        }
        if (mapper.getDecorator() != null) {
            typeAnnotations.add(this.qualifierDelegate());
        }
        return typeAnnotations;
    }

    @Override
    protected List<Annotation> getDecoratorAnnotations(Decorator decorator) {
        LinkedHashSet<String> desiredAnnotationNames = new LinkedHashSet<String>();
        desiredAnnotationNames.add(SPRING_COMPONENT_ANNOTATION);
        desiredAnnotationNames.add(SPRING_PRIMARY_ANNOTATION);
        List<Annotation> decoratorAnnotations = decorator.getAnnotations();
        if (!decoratorAnnotations.isEmpty()) {
            HashSet<Element> handledElements = new HashSet<Element>();
            for (Annotation annotation : decoratorAnnotations) {
                this.removeAnnotationsPresentOnElement(annotation.getType().getTypeElement(), desiredAnnotationNames, handledElements);
                if (!desiredAnnotationNames.isEmpty()) continue;
                return Collections.emptyList();
            }
        }
        return desiredAnnotationNames.stream().map(this::createAnnotation).collect(Collectors.toList());
    }

    @Override
    protected List<Annotation> getMapperReferenceAnnotations() {
        return Collections.singletonList(this.autowired());
    }

    @Override
    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Arrays.asList(this.autowired(), this.qualifierDelegate());
    }

    @Override
    protected boolean requiresGenerationOfDecoratorClass() {
        return true;
    }

    private Annotation createAnnotation(String canonicalName) {
        return new Annotation(this.getTypeFactory().getType(canonicalName));
    }

    private Annotation autowired() {
        return this.createAnnotation("org.springframework.beans.factory.annotation.Autowired");
    }

    private Annotation qualifierDelegate() {
        return new Annotation(this.getTypeFactory().getType("org.springframework.beans.factory.annotation.Qualifier"), Collections.singletonList(new AnnotationElement(AnnotationElement.AnnotationElementType.STRING, Collections.singletonList("delegate"))));
    }

    private Annotation component() {
        return this.createAnnotation(SPRING_COMPONENT_ANNOTATION);
    }

    private boolean isAlreadyAnnotatedAsSpringStereotype(Mapper mapper) {
        LinkedHashSet<String> desiredAnnotationNames = new LinkedHashSet<String>();
        desiredAnnotationNames.add(SPRING_COMPONENT_ANNOTATION);
        List<Annotation> mapperAnnotations = mapper.getAnnotations();
        if (!mapperAnnotations.isEmpty()) {
            HashSet<Element> handledElements = new HashSet<Element>();
            for (Annotation annotation : mapperAnnotations) {
                this.removeAnnotationsPresentOnElement(annotation.getType().getTypeElement(), desiredAnnotationNames, handledElements);
                if (!desiredAnnotationNames.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void removeAnnotationsPresentOnElement(Element element, Set<String> annotations, Set<Element> handledElements) {
        if (annotations.isEmpty()) {
            return;
        }
        if (element instanceof TypeElement && annotations.remove(((TypeElement)element).getQualifiedName().toString()) && annotations.isEmpty()) {
            return;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element annotationMirrorElement = annotationMirror.getAnnotationType().asElement();
            if (this.isAnnotationInPackage(annotationMirrorElement, "java.lang.annotation") || handledElements.contains(annotationMirrorElement)) continue;
            handledElements.add(annotationMirrorElement);
            if (annotations.remove(((TypeElement)annotationMirrorElement).getQualifiedName().toString()) && annotations.isEmpty()) {
                return;
            }
            this.removeAnnotationsPresentOnElement(element, annotations, handledElements);
        }
    }

    private PackageElement getPackageOf(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    private boolean isAnnotationInPackage(Element element, String packageFQN) {
        return packageFQN.equals(this.getPackageOf(element).getQualifiedName().toString());
    }
}

