/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.annotation.AnnotationElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.processor.AnnotationBasedComponentModelProcessor;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;

public class Jsr330ComponentProcessor
extends AnnotationBasedComponentModelProcessor {
    @Override
    protected String getComponentModelIdentifier() {
        return "jsr330";
    }

    @Override
    protected List<Annotation> getTypeAnnotations(Mapper mapper) {
        if (mapper.getDecorator() == null) {
            return Arrays.asList(this.singleton(), this.named());
        }
        return Arrays.asList(this.singleton(), this.namedDelegate(mapper));
    }

    @Override
    protected List<Annotation> getDecoratorAnnotations(Decorator decorator) {
        return Arrays.asList(this.singleton(), this.named());
    }

    @Override
    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Arrays.asList(this.inject(), this.namedDelegate(mapper));
    }

    @Override
    protected List<Annotation> getMapperReferenceAnnotations() {
        return Collections.singletonList(this.inject());
    }

    @Override
    protected boolean requiresGenerationOfDecoratorClass() {
        return true;
    }

    private Annotation singleton() {
        return new Annotation(this.getType("Singleton"));
    }

    private Annotation named() {
        return new Annotation(this.getType("Named"));
    }

    private Annotation namedDelegate(Mapper mapper) {
        return new Annotation(this.getType("Named"), Collections.singletonList(new AnnotationElement(AnnotationElement.AnnotationElementType.STRING, Collections.singletonList(mapper.getPackageName() + "." + mapper.getName()))));
    }

    private Annotation inject() {
        return new Annotation(this.getType("Inject"));
    }

    private Type getType(String simpleName) {
        if (this.getTypeFactory().isTypeAvailable("javax.inject." + simpleName)) {
            return this.getTypeFactory().getType("javax.inject." + simpleName);
        }
        if (this.getTypeFactory().isTypeAvailable("jakarta.inject." + simpleName)) {
            return this.getTypeFactory().getType("jakarta.inject." + simpleName);
        }
        throw new AnnotationProcessingException("Couldn't find any of the JSR330 or Jakarta Dependency Inject types. Are you missing a dependency on your classpath?");
    }
}

