/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.gem.InjectionStrategyGem;
import org.mapstruct.ap.internal.model.AnnotatedConstructor;
import org.mapstruct.ap.internal.model.AnnotatedSetter;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.AnnotationMapperReference;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;

public abstract class AnnotationBasedComponentModelProcessor
implements ModelElementProcessor<Mapper, Mapper> {
    private TypeFactory typeFactory;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        this.typeFactory = context.getTypeFactory();
        MapperOptions mapperAnnotation = MapperOptions.getInstanceOn(mapperTypeElement, context.getOptions());
        String componentModel = mapperAnnotation.componentModel();
        InjectionStrategyGem injectionStrategy = mapperAnnotation.getInjectionStrategy();
        if (!this.getComponentModelIdentifier().equalsIgnoreCase(componentModel)) {
            return mapper;
        }
        for (Annotation typeAnnotation : this.getTypeAnnotations(mapper)) {
            mapper.addAnnotation(typeAnnotation);
        }
        if (!this.requiresGenerationOfDecoratorClass()) {
            mapper.removeDecorator();
        } else if (mapper.getDecorator() != null) {
            this.adjustDecorator(mapper, injectionStrategy);
        }
        List<Annotation> annotations = this.getMapperReferenceAnnotations();
        ListIterator<Field> iterator = mapper.getFields().listIterator();
        while (iterator.hasNext()) {
            Field reference = iterator.next();
            if (!(reference instanceof MapperReference)) continue;
            iterator.remove();
            iterator.add(this.replacementMapperReference(reference, annotations, injectionStrategy));
        }
        if (injectionStrategy == InjectionStrategyGem.CONSTRUCTOR) {
            this.buildConstructors(mapper);
        } else if (injectionStrategy == InjectionStrategyGem.SETTER) {
            this.buildSetters(mapper);
        }
        return mapper;
    }

    protected void adjustDecorator(Mapper mapper, InjectionStrategyGem injectionStrategy) {
        Decorator decorator = mapper.getDecorator();
        for (Annotation typeAnnotation : this.getDecoratorAnnotations(decorator)) {
            decorator.addAnnotation(typeAnnotation);
        }
        decorator.removeConstructor();
        List<Annotation> annotations = this.getDelegatorReferenceAnnotations(mapper);
        ArrayList<Field> replacement = new ArrayList<Field>();
        if (!decorator.getMethods().isEmpty()) {
            for (Field field : decorator.getFields()) {
                replacement.add(this.replacementMapperReference(field, annotations, injectionStrategy));
            }
        }
        decorator.setFields(replacement);
    }

    private List<MapperReference> toMapperReferences(List<Field> fields) {
        ArrayList<MapperReference> mapperReferences = new ArrayList<MapperReference>();
        for (Field field : fields) {
            if (!(field instanceof MapperReference)) continue;
            mapperReferences.add((MapperReference)field);
        }
        return mapperReferences;
    }

    private void buildSetters(Mapper mapper) {
        List<MapperReference> mapperReferences = this.toMapperReferences(mapper.getFields());
        for (MapperReference mapperReference : mapperReferences) {
            if (!mapperReference.isUsed()) continue;
            AnnotatedSetter setter = new AnnotatedSetter(mapperReference, this.getMapperReferenceAnnotations(), Collections.emptyList());
            mapper.getMethods().add(setter);
        }
        Decorator decorator = mapper.getDecorator();
        if (decorator != null) {
            List<Annotation> mapperReferenceAnnotations = this.getMapperReferenceAnnotations();
            Set<Type> mapperReferenceAnnotationsTypes = mapperReferenceAnnotations.stream().map(Annotation::getType).collect(Collectors.toSet());
            for (Field field : decorator.getFields()) {
                if (!(field instanceof AnnotationMapperReference)) continue;
                List<Annotation> fieldAnnotations = ((AnnotationMapperReference)field).getAnnotations();
                List<Annotation> qualifiers = this.extractMissingAnnotations(fieldAnnotations, mapperReferenceAnnotationsTypes);
                decorator.getMethods().add(new AnnotatedSetter(field, mapperReferenceAnnotations, qualifiers));
            }
        }
    }

    private void buildConstructors(Mapper mapper) {
        AnnotatedConstructor decoratorConstructor;
        Decorator decorator;
        AnnotatedConstructor annotatedConstructor;
        if (!this.toMapperReferences(mapper.getFields()).isEmpty() && !(annotatedConstructor = this.buildAnnotatedConstructorForMapper(mapper)).getMapperReferences().isEmpty()) {
            mapper.setConstructor(annotatedConstructor);
        }
        if ((decorator = mapper.getDecorator()) != null && !(decoratorConstructor = this.buildAnnotatedConstructorForDecorator(decorator)).getMapperReferences().isEmpty()) {
            decorator.setConstructor(decoratorConstructor);
        }
    }

    private AnnotatedConstructor buildAnnotatedConstructorForMapper(Mapper mapper) {
        List<MapperReference> mapperReferences = this.toMapperReferences(mapper.getFields());
        ArrayList<AnnotationMapperReference> mapperReferencesForConstructor = new ArrayList<AnnotationMapperReference>(mapperReferences.size());
        for (MapperReference mapperReference : mapperReferences) {
            if (!mapperReference.isUsed()) continue;
            mapperReferencesForConstructor.add((AnnotationMapperReference)mapperReference);
        }
        List<Annotation> mapperReferenceAnnotations = this.getMapperReferenceAnnotations();
        this.removeDuplicateAnnotations(mapperReferencesForConstructor, mapperReferenceAnnotations);
        return AnnotatedConstructor.forComponentModels(mapper.getName(), mapperReferencesForConstructor, mapperReferenceAnnotations, mapper.getConstructor(), this.additionalPublicEmptyConstructor());
    }

    private AnnotatedConstructor buildAnnotatedConstructorForDecorator(Decorator decorator) {
        ArrayList<AnnotationMapperReference> mapperReferencesForConstructor = new ArrayList<AnnotationMapperReference>(decorator.getFields().size());
        for (Field field : decorator.getFields()) {
            if (!(field instanceof AnnotationMapperReference)) continue;
            mapperReferencesForConstructor.add((AnnotationMapperReference)field);
        }
        List<Annotation> mapperReferenceAnnotations = this.getMapperReferenceAnnotations();
        this.removeDuplicateAnnotations(mapperReferencesForConstructor, mapperReferenceAnnotations);
        return AnnotatedConstructor.forComponentModels(decorator.getName(), mapperReferencesForConstructor, mapperReferenceAnnotations, decorator.getConstructor(), this.additionalPublicEmptyConstructor());
    }

    private void removeDuplicateAnnotations(List<AnnotationMapperReference> annotationMapperReferences, List<Annotation> mapperReferenceAnnotations) {
        ListIterator<AnnotationMapperReference> mapperReferenceIterator = annotationMapperReferences.listIterator();
        HashSet<Type> mapperReferenceAnnotationsTypes = new HashSet<Type>();
        for (Annotation annotation : mapperReferenceAnnotations) {
            mapperReferenceAnnotationsTypes.add(annotation.getType());
        }
        while (mapperReferenceIterator.hasNext()) {
            AnnotationMapperReference annotationMapperReference = mapperReferenceIterator.next();
            mapperReferenceIterator.remove();
            List<Annotation> qualifiers = this.extractMissingAnnotations(annotationMapperReference.getAnnotations(), mapperReferenceAnnotationsTypes);
            mapperReferenceIterator.add(annotationMapperReference.withNewAnnotations(qualifiers));
        }
    }

    private List<Annotation> extractMissingAnnotations(List<Annotation> annotations, Set<Type> annotationTypes) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (annotationTypes.contains(annotation.getType())) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    protected boolean additionalPublicEmptyConstructor() {
        return false;
    }

    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Collections.emptyList();
    }

    protected Field replacementMapperReference(Field originalReference, List<Annotation> annotations, InjectionStrategyGem injectionStrategy) {
        boolean finalField = injectionStrategy == InjectionStrategyGem.CONSTRUCTOR && !this.additionalPublicEmptyConstructor();
        boolean includeAnnotationsOnField = injectionStrategy == InjectionStrategyGem.FIELD;
        return new AnnotationMapperReference(originalReference.getType(), originalReference.getVariableName(), annotations, originalReference.isUsed(), finalField, includeAnnotationsOnField);
    }

    protected abstract String getComponentModelIdentifier();

    protected abstract List<Annotation> getTypeAnnotations(Mapper var1);

    protected List<Annotation> getDecoratorAnnotations(Decorator decorator) {
        return Collections.emptyList();
    }

    protected abstract List<Annotation> getMapperReferenceAnnotations();

    protected abstract boolean requiresGenerationOfDecoratorClass();

    @Override
    public int getPriority() {
        return 1100;
    }

    protected TypeFactory getTypeFactory() {
        return this.typeFactory;
    }
}

