/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.CreateOrUpdateSelector;
import org.mapstruct.ap.internal.model.source.selector.FactoryParameterSelector;
import org.mapstruct.ap.internal.model.source.selector.InheritanceSelector;
import org.mapstruct.ap.internal.model.source.selector.JakartaXmlElementDeclSelector;
import org.mapstruct.ap.internal.model.source.selector.JavaxXmlElementDeclSelector;
import org.mapstruct.ap.internal.model.source.selector.LifecycleOverloadDeduplicateSelector;
import org.mapstruct.ap.internal.model.source.selector.MethodFamilySelector;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.MostSpecificResultTypeSelector;
import org.mapstruct.ap.internal.model.source.selector.QualifierSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionContext;
import org.mapstruct.ap.internal.model.source.selector.SourceRhsSelector;
import org.mapstruct.ap.internal.model.source.selector.TargetTypeSelector;
import org.mapstruct.ap.internal.model.source.selector.TypeSelector;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.TypeUtils;

public class MethodSelectors {
    private final List<MethodSelector> selectors;

    public MethodSelectors(TypeUtils typeUtils, ElementUtils elementUtils, FormattingMessager messager, Options options) {
        ArrayList<MethodSelector> selectorList = new ArrayList<MethodSelector>(Arrays.asList(new MethodFamilySelector(), new TypeSelector(messager), new QualifierSelector(typeUtils, elementUtils), new TargetTypeSelector(typeUtils), new JavaxXmlElementDeclSelector(typeUtils), new JakartaXmlElementDeclSelector(typeUtils), new InheritanceSelector()));
        if (options != null && !options.isDisableLifecycleOverloadDeduplicateSelector()) {
            selectorList.add(new LifecycleOverloadDeduplicateSelector());
        }
        selectorList.addAll(Arrays.asList(new CreateOrUpdateSelector(), new SourceRhsSelector(), new FactoryParameterSelector(), new MostSpecificResultTypeSelector()));
        this.selectors = selectorList;
    }

    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(List<T> methods, SelectionContext context) {
        List<SelectedMethod<T>> candidates = new ArrayList<SelectedMethod<T>>(methods.size());
        for (Method method : methods) {
            candidates.add(new SelectedMethod<Method>(method));
        }
        for (MethodSelector selector : this.selectors) {
            candidates = selector.getMatchingMethods(candidates, context);
        }
        return candidates;
    }
}

