/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionContext;
import org.mapstruct.ap.internal.util.Collections;

public class InheritanceSelector
implements MethodSelector {
    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(List<SelectedMethod<T>> methods, SelectionContext context) {
        Type sourceType = context.getSourceType();
        if (sourceType == null) {
            return methods;
        }
        ArrayList<SelectedMethod<T>> candidatesWithBestMatchingSourceType = new ArrayList<SelectedMethod<T>>();
        int bestMatchingSourceTypeDistance = Integer.MAX_VALUE;
        for (SelectedMethod<T> method : methods) {
            Parameter singleSourceParam = Collections.first(method.getMethod().getSourceParameters());
            int sourceTypeDistance = sourceType.distanceTo(singleSourceParam.getType());
            bestMatchingSourceTypeDistance = this.addToCandidateListIfMinimal(candidatesWithBestMatchingSourceType, bestMatchingSourceTypeDistance, method, sourceTypeDistance);
        }
        return candidatesWithBestMatchingSourceType;
    }

    private <T extends Method> int addToCandidateListIfMinimal(List<SelectedMethod<T>> candidatesWithBestMatchingType, int bestMatchingTypeDistance, SelectedMethod<T> method, int currentTypeDistance) {
        if (currentTypeDistance == bestMatchingTypeDistance) {
            candidatesWithBestMatchingType.add(method);
        } else if (currentTypeDistance < bestMatchingTypeDistance) {
            bestMatchingTypeDistance = currentTypeDistance;
            candidatesWithBestMatchingType.clear();
            candidatesWithBestMatchingType.add(method);
        }
        return bestMatchingTypeDistance;
    }
}

