/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.beanmapping.PropertyEntry;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.PresenceCheck;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.presence.AnyPresenceChecksPresenceCheck;
import org.mapstruct.ap.internal.model.presence.NullPresenceCheck;
import org.mapstruct.ap.internal.model.presence.OptionalPresenceCheck;
import org.mapstruct.ap.internal.model.presence.SuffixPresenceCheck;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.PresenceCheckAccessor;

public class NestedPropertyMappingMethod
extends MappingMethod {
    private final List<SafePropertyEntry> safePropertyEntries;

    private NestedPropertyMappingMethod(ForgedMethod method, List<SafePropertyEntry> sourcePropertyEntries) {
        super(method);
        this.safePropertyEntries = sourcePropertyEntries;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget() || parameter.isMappingContext()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public List<SafePropertyEntry> getPropertyEntries() {
        return this.safePropertyEntries;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (SafePropertyEntry propertyEntry : this.safePropertyEntries) {
            types.addAll(propertyEntry.getType().getImportTypes());
            if (propertyEntry.getPresenceChecker() == null) continue;
            types.addAll(propertyEntry.getPresenceChecker().getImportTypes());
        }
        return types;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedPropertyMappingMethod other = (NestedPropertyMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().equals(other.getSourceParameters().get(i).getType())) continue;
            return false;
        }
        return this.safePropertyEntries.equals(other.safePropertyEntries);
    }

    public static class SafePropertyEntry {
        private final String safeName;
        private final String source;
        private final PresenceCheck presenceChecker;
        private final Type type;

        public SafePropertyEntry(Type type, String safeName, String source, PresenceCheck presenceCheck) {
            this.safeName = safeName;
            this.source = source;
            this.presenceChecker = presenceCheck;
            this.type = type;
        }

        public String getName() {
            return this.safeName;
        }

        public String getSource() {
            return this.source;
        }

        public PresenceCheck getPresenceChecker() {
            return this.presenceChecker;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SafePropertyEntry)) {
                return false;
            }
            SafePropertyEntry that = (SafePropertyEntry)o;
            if (!Objects.equals(this.source, that.source)) {
                return false;
            }
            if (!Objects.equals(this.presenceChecker, that.presenceChecker)) {
                return false;
            }
            return Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            int result = this.source != null ? this.source.hashCode() : 0;
            result = 31 * result + (this.presenceChecker != null ? this.presenceChecker.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private ForgedMethod method;
        private List<PropertyEntry> propertyEntries;

        public Builder method(ForgedMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder propertyEntries(List<PropertyEntry> propertyEntries) {
            this.propertyEntries = propertyEntries;
            return this;
        }

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public NestedPropertyMappingMethod build() {
            ArrayList<String> existingVariableNames = new ArrayList<String>();
            Parameter sourceParameter = null;
            for (Parameter parameter : this.method.getSourceParameters()) {
                existingVariableNames.add(parameter.getName());
                if (sourceParameter != null || parameter.isMappingTarget() || parameter.isMappingContext()) continue;
                sourceParameter = parameter;
            }
            ArrayList<Type> thrownTypes = new ArrayList<Type>();
            ArrayList<SafePropertyEntry> safePropertyEntries = new ArrayList<SafePropertyEntry>();
            if (sourceParameter == null) {
                throw new IllegalStateException("Method " + this.method + " has no source parameter.");
            }
            String previousPropertyName = sourceParameter.getName();
            Type previousPropertyType = sourceParameter.getType();
            for (int i = 0; i < this.propertyEntries.size(); ++i) {
                PresenceCheck presenceCheck;
                PropertyEntry propertyEntry = this.propertyEntries.get(i);
                if (previousPropertyType.isOptionalType()) {
                    String optionalValueSafeName = Strings.getSafeVariableName(previousPropertyName + "Value", existingVariableNames);
                    existingVariableNames.add(optionalValueSafeName);
                    presenceCheck = this.getPresenceCheck(propertyEntry, optionalValueSafeName);
                    String optionalValueSource = previousPropertyName + ".get()";
                    boolean doesNotNeedFollowUpProperty = false;
                    if (i == this.propertyEntries.size() - 1) {
                        boolean bl = doesNotNeedFollowUpProperty = presenceCheck == null;
                        if (doesNotNeedFollowUpProperty) {
                            optionalValueSource = optionalValueSource + "." + propertyEntry.getReadAccessor().getReadValueSource();
                        }
                    }
                    Type optionalBaseType = previousPropertyType.getOptionalBaseType();
                    safePropertyEntries.add(new SafePropertyEntry(optionalBaseType, optionalValueSafeName, optionalValueSource, new OptionalPresenceCheck(previousPropertyName, this.ctx.getVersionInformation(), true)));
                    if (doesNotNeedFollowUpProperty) break;
                    previousPropertyName = optionalValueSafeName;
                } else {
                    presenceCheck = this.getPresenceCheck(propertyEntry, previousPropertyName);
                    if (i > 0) {
                        presenceCheck = presenceCheck != null ? new AnyPresenceChecksPresenceCheck(Arrays.asList(new NullPresenceCheck(previousPropertyName, true), presenceCheck)) : new NullPresenceCheck(previousPropertyName, true);
                    }
                }
                String safeName = Strings.getSafeVariableName(propertyEntry.getName(), existingVariableNames);
                String source = previousPropertyName + "." + propertyEntry.getReadAccessor().getReadValueSource();
                safePropertyEntries.add(new SafePropertyEntry(propertyEntry.getType(), safeName, source, presenceCheck));
                existingVariableNames.add(safeName);
                thrownTypes.addAll(this.ctx.getTypeFactory().getThrownTypes(propertyEntry.getReadAccessor()));
                previousPropertyName = safeName;
                previousPropertyType = propertyEntry.getType();
            }
            this.method.addThrownTypes(thrownTypes);
            return new NestedPropertyMappingMethod(this.method, safePropertyEntries);
        }

        private PresenceCheck getPresenceCheck(PropertyEntry propertyEntry, String previousPropertyName) {
            PresenceCheckAccessor propertyPresenceChecker = propertyEntry.getPresenceChecker();
            if (propertyPresenceChecker != null) {
                return new SuffixPresenceCheck(previousPropertyName, propertyPresenceChecker.getPresenceCheckSuffix(), true);
            }
            return null;
        }
    }
}

