/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.mapstruct.ap.internal.model.BeanMappingMethod;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.ValueMappingMethod;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.MappingMethodUtils;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Message;

class AbstractBaseBuilder<B extends AbstractBaseBuilder<B>> {
    protected B myself;
    protected MappingBuilderContext ctx;
    protected Method method;

    AbstractBaseBuilder(Class<B> selfType) {
        this.myself = (AbstractBaseBuilder)selfType.cast(this);
    }

    public B mappingContext(MappingBuilderContext mappingContext) {
        this.ctx = mappingContext;
        return this.myself;
    }

    public B method(Method sourceMethod) {
        this.method = sourceMethod;
        return this.myself;
    }

    boolean canGenerateAutoSubMappingBetween(Type sourceType, Type targetType) {
        return !this.isDisableSubMappingMethodsGeneration() && this.ctx.canGenerateAutoSubMappingBetween(sourceType, targetType);
    }

    private boolean isDisableSubMappingMethodsGeneration() {
        return this.method.getOptions().getMapper().isDisableSubMappingMethodsGeneration();
    }

    Assignment createForgedAssignment(SourceRHS sourceRHS, ForgedMethod forgedMethod) {
        Supplier<MappingMethod> forgedMappingMethodCreator = MappingMethodUtils.isEnumMapping(forgedMethod) ? () -> new ValueMappingMethod.Builder().method(forgedMethod).valueMappings(forgedMethod.getOptions().getValueMappings()).enumMapping(forgedMethod.getOptions().getEnumMappingOptions()).mappingContext(this.ctx).build() : () -> ((BeanMappingMethod.Builder)new BeanMappingMethod.Builder().forgedMethod(forgedMethod).mappingContext(this.ctx)).build();
        return this.getOrCreateForgedAssignment(sourceRHS, forgedMethod, forgedMappingMethodCreator);
    }

    Assignment getOrCreateForgedAssignment(SourceRHS sourceRHS, ForgedMethod forgedMethod, Supplier<MappingMethod> mappingMethodCreator) {
        if (this.ctx.getForgedMethodsUnderCreation().containsKey(forgedMethod)) {
            return this.createAssignment(sourceRHS, this.ctx.getForgedMethodsUnderCreation().get(forgedMethod));
        }
        this.ctx.getForgedMethodsUnderCreation().put(forgedMethod, forgedMethod);
        MappingMethod forgedMappingMethod = mappingMethodCreator.get();
        Assignment forgedAssignment = this.createForgedAssignment(sourceRHS, forgedMethod, forgedMappingMethod);
        this.ctx.getForgedMethodsUnderCreation().remove(forgedMethod);
        return forgedAssignment;
    }

    Assignment createForgedAssignment(SourceRHS source, ForgedMethod methodRef, MappingMethod mappingMethod) {
        if (mappingMethod == null) {
            return null;
        }
        if (methodRef.getMappingReferences().isRestrictToDefinedMappings() || !this.ctx.getMappingsToGenerate().contains(mappingMethod)) {
            this.ctx.getMappingsToGenerate().add(mappingMethod);
        } else {
            String existingName = this.ctx.getExistingMappingMethod(mappingMethod).getName();
            methodRef = new ForgedMethod(existingName, methodRef);
        }
        return this.createAssignment(source, methodRef);
    }

    private Assignment createAssignment(SourceRHS source, ForgedMethod methodRef) {
        MethodReference assignment = MethodReference.forForgedMethod(methodRef, ParameterBinding.fromParameters(methodRef.getParameters()));
        assignment.setAssignment(source);
        return assignment;
    }

    void reportCannotCreateMapping(Method method, String sourceErrorMessagePart, Type sourceType, Type targetType, String targetPropertyName) {
        this.ctx.getMessager().printMessage((Element)method.getExecutable(), Message.PROPERTYMAPPING_MAPPING_NOT_FOUND, sourceErrorMessagePart, targetType.describe(), targetPropertyName, targetType.describe(), sourceType.describe());
    }

    void reportCannotCreateMapping(Method method, AnnotationMirror posHint, String sourceErrorMessagePart, Type sourceType, Type targetType, String targetPropertyName) {
        this.ctx.getMessager().printMessage((Element)method.getExecutable(), posHint, Message.PROPERTYMAPPING_MAPPING_NOT_FOUND, sourceErrorMessagePart, targetType.describe(), targetPropertyName, targetType.describe(), sourceType.describe());
    }
}

