/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class IgnoredGem
implements Gem {
    private final GemValue<List<String>> targets;
    private final GemValue<String> prefix;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private IgnoredGem(BuilderImpl builder) {
        this.targets = builder.targets;
        this.prefix = builder.prefix;
        this.isValid = this.targets != null && this.targets.isValid() && this.prefix != null && this.prefix.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<List<String>> targets() {
        return this.targets;
    }

    public GemValue<String> prefix() {
        return this.prefix;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static IgnoredGem instanceOn(Element element) {
        return IgnoredGem.build(element, new BuilderImpl());
    }

    public static IgnoredGem instanceOn(AnnotationMirror mirror) {
        return IgnoredGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "org.mapstruct.Ignored".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return IgnoredGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if ("targets".equals(methodName)) {
                builder.setTargets(GemValue.createArray((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
                continue;
            }
            if (!"prefix".equals(methodName)) continue;
            builder.setPrefix(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<IgnoredGem> {
        private GemValue<List<String>> targets;
        private GemValue<String> prefix;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setTargets(GemValue<List<String>> targets) {
            this.targets = targets;
            return this;
        }

        @Override
        public Builder setPrefix(GemValue<String> prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public IgnoredGem build() {
            return new IgnoredGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setTargets(GemValue<List<String>> var1);

        public Builder setPrefix(GemValue<String> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

