/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.AbstractNumberToStringConversion;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;

public class WrapperToStringConversion
extends AbstractNumberToStringConversion {
    private final Class<?> sourceType;
    private final Class<?> primitiveType;

    public WrapperToStringConversion(Class<?> sourceType) {
        super(NativeTypes.isNumber(sourceType));
        if (sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no wrapper type.");
        }
        this.sourceType = sourceType;
        this.primitiveType = NativeTypes.getPrimitiveType(sourceType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".format( <SOURCE> )");
            return sb.toString();
        }
        return "String.valueOf( <SOURCE> )";
    }

    @Override
    public Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            if (conversionContext.getLocale() != null) {
                return Collections.asSet(conversionContext.getTypeFactory().getType(DecimalFormat.class), conversionContext.getTypeFactory().getType(DecimalFormatSymbols.class), conversionContext.getTypeFactory().getType(Locale.class));
            }
            return java.util.Collections.singleton(conversionContext.getTypeFactory().getType(DecimalFormat.class));
        }
        return java.util.Collections.emptySet();
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".parse( <SOURCE> ).");
            sb.append(this.primitiveType.getSimpleName());
            sb.append("Value()");
            return sb.toString();
        }
        return this.sourceType.getSimpleName() + ".parse" + Strings.capitalize(this.primitiveType.getSimpleName()) + "( <SOURCE> )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            if (conversionContext.getLocale() != null) {
                return Collections.asSet(conversionContext.getTypeFactory().getType(DecimalFormat.class), conversionContext.getTypeFactory().getType(DecimalFormatSymbols.class), conversionContext.getTypeFactory().getType(Locale.class));
            }
            return java.util.Collections.singleton(conversionContext.getTypeFactory().getType(DecimalFormat.class));
        }
        return java.util.Collections.emptySet();
    }

    private void appendDecimalFormatter(StringBuilder sb, ConversionContext conversionContext) {
        sb.append("new ");
        sb.append(ConversionUtils.decimalFormat(conversionContext));
        sb.append("( ");
        if (conversionContext.getNumberFormat() != null) {
            sb.append("\"");
            sb.append(conversionContext.getNumberFormat());
            sb.append("\"");
            if (conversionContext.getLocale() != null) {
                sb.append(", ").append(ConversionUtils.decimalFormatSymbols(conversionContext)).append(".getInstance( ").append(ConversionUtils.locale(conversionContext)).append(".forLanguageTag( \"").append(conversionContext.getLocale()).append(" \" ) )");
            }
        }
        sb.append(" )");
    }
}

