/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.IterableCreation;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.PresenceCheck;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.presence.NullPresenceCheck;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.Strings;

public abstract class ContainerMappingMethod
extends NormalTypeMappingMethod {
    private final Assignment elementAssignment;
    private final String loopVariableName;
    private final SelectionParameters selectionParameters;
    private final String index1Name;
    private final String index2Name;
    private final Parameter sourceParameter;
    private final PresenceCheck sourceParameterPresenceCheck;
    private IterableCreation iterableCreation;

    ContainerMappingMethod(Method method, List<Annotation> annotations, Collection<String> existingVariables, Assignment parameterAssignment, MethodReference factoryMethod, boolean mapNullToDefault, String loopVariableName, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, SelectionParameters selectionParameters) {
        super(method, annotations, existingVariables, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.elementAssignment = parameterAssignment;
        this.loopVariableName = loopVariableName;
        this.selectionParameters = selectionParameters;
        this.index1Name = Strings.getSafeVariableName("i", existingVariables);
        this.index2Name = Strings.getSafeVariableName("j", existingVariables);
        Parameter sourceParameter = null;
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget() || parameter.isMappingContext()) continue;
            sourceParameter = parameter;
            break;
        }
        if (sourceParameter == null) {
            throw new IllegalStateException("Method " + this + " has no source parameter.");
        }
        this.sourceParameter = sourceParameter;
        this.sourceParameterPresenceCheck = new NullPresenceCheck(this.sourceParameter.getName());
    }

    public Parameter getSourceParameter() {
        return this.sourceParameter;
    }

    public PresenceCheck getSourceParameterPresenceCheck() {
        return this.sourceParameterPresenceCheck;
    }

    public IterableCreation getIterableCreation() {
        if (this.iterableCreation == null) {
            this.iterableCreation = IterableCreation.create(this, this.getSourceParameter());
        }
        return this.iterableCreation;
    }

    public Assignment getElementAssignment() {
        return this.elementAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.elementAssignment != null) {
            types.addAll(this.elementAssignment.getImportTypes());
        }
        if (this.iterableCreation != null) {
            types.addAll(this.iterableCreation.getImportTypes());
        }
        return types;
    }

    public String getLoopVariableName() {
        return this.loopVariableName;
    }

    public abstract Type getResultElementType();

    public String getIndex1Name() {
        return this.index1Name;
    }

    public String getIndex2Name() {
        return this.index2Name;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ContainerMappingMethod other = (ContainerMappingMethod)obj;
        return Objects.equals(this.selectionParameters, other.selectionParameters);
    }
}

