/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.mapstruct.ap.internal.gem.CollectionMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.ImplementationType;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.Filters;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Nouns;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.AccessorType;
import org.mapstruct.ap.internal.util.accessor.FieldElementAccessor;
import org.mapstruct.ap.internal.util.accessor.MapValueAccessor;
import org.mapstruct.ap.internal.util.accessor.PresenceCheckAccessor;
import org.mapstruct.ap.internal.util.accessor.ReadAccessor;

public class Type
extends ModelElement
implements Comparable<Type> {
    private final TypeUtils typeUtils;
    private final ElementUtils elementUtils;
    private final TypeFactory typeFactory;
    private final AccessorNamingUtils accessorNaming;
    private final TypeMirror typeMirror;
    private final TypeElement typeElement;
    private final List<Type> typeParameters;
    private final ImplementationType implementationType;
    private final Type componentType;
    private final Type topLevelType;
    private final String packageName;
    private final String name;
    private final String nameWithTopLevelTypeName;
    private final String qualifiedName;
    private final boolean isInterface;
    private final boolean isEnumType;
    private final boolean isIterableType;
    private final boolean isCollectionType;
    private final boolean isMapType;
    private final boolean isVoid;
    private final boolean isStream;
    private final boolean isLiteral;
    private final boolean loggingVerbose;
    private final List<String> enumConstants;
    private final Map<String, String> toBeImportedTypes;
    private final Map<String, String> notToBeImportedTypes;
    private Boolean isToBeImported;
    private Map<String, ReadAccessor> readAccessors = null;
    private Map<String, PresenceCheckAccessor> presenceCheckers = null;
    private List<ExecutableElement> allMethods = null;
    private List<VariableElement> allFields = null;
    private List<Element> recordComponents = null;
    private List<Accessor> setters = null;
    private List<Accessor> adders = null;
    private List<Accessor> alternativeTargetAccessors = null;
    private Type boundingBase = null;
    private List<Type> boundTypes = null;
    private Type boxedEquivalent = null;
    private Boolean hasAccessibleConstructor;
    private final Filters filters;

    public Type(TypeUtils typeUtils, ElementUtils elementUtils, TypeFactory typeFactory, AccessorNamingUtils accessorNaming, TypeMirror typeMirror, TypeElement typeElement, List<Type> typeParameters, ImplementationType implementationType, Type componentType, String packageName, String name, String qualifiedName, boolean isInterface, boolean isEnumType, boolean isIterableType, boolean isCollectionType, boolean isMapType, boolean isStreamType, Map<String, String> toBeImportedTypes, Map<String, String> notToBeImportedTypes, Boolean isToBeImported, boolean isLiteral, boolean loggingVerbose) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.typeFactory = typeFactory;
        this.accessorNaming = accessorNaming;
        this.typeMirror = typeMirror;
        this.typeElement = typeElement;
        this.typeParameters = typeParameters;
        this.componentType = componentType;
        this.implementationType = implementationType;
        this.packageName = packageName;
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.isInterface = isInterface;
        this.isEnumType = isEnumType;
        this.isIterableType = isIterableType;
        this.isCollectionType = isCollectionType;
        this.isMapType = isMapType;
        this.isStream = isStreamType;
        this.isVoid = typeMirror.getKind() == TypeKind.VOID;
        this.isLiteral = isLiteral;
        if (isEnumType) {
            this.enumConstants = new ArrayList<String>();
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                this.enumConstants.add(element.getSimpleName().toString());
            }
        } else {
            this.enumConstants = java.util.Collections.emptyList();
        }
        this.isToBeImported = isToBeImported;
        this.toBeImportedTypes = toBeImportedTypes;
        this.notToBeImportedTypes = notToBeImportedTypes;
        this.filters = new Filters(accessorNaming, typeUtils, typeMirror);
        this.loggingVerbose = loggingVerbose;
        TypeElement typeElementForTopLevel = Boolean.TRUE.equals(isToBeImported) ? null : (this.componentType == null ? this.typeElement : this.componentType.getTypeElement());
        this.topLevelType = Type.topLevelType(typeElementForTopLevel, this.typeFactory);
        this.nameWithTopLevelTypeName = Type.nameWithTopLevelTypeName(typeElementForTopLevel, this.name);
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String createReferenceName() {
        if (this.isToBeImported()) {
            if (this.isTopLevelTypeToBeImported()) {
                return this.nameWithTopLevelTypeName != null ? this.nameWithTopLevelTypeName : this.name;
            }
            return this.name;
        }
        if (this.shouldUseSimpleName()) {
            return this.name;
        }
        if (this.isTopLevelTypeToBeImported() && this.nameWithTopLevelTypeName != null) {
            return this.nameWithTopLevelTypeName;
        }
        return this.qualifiedName;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public boolean isAbstract() {
        return this.typeElement != null && this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isString() {
        return String.class.getName().equals(this.getFullyQualifiedName());
    }

    public List<String> getEnumConstants() {
        return this.enumConstants;
    }

    public Type getImplementationType() {
        return this.implementationType != null ? this.implementationType.getType() : null;
    }

    public ImplementationType getImplementation() {
        return this.implementationType;
    }

    public boolean isIterableType() {
        return this.isIterableType || this.isArrayType();
    }

    public boolean isIterableOrStreamType() {
        return this.isIterableType() || this.isStreamType();
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isMapType() {
        return this.isMapType;
    }

    private boolean hasStringMapSignature() {
        List<Type> typeParameters;
        return this.isMapType() && (typeParameters = this.getTypeParameters()).size() == 2 && typeParameters.get(0).isString();
    }

    public boolean isCollectionOrMapType() {
        return this.isCollectionType || this.isMapType;
    }

    public boolean isArrayType() {
        return this.componentType != null;
    }

    public boolean isTypeVar() {
        return this.typeMirror.getKind() == TypeKind.TYPEVAR;
    }

    public boolean isIntersection() {
        return this.typeMirror.getKind() == TypeKind.INTERSECTION;
    }

    public boolean isJavaLangType() {
        return this.packageName != null && this.packageName.startsWith("java.");
    }

    public boolean isRecord() {
        return this.typeElement.getKind().name().equals("RECORD");
    }

    public boolean isStreamType() {
        return this.isStream;
    }

    public boolean hasSuperBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildcardType = (WildcardType)this.typeMirror;
            result = wildcardType.getSuperBound() != null;
        }
        return result;
    }

    public boolean hasExtendsBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildcardType = (WildcardType)this.typeMirror;
            result = wildcardType.getExtendsBound() != null;
        }
        return result;
    }

    public boolean hasLowerBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVarType = (TypeVariable)this.typeMirror;
            result = typeVarType.getLowerBound() != null;
        }
        return result;
    }

    public boolean hasUpperBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVarType = (TypeVariable)this.typeMirror;
            result = typeVarType.getUpperBound() != null;
        }
        return result;
    }

    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    public String getImportName() {
        return this.isArrayType() ? this.trimSimpleClassName(this.qualifiedName) : this.qualifiedName;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> result = new HashSet<Type>();
        if (this.getTypeMirror().getKind() == TypeKind.DECLARED) {
            result.add(this);
        }
        if (this.componentType != null) {
            result.addAll(this.componentType.getImportTypes());
        }
        if (this.topLevelType != null) {
            result.addAll(this.topLevelType.getImportTypes());
        }
        for (Type parameter : this.typeParameters) {
            result.addAll(parameter.getImportTypes());
        }
        if ((this.hasExtendsBound() || this.hasSuperBound()) && this.getTypeBound() != null) {
            result.addAll(this.getTypeBound().getImportTypes());
        }
        return result;
    }

    protected boolean isTopLevelTypeToBeImported() {
        return this.topLevelType != null && this.topLevelType.isToBeImported();
    }

    public boolean isToBeImported() {
        if (this.isToBeImported == null) {
            String trimmedName = this.trimSimpleClassName(this.name);
            if (this.notToBeImportedTypes.containsKey(trimmedName)) {
                this.isToBeImported = false;
                return this.isToBeImported;
            }
            String trimmedQualifiedName = this.trimSimpleClassName(this.qualifiedName);
            String importedType = this.toBeImportedTypes.get(trimmedName);
            this.isToBeImported = false;
            if (importedType != null) {
                if (importedType.equals(trimmedQualifiedName)) {
                    this.isToBeImported = true;
                }
            } else if (this.typeElement == null || !this.typeElement.getNestingKind().isNested()) {
                this.toBeImportedTypes.put(trimmedName, trimmedQualifiedName);
                this.isToBeImported = true;
            }
        }
        return this.isToBeImported;
    }

    private boolean shouldUseSimpleName() {
        String trimmedName = this.trimSimpleClassName(this.name);
        String fqn = this.notToBeImportedTypes.get(trimmedName);
        return this.trimSimpleClassName(this.qualifiedName).equals(fqn);
    }

    public Type erasure() {
        return new Type(this.typeUtils, this.elementUtils, this.typeFactory, this.accessorNaming, this.typeUtils.erasure(this.typeMirror), this.typeElement, this.typeParameters, this.implementationType, this.componentType, this.packageName, this.name, this.qualifiedName, this.isInterface, this.isEnumType, this.isIterableType, this.isCollectionType, this.isMapType, this.isStream, this.toBeImportedTypes, this.notToBeImportedTypes, this.isToBeImported, this.isLiteral, this.loggingVerbose);
    }

    public Type withoutBounds() {
        if (this.typeParameters.isEmpty()) {
            return this;
        }
        ArrayList<Type> bounds = new ArrayList<Type>(this.typeParameters.size());
        ArrayList<TypeMirror> mirrors = new ArrayList<TypeMirror>(this.typeParameters.size());
        for (Type typeParameter : this.typeParameters) {
            bounds.add(typeParameter.getTypeBound());
            mirrors.add(typeParameter.getTypeBound().getTypeMirror());
        }
        DeclaredType declaredType = this.typeUtils.getDeclaredType(this.typeElement, mirrors.toArray(new TypeMirror[0]));
        return new Type(this.typeUtils, this.elementUtils, this.typeFactory, this.accessorNaming, declaredType, (TypeElement)declaredType.asElement(), bounds, this.implementationType, this.componentType, this.packageName, this.name, this.qualifiedName, this.isInterface, this.isEnumType, this.isIterableType, this.isCollectionType, this.isMapType, this.isStream, this.toBeImportedTypes, this.notToBeImportedTypes, this.isToBeImported, this.isLiteral, this.loggingVerbose);
    }

    public boolean isAssignableTo(Type other) {
        if (TypeKind.WILDCARD == this.typeMirror.getKind()) {
            return this.typeUtils.contains(this.typeMirror, other.typeMirror);
        }
        return this.typeUtils.isAssignable(this.typeMirror, other.typeMirror);
    }

    public boolean isRawAssignableTo(Type other) {
        if (this.isTypeVar() || other.isTypeVar()) {
            return true;
        }
        if (this.equals(other)) {
            return true;
        }
        return this.typeUtils.isAssignable(this.typeUtils.erasure(this.typeMirror), this.typeUtils.erasure(other.typeMirror));
    }

    public Type asRawType() {
        if (this.getTypeBound() != null) {
            return this.typeFactory.getType(this.typeUtils.erasure(this.typeMirror));
        }
        return this;
    }

    public ReadAccessor getReadAccessor(String propertyName) {
        if (this.hasStringMapSignature()) {
            ExecutableElement getMethod = this.getAllMethods().stream().filter(m -> m.getSimpleName().contentEquals("get")).filter(m -> m.getParameters().size() == 1).findAny().orElse(null);
            return new MapValueAccessor(getMethod, this.typeParameters.get(1).getTypeMirror(), propertyName);
        }
        Map<String, ReadAccessor> readAccessors = this.getPropertyReadAccessors();
        return readAccessors.get(propertyName);
    }

    public PresenceCheckAccessor getPresenceChecker(String propertyName) {
        if (this.hasStringMapSignature()) {
            return PresenceCheckAccessor.mapContainsKey(propertyName);
        }
        Map<String, PresenceCheckAccessor> presenceCheckers = this.getPropertyPresenceCheckers();
        return presenceCheckers.get(propertyName);
    }

    public Map<String, ReadAccessor> getPropertyReadAccessors() {
        if (this.readAccessors == null) {
            String propertyName;
            LinkedHashMap<String, ReadAccessor> modifiableGetters = new LinkedHashMap<String, ReadAccessor>();
            Map<String, ReadAccessor> recordAccessors = this.filters.recordAccessorsIn(this.getRecordComponents());
            modifiableGetters.putAll(recordAccessors);
            List<ReadAccessor> getterList = this.filters.getterMethodsIn(this.getAllMethods());
            for (ReadAccessor getter : getterList) {
                String simpleName = getter.getSimpleName();
                if (recordAccessors.containsKey(simpleName) || recordAccessors.containsKey(propertyName = this.getPropertyName(getter))) continue;
                if (modifiableGetters.containsKey(propertyName)) {
                    if (simpleName.startsWith("is")) continue;
                    modifiableGetters.put(propertyName, getter);
                    continue;
                }
                modifiableGetters.put(propertyName, getter);
            }
            List<ReadAccessor> fieldsList = this.filters.fieldsIn(this.getAllFields(), ReadAccessor::fromField);
            for (ReadAccessor field : fieldsList) {
                propertyName = this.getPropertyName(field);
                modifiableGetters.putIfAbsent(propertyName, field);
            }
            this.readAccessors = java.util.Collections.unmodifiableMap(modifiableGetters);
        }
        return this.readAccessors;
    }

    public Map<String, PresenceCheckAccessor> getPropertyPresenceCheckers() {
        if (this.presenceCheckers == null) {
            List<ExecutableElement> checkerList = this.filters.presenceCheckMethodsIn(this.getAllMethods());
            LinkedHashMap<String, PresenceCheckAccessor> modifiableCheckers = new LinkedHashMap<String, PresenceCheckAccessor>();
            for (ExecutableElement checker : checkerList) {
                modifiableCheckers.put(this.getPropertyName(checker), PresenceCheckAccessor.methodInvocation(checker));
            }
            this.presenceCheckers = java.util.Collections.unmodifiableMap(modifiableCheckers);
        }
        return this.presenceCheckers;
    }

    public Map<String, Accessor> getPropertyWriteAccessors(CollectionMappingStrategyGem cmStrategy) {
        ArrayList<Accessor> candidates = new ArrayList<Accessor>(this.getSetters());
        candidates.addAll(this.getAlternativeTargetAccessors());
        LinkedHashMap<String, Accessor> result = new LinkedHashMap<String, Accessor>();
        for (Accessor candidate : candidates) {
            Accessor previousCandidate;
            String targetPropertyName = this.getPropertyName(candidate);
            Accessor readAccessor = this.getPropertyReadAccessors().get(targetPropertyName);
            Type preferredType = this.determinePreferredType(readAccessor);
            Type targetType = this.determineTargetType(candidate);
            if (cmStrategy == CollectionMappingStrategyGem.SETTER_PREFERRED || cmStrategy == CollectionMappingStrategyGem.ADDER_PREFERRED || cmStrategy == CollectionMappingStrategyGem.TARGET_IMMUTABLE) {
                Accessor adderMethod = null;
                if (candidate.getAccessorType() == AccessorType.SETTER && cmStrategy == CollectionMappingStrategyGem.ADDER_PREFERRED) {
                    adderMethod = this.getAdderForType(targetType, targetPropertyName);
                } else if (candidate.getAccessorType() == AccessorType.GETTER) {
                    adderMethod = this.getAdderForType(targetType, targetPropertyName);
                }
                if (adderMethod != null) {
                    candidate = adderMethod;
                }
            } else if (candidate.getAccessorType() == AccessorType.FIELD && (Executables.isFinal(candidate) || result.containsKey(targetPropertyName))) continue;
            if ((previousCandidate = (Accessor)result.get(targetPropertyName)) != null && preferredType != null && (targetType == null || !this.typeUtils.isAssignable(preferredType.getTypeMirror(), targetType.getTypeMirror()))) continue;
            result.put(targetPropertyName, candidate);
        }
        return result;
    }

    public List<Element> getRecordComponents() {
        if (this.recordComponents == null) {
            this.recordComponents = this.nullSafeTypeElementListConversion(this.filters::recordComponentsIn);
        }
        return this.recordComponents;
    }

    private Type determinePreferredType(Accessor readAccessor) {
        if (readAccessor != null) {
            return this.typeFactory.getReturnType((DeclaredType)this.typeMirror, readAccessor);
        }
        return null;
    }

    private Type determineTargetType(Accessor candidate) {
        Parameter parameter = this.typeFactory.getSingleParameter((DeclaredType)this.typeMirror, candidate);
        if (parameter != null) {
            return parameter.getType();
        }
        if (candidate.getAccessorType() == AccessorType.GETTER || candidate.getAccessorType().isFieldAssignment()) {
            return this.typeFactory.getReturnType((DeclaredType)this.typeMirror, candidate);
        }
        return null;
    }

    private List<ExecutableElement> getAllMethods() {
        if (this.allMethods == null) {
            this.allMethods = this.nullSafeTypeElementListConversion(this.elementUtils::getAllEnclosedExecutableElements);
        }
        return this.allMethods;
    }

    private List<VariableElement> getAllFields() {
        if (this.allFields == null) {
            this.allFields = this.nullSafeTypeElementListConversion(this.elementUtils::getAllEnclosedFields);
        }
        return this.allFields;
    }

    private <T> List<T> nullSafeTypeElementListConversion(Function<TypeElement, List<T>> conversionFunction) {
        if (this.typeElement != null) {
            return conversionFunction.apply(this.typeElement);
        }
        return java.util.Collections.emptyList();
    }

    private String getPropertyName(Accessor accessor) {
        Element accessorElement = accessor.getElement();
        if (accessorElement instanceof ExecutableElement) {
            return this.getPropertyName((ExecutableElement)accessorElement);
        }
        return accessor.getSimpleName();
    }

    private String getPropertyName(ExecutableElement element) {
        return this.accessorNaming.getPropertyName(element);
    }

    private Accessor getAdderForType(Type collectionProperty, String pluralPropertyName) {
        List<Accessor> candidates;
        if (collectionProperty.isCollectionType()) {
            candidates = this.getAccessorCandidates(collectionProperty, Iterable.class);
        } else if (collectionProperty.isStreamType()) {
            candidates = this.getAccessorCandidates(collectionProperty, Stream.class);
        } else {
            return null;
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        for (Accessor candidate : candidates) {
            String elementName = this.accessorNaming.getElementNameForAdder(candidate);
            if (elementName == null || !elementName.equals(Nouns.singularize(pluralPropertyName))) continue;
            return candidate;
        }
        return null;
    }

    private List<Accessor> getAccessorCandidates(Type property, Class<?> superclass) {
        TypeMirror typeArg = Collections.first(property.determineTypeArguments(superclass)).getTypeBound().getTypeMirror();
        List<Accessor> adderList = this.getAdders();
        ArrayList<Accessor> candidateList = new ArrayList<Accessor>();
        for (Accessor adder : adderList) {
            ExecutableElement executable = (ExecutableElement)adder.getElement();
            VariableElement arg = executable.getParameters().get(0);
            if (!this.typeUtils.isSameType(this.boxed(arg.asType()), this.boxed(typeArg))) continue;
            candidateList.add(adder);
        }
        return candidateList;
    }

    private TypeMirror boxed(TypeMirror possiblePrimitive) {
        if (possiblePrimitive.getKind().isPrimitive()) {
            return this.typeUtils.boxedClass((PrimitiveType)possiblePrimitive).asType();
        }
        return possiblePrimitive;
    }

    private List<Accessor> getSetters() {
        if (this.setters == null) {
            this.setters = java.util.Collections.unmodifiableList(this.filters.setterMethodsIn(this.getAllMethods()));
        }
        return this.setters;
    }

    private List<Accessor> getAdders() {
        if (this.adders == null) {
            this.adders = java.util.Collections.unmodifiableList(this.filters.adderMethodsIn(this.getAllMethods()));
        }
        return this.adders;
    }

    private List<Accessor> getAlternativeTargetAccessors() {
        if (this.alternativeTargetAccessors != null) {
            return this.alternativeTargetAccessors;
        }
        if (this.isRecord()) {
            this.alternativeTargetAccessors = java.util.Collections.emptyList();
        }
        if (this.alternativeTargetAccessors == null) {
            ArrayList<Accessor> result = new ArrayList<Accessor>();
            List<Accessor> setterMethods = this.getSetters();
            ArrayList<ReadAccessor> readAccessors = new ArrayList<ReadAccessor>(this.getPropertyReadAccessors().values());
            readAccessors.addAll(this.filters.fieldsIn(this.getAllFields(), FieldElementAccessor::new));
            for (Accessor accessor : readAccessors) {
                if (this.isCollectionOrMapOrStream(accessor) && !this.correspondingSetterMethodExists(accessor, setterMethods)) {
                    result.add(accessor);
                    continue;
                }
                if (accessor.getAccessorType() != AccessorType.FIELD || this.correspondingSetterMethodExists(accessor, setterMethods)) continue;
                result.add(accessor);
            }
            this.alternativeTargetAccessors = java.util.Collections.unmodifiableList(result);
        }
        return this.alternativeTargetAccessors;
    }

    private boolean correspondingSetterMethodExists(Accessor getterMethod, List<Accessor> setterMethods) {
        String getterPropertyName = this.getPropertyName(getterMethod);
        for (Accessor setterMethod : setterMethods) {
            String setterPropertyName = this.getPropertyName(setterMethod);
            if (!getterPropertyName.equals(setterPropertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollectionOrMapOrStream(Accessor getterMethod) {
        return this.isCollection(getterMethod.getAccessedType()) || this.isMap(getterMethod.getAccessedType()) || this.isStream(getterMethod.getAccessedType());
    }

    private boolean isCollection(TypeMirror candidate) {
        return this.isSubType(candidate, Collection.class);
    }

    private boolean isStream(TypeMirror candidate) {
        TypeElement streamTypeElement = this.elementUtils.getTypeElement("java.util.stream.Stream");
        TypeMirror streamType = streamTypeElement == null ? null : this.typeUtils.erasure(streamTypeElement.asType());
        return streamType != null && this.typeUtils.isSubtypeErased(candidate, streamType);
    }

    private boolean isMap(TypeMirror candidate) {
        return this.isSubType(candidate, Map.class);
    }

    private boolean isSubType(TypeMirror candidate, Class<?> clazz) {
        String className = clazz.getCanonicalName();
        TypeMirror classType = this.typeUtils.erasure(this.elementUtils.getTypeElement(className).asType());
        return this.typeUtils.isSubtypeErased(candidate, classType);
    }

    public int distanceTo(Type assignableOther) {
        return this.distanceTo(this.typeMirror, assignableOther.typeMirror);
    }

    private int distanceTo(TypeMirror base, TypeMirror targetType) {
        if (this.typeUtils.isSameType(base, targetType)) {
            return 0;
        }
        if (!this.typeUtils.isAssignable(base, targetType)) {
            return -1;
        }
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(base);
        int minDistanceOfSuperToTargetType = Integer.MAX_VALUE;
        for (TypeMirror typeMirror : directSupertypes) {
            int distanceToTargetType = this.distanceTo(typeMirror, targetType);
            if (distanceToTargetType < 0) continue;
            minDistanceOfSuperToTargetType = Math.min(minDistanceOfSuperToTargetType, distanceToTargetType);
        }
        return 1 + minDistanceOfSuperToTargetType;
    }

    public boolean canAccess(Type type, ExecutableElement method) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return this.isAssignableTo(type) || this.getPackageName().equals(type.getPackageName());
        }
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return this.getPackageName().equals(type.getPackageName());
        }
        return true;
    }

    public String getNull() {
        if (!this.isPrimitive() || this.isArrayType()) {
            return "null";
        }
        if ("boolean".equals(this.getName())) {
            return "false";
        }
        if ("byte".equals(this.getName())) {
            return "0";
        }
        if ("char".equals(this.getName())) {
            return "0";
        }
        if ("double".equals(this.getName())) {
            return "0.0d";
        }
        if ("float".equals(this.getName())) {
            return "0.0f";
        }
        if ("int".equals(this.getName())) {
            return "0";
        }
        if ("long".equals(this.getName())) {
            return "0L";
        }
        if ("short".equals(this.getName())) {
            return "0";
        }
        throw new UnsupportedOperationException(this.getName());
    }

    public String getSensibleDefault() {
        if (this.isPrimitive()) {
            return this.getNull();
        }
        if ("String".equals(this.getName())) {
            return "\"\"";
        }
        if (this.isNative()) {
            return this.typeFactory.getType(this.typeUtils.unboxedType(this.typeMirror)).getNull();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        if (this.isWildCardBoundByTypeVar() && other.isWildCardBoundByTypeVar()) {
            return (this.hasExtendsBound() == this.hasExtendsBound() || this.hasSuperBound() == this.hasSuperBound()) && this.typeUtils.isSameType(this.getTypeBound().getTypeMirror(), other.getTypeBound().getTypeMirror());
        }
        return this.typeUtils.isSameType(this.typeMirror, other.typeMirror);
    }

    @Override
    public int compareTo(Type o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public String toString() {
        return this.typeMirror.toString();
    }

    public String describe() {
        if (this.loggingVerbose) {
            return this.toString();
        }
        String name = this.getFullyQualifiedName().replaceFirst("^" + this.getPackageName() + ".", "");
        List<Type> typeParams = this.getTypeParameters();
        if (typeParams.isEmpty()) {
            return name;
        }
        String params = typeParams.stream().map(Type::describe).collect(Collectors.joining(","));
        return String.format("%s<%s>", name, params);
    }

    public String getIdentification() {
        if (this.isArrayType()) {
            return this.componentType.getName() + "Array";
        }
        return this.getTypeBound().getName();
    }

    public Type getTypeBound() {
        if (this.boundingBase != null) {
            return this.boundingBase;
        }
        this.boundingBase = this.typeFactory.getType(this.typeFactory.getTypeBound(this.getTypeMirror()));
        return this.boundingBase;
    }

    public List<Type> getTypeBounds() {
        if (this.boundTypes != null) {
            return this.boundTypes;
        }
        Type bound = this.getTypeBound();
        if (bound == null) {
            this.boundTypes = java.util.Collections.emptyList();
        } else if (!bound.isIntersection()) {
            this.boundTypes = java.util.Collections.singletonList(bound);
        } else {
            List<? extends TypeMirror> bounds = ((IntersectionType)bound.typeMirror).getBounds();
            this.boundTypes = new ArrayList<Type>(bounds.size());
            for (TypeMirror typeMirror : bounds) {
                this.boundTypes.add(this.typeFactory.getType(typeMirror));
            }
        }
        return this.boundTypes;
    }

    public boolean hasAccessibleConstructor() {
        if (this.hasAccessibleConstructor == null) {
            this.hasAccessibleConstructor = false;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(this.typeElement.getEnclosedElements());
            for (ExecutableElement constructor : constructors) {
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                this.hasAccessibleConstructor = true;
                break;
            }
        }
        return this.hasAccessibleConstructor;
    }

    public List<Type> getDirectSuperTypes() {
        return this.typeUtils.directSupertypes(this.typeMirror).stream().map(this.typeFactory::getType).collect(Collectors.toList());
    }

    public List<Type> determineTypeArguments(Class<?> superclass) {
        if (this.qualifiedName.equals(superclass.getName())) {
            return this.getTypeParameters();
        }
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(this.typeMirror);
        for (TypeMirror typeMirror : directSupertypes) {
            Type supertype = this.typeFactory.getType(typeMirror);
            List<Type> supertypeTypeArguments = supertype.determineTypeArguments(superclass);
            if (supertypeTypeArguments == null) continue;
            return supertypeTypeArguments;
        }
        return null;
    }

    public boolean isNative() {
        return NativeTypes.isNative(this.qualifiedName);
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public ResolvedPair resolveParameterToType(Type declared, Type parameterized) {
        if (this.isTypeVar() || this.isArrayTypeVar() || this.isWildCardBoundByTypeVar()) {
            TypeVarMatcher typeVarMatcher = new TypeVarMatcher(this.typeFactory, this.typeUtils, this);
            return (ResolvedPair)typeVarMatcher.visit(parameterized.getTypeMirror(), declared);
        }
        return new ResolvedPair(this, this);
    }

    public boolean isWildCardBoundByTypeVar() {
        return (this.hasExtendsBound() || this.hasSuperBound()) && this.getTypeBound().isTypeVar();
    }

    public boolean isArrayTypeVar() {
        return this.isArrayType() && this.getComponentType().isTypeVar();
    }

    public Type getBoxedEquivalent() {
        if (this.boxedEquivalent != null) {
            return this.boxedEquivalent;
        }
        if (this.isPrimitive()) {
            this.boxedEquivalent = this.typeFactory.getType(this.typeUtils.boxedClass((PrimitiveType)this.typeMirror));
            return this.boxedEquivalent;
        }
        return this;
    }

    private String trimSimpleClassName(String className) {
        if (className == null) {
            return null;
        }
        String trimmedClassName = className;
        while (trimmedClassName.endsWith("[]")) {
            trimmedClassName = trimmedClassName.substring(0, trimmedClassName.length() - 2);
        }
        return trimmedClassName;
    }

    private static String nameWithTopLevelTypeName(TypeElement element, String name) {
        if (element == null) {
            return null;
        }
        if (!element.getNestingKind().isNested()) {
            return name;
        }
        ArrayDeque<CharSequence> elements = new ArrayDeque<CharSequence>();
        elements.addFirst(name);
        for (Element parent = element.getEnclosingElement(); parent != null && parent.getKind() != ElementKind.PACKAGE; parent = parent.getEnclosingElement()) {
            elements.addFirst(parent.getSimpleName());
        }
        return String.join((CharSequence)".", elements);
    }

    private static Type topLevelType(TypeElement typeElement, TypeFactory typeFactory) {
        Element parent;
        if (typeElement == null || typeElement.getNestingKind() == NestingKind.TOP_LEVEL) {
            return null;
        }
        for (parent = typeElement.getEnclosingElement(); parent != null && (parent.getEnclosingElement() == null || parent.getEnclosingElement().getKind() != ElementKind.PACKAGE); parent = parent.getEnclosingElement()) {
        }
        return parent == null ? null : typeFactory.getType(parent.asType());
    }

    public boolean isEnumSet() {
        return "java.util.EnumSet".equals(this.getFullyQualifiedName());
    }

    public static class ResolvedPair {
        private Type parameter;
        private Type match;

        public ResolvedPair(Type parameter, Type match) {
            this.parameter = parameter;
            this.match = match;
        }

        public Type getParameter() {
            return this.parameter;
        }

        public Type getMatch() {
            return this.match;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedPair that = (ResolvedPair)o;
            return Objects.equals(this.parameter, that.parameter) && Objects.equals(this.match, that.match);
        }

        public int hashCode() {
            return Objects.hash(this.parameter);
        }
    }

    private static class TypeVarMatcher
    extends SimpleTypeVisitor8<ResolvedPair, Type> {
        private final TypeFactory typeFactory;
        private final Type typeToMatch;
        private final TypeUtils types;

        TypeVarMatcher(TypeFactory typeFactory, TypeUtils types, Type typeToMatch) {
            super(new ResolvedPair(typeToMatch, null));
            this.typeFactory = typeFactory;
            this.typeToMatch = typeToMatch;
            this.types = types;
        }

        @Override
        public ResolvedPair visitTypeVariable(TypeVariable parameterized, Type declared) {
            if (this.typeToMatch.isTypeVar() && this.types.isSameType(parameterized, this.typeToMatch.getTypeMirror())) {
                return new ResolvedPair(this.typeFactory.getType(parameterized), declared);
            }
            return (ResolvedPair)this.DEFAULT_VALUE;
        }

        @Override
        public ResolvedPair visitWildcard(WildcardType parameterized, Type declared) {
            ResolvedPair match;
            if (this.typeToMatch.hasExtendsBound() && parameterized.getExtendsBound() != null && this.types.isSameType(this.typeToMatch.getTypeBound().getTypeMirror(), parameterized.getExtendsBound())) {
                return new ResolvedPair(this.typeToMatch, declared);
            }
            if (this.typeToMatch.hasSuperBound() && parameterized.getSuperBound() != null && this.types.isSameType(this.typeToMatch.getTypeBound().getTypeMirror(), parameterized.getSuperBound())) {
                return new ResolvedPair(this.typeToMatch, declared);
            }
            if (parameterized.getExtendsBound() != null ? (match = (ResolvedPair)this.visit(parameterized.getExtendsBound(), declared)).match != null : parameterized.getSuperBound() != null && (match = (ResolvedPair)this.visit(parameterized.getSuperBound(), declared)).match != null) {
                return new ResolvedPair(this.typeFactory.getType(parameterized), declared);
            }
            return (ResolvedPair)this.DEFAULT_VALUE;
        }

        @Override
        public ResolvedPair visitArray(ArrayType parameterized, Type declared) {
            if (this.types.isSameType(parameterized.getComponentType(), this.typeToMatch.getTypeMirror())) {
                return new ResolvedPair(this.typeFactory.getType(parameterized), declared);
            }
            if (declared.isArrayType()) {
                return (ResolvedPair)this.visit(parameterized.getComponentType(), declared.getComponentType());
            }
            return (ResolvedPair)this.DEFAULT_VALUE;
        }

        @Override
        public ResolvedPair visitDeclared(DeclaredType parameterized, Type declared) {
            ArrayList<ResolvedPair> results = new ArrayList<ResolvedPair>();
            if (parameterized.getTypeArguments().isEmpty()) {
                return (ResolvedPair)this.DEFAULT_VALUE;
            }
            if (this.types.isSameType(this.types.erasure(parameterized), this.types.erasure(declared.getTypeMirror()))) {
                if (parameterized.getTypeArguments().size() != declared.getTypeParameters().size()) {
                    return (ResolvedPair)super.visitDeclared(parameterized, declared);
                }
                for (int i = 0; i < parameterized.getTypeArguments().size(); ++i) {
                    Type declaredTypeArg;
                    TypeMirror typeMirror = parameterized.getTypeArguments().get(i);
                    ResolvedPair result = (ResolvedPair)this.visit(typeMirror, declaredTypeArg = declared.getTypeParameters().get(i));
                    if (result == this.DEFAULT_VALUE) continue;
                    results.add(result);
                }
            } else {
                ResolvedPair result;
                for (Type type : declared.getDirectSuperTypes()) {
                    if (Object.class.getName().equals(type.getFullyQualifiedName()) || (result = this.visitDeclared(parameterized, type)) == this.DEFAULT_VALUE) continue;
                    results.add(result);
                }
                for (TypeMirror typeMirror : this.types.directSupertypes(parameterized)) {
                    if (this.isJavaLangObject(typeMirror) || (result = this.visitDeclared((DeclaredType)typeMirror, declared)) == this.DEFAULT_VALUE) continue;
                    results.add(result);
                }
            }
            if (results.isEmpty()) {
                return (ResolvedPair)this.DEFAULT_VALUE;
            }
            return results.stream().allMatch(((ResolvedPair)results.get(0))::equals) ? (ResolvedPair)results.get(0) : (ResolvedPair)this.DEFAULT_VALUE;
        }

        private boolean isJavaLangObject(TypeMirror type) {
            if (type instanceof DeclaredType) {
                return ((TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals(Object.class.getName());
            }
            return false;
        }
    }
}

