/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.mapstruct.ap.internal.gem.ContextGem;
import org.mapstruct.ap.internal.gem.MappingTargetGem;
import org.mapstruct.ap.internal.gem.TargetTypeGem;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class Parameter
extends ModelElement {
    private final Element element;
    private final String name;
    private final String originalName;
    private final Type type;
    private final boolean mappingTarget;
    private final boolean targetType;
    private final boolean mappingContext;
    private final boolean varArgs;

    private Parameter(Element element, Type type, boolean varArgs) {
        this.element = element;
        this.originalName = this.name = element.getSimpleName().toString();
        this.type = type;
        this.mappingTarget = MappingTargetGem.instanceOn(element) != null;
        this.targetType = TargetTypeGem.instanceOn(element) != null;
        this.mappingContext = ContextGem.instanceOn(element) != null;
        this.varArgs = varArgs;
    }

    private Parameter(String name, Type type, boolean mappingTarget, boolean targetType, boolean mappingContext, boolean varArgs) {
        this.element = null;
        this.name = name;
        this.originalName = name;
        this.type = type;
        this.mappingTarget = mappingTarget;
        this.targetType = targetType;
        this.mappingContext = mappingContext;
        this.varArgs = varArgs;
    }

    public Parameter(String name, Type type) {
        this(name, type, false, false, false, false);
    }

    public Element getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isMappingTarget() {
        return this.mappingTarget;
    }

    public String toString() {
        return (this.mappingTarget ? "@MappingTarget " : "") + (this.targetType ? "@TargetType " : "") + (this.mappingContext ? "@Context " : "") + this.type.toString() + " " + this.name;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.asSet(this.type);
    }

    public boolean isTargetType() {
        return this.targetType;
    }

    public boolean isMappingContext() {
        return this.mappingContext;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (!Objects.equals(this.name, parameter.name)) {
            return false;
        }
        return Objects.equals(this.type, parameter.type);
    }

    public static Parameter forElementAndType(VariableElement element, Type parameterType, boolean isVarArgs) {
        return new Parameter(element, parameterType, isVarArgs);
    }

    public static Parameter forForgedMappingTarget(Type parameterType) {
        return new Parameter("mappingTarget", parameterType, true, false, false, false);
    }

    public static List<Parameter> getSourceParameters(List<Parameter> parameters) {
        return parameters.stream().filter(Parameter::isSourceParameter).collect(Collectors.toList());
    }

    public static Parameter getSourceParameter(List<Parameter> parameters, String sourceParameterName) {
        return parameters.stream().filter(Parameter::isSourceParameter).filter(parameter -> parameter.getName().equals(sourceParameterName)).findAny().orElse(null);
    }

    public static List<Parameter> getContextParameters(List<Parameter> parameters) {
        return parameters.stream().filter(Parameter::isMappingContext).collect(Collectors.toList());
    }

    public static Parameter getMappingTargetParameter(List<Parameter> parameters) {
        return parameters.stream().filter(Parameter::isMappingTarget).findAny().orElse(null);
    }

    public static Parameter getTargetTypeParameter(List<Parameter> parameters) {
        return parameters.stream().filter(Parameter::isTargetType).findAny().orElse(null);
    }

    private static boolean isSourceParameter(Parameter parameter) {
        return !parameter.isMappingTarget() && !parameter.isTargetType() && !parameter.isMappingContext();
    }
}

