/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValuePropertyMappingStrategyPrism;

public class SetterWrapper
extends AssignmentWrapper {
    private final List<Type> thrownTypesToExclude;
    private final boolean includeSourceNullCheck;
    private final boolean setExplicitlyToNull;
    private final boolean setExplicitlyToDefault;

    public SetterWrapper(Assignment rhs, List<Type> thrownTypesToExclude, boolean fieldAssignment, boolean includeSourceNullCheck, boolean setExplicitlyToNull, boolean setExplicitlyToDefault) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.includeSourceNullCheck = includeSourceNullCheck;
        this.setExplicitlyToDefault = setExplicitlyToDefault;
        this.setExplicitlyToNull = setExplicitlyToNull;
    }

    public SetterWrapper(Assignment rhs, List<Type> thrownTypesToExclude, boolean fieldAssignment) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.includeSourceNullCheck = false;
        this.setExplicitlyToNull = false;
        this.setExplicitlyToDefault = false;
    }

    @Override
    public List<Type> getThrownTypes() {
        List<Type> parentThrownTypes = super.getThrownTypes();
        ArrayList<Type> result = new ArrayList<Type>(parentThrownTypes);
        for (Type thrownTypeToExclude : this.thrownTypesToExclude) {
            for (Type parentThrownType : parentThrownTypes) {
                if (!parentThrownType.isAssignableTo(thrownTypeToExclude)) continue;
                result.remove(parentThrownType);
            }
        }
        return result;
    }

    public boolean isSetExplicitlyToNull() {
        return this.setExplicitlyToNull;
    }

    public boolean isSetExplicitlyToDefault() {
        return this.setExplicitlyToDefault;
    }

    public boolean isIncludeSourceNullCheck() {
        return this.includeSourceNullCheck;
    }

    public static boolean doSourceNullCheck(Assignment rhs, NullValueCheckStrategyPrism nvcs, NullValuePropertyMappingStrategyPrism nvpms, Type targetType) {
        return !rhs.isSourceReferenceParameter() && !rhs.getSourceType().isPrimitive() && (NullValueCheckStrategyPrism.ALWAYS == nvcs || NullValuePropertyMappingStrategyPrism.SET_TO_DEFAULT == nvpms || NullValuePropertyMappingStrategyPrism.IGNORE == nvpms || rhs.getType().isConverted() || rhs.getType().isDirect() && targetType.isPrimitive());
    }
}

