/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.prism.NullValuePropertyMappingStrategyPrism;

public class UpdateWrapper
extends AssignmentWrapper {
    private final List<Type> thrownTypesToExclude;
    private final Assignment factoryMethod;
    private final Type targetImplementationType;
    private final boolean includeSourceNullCheck;
    private final boolean includeExplicitNullWhenSourceIsNull;
    private final boolean mapNullToDefault;

    public UpdateWrapper(Assignment decoratedAssignment, List<Type> thrownTypesToExclude, Assignment factoryMethod, boolean fieldAssignment, Type targetType, boolean includeSourceNullCheck, NullValuePropertyMappingStrategyPrism nvpms) {
        super(decoratedAssignment, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.factoryMethod = factoryMethod;
        this.targetImplementationType = UpdateWrapper.determineImplType(factoryMethod, targetType);
        this.includeSourceNullCheck = includeSourceNullCheck;
        this.mapNullToDefault = nvpms == NullValuePropertyMappingStrategyPrism.SET_TO_DEFAULT;
        this.includeExplicitNullWhenSourceIsNull = nvpms == NullValuePropertyMappingStrategyPrism.SET_TO_NULL;
    }

    private static Type determineImplType(Assignment factoryMethod, Type targetType) {
        if (factoryMethod != null) {
            return null;
        }
        if (targetType.getImplementationType() != null) {
            return targetType.getImplementationType();
        }
        return targetType;
    }

    @Override
    public List<Type> getThrownTypes() {
        List<Type> parentThrownTypes = super.getThrownTypes();
        ArrayList<Type> result = new ArrayList<Type>(parentThrownTypes);
        for (Type thrownTypeToExclude : this.thrownTypesToExclude) {
            for (Type parentThrownType : parentThrownTypes) {
                if (!parentThrownType.isAssignableTo(thrownTypeToExclude)) continue;
                result.remove(parentThrownType);
            }
        }
        return result;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>();
        imported.addAll(super.getImportTypes());
        if (this.factoryMethod != null) {
            imported.addAll(this.factoryMethod.getImportTypes());
        }
        if (this.targetImplementationType != null) {
            imported.add(this.targetImplementationType);
            imported.addAll(this.targetImplementationType.getTypeParameters());
        }
        return imported;
    }

    public Assignment getFactoryMethod() {
        return this.factoryMethod;
    }

    public boolean isIncludeSourceNullCheck() {
        return this.includeSourceNullCheck;
    }

    public boolean isIncludeExplicitNullWhenSourceIsNull() {
        return this.includeExplicitNullWhenSourceIsNull;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }
}

