/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.prism.NullValueCheckStrategyPrism;

public class SetterWrapper
extends AssignmentWrapper {
    private final List<Type> thrownTypesToExclude;
    private final boolean includeSourceNullCheck;

    public SetterWrapper(Assignment rhs, List<Type> thrownTypesToExclude, NullValueCheckStrategyPrism nvms, boolean fieldAssignment, Type targetType) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.includeSourceNullCheck = this.includeSourceNullCheck(rhs, nvms, targetType);
    }

    public SetterWrapper(Assignment rhs, List<Type> thrownTypesToExclude, boolean fieldAssignment) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.includeSourceNullCheck = false;
    }

    @Override
    public List<Type> getThrownTypes() {
        List<Type> parentThrownTypes = super.getThrownTypes();
        ArrayList<Type> result = new ArrayList<Type>(parentThrownTypes);
        for (Type thrownTypeToExclude : this.thrownTypesToExclude) {
            for (Type parentThrownType : parentThrownTypes) {
                if (!parentThrownType.isAssignableTo(thrownTypeToExclude)) continue;
                result.remove(parentThrownType);
            }
        }
        return result;
    }

    public boolean isIncludeSourceNullCheck() {
        return this.includeSourceNullCheck;
    }

    private boolean includeSourceNullCheck(Assignment rhs, NullValueCheckStrategyPrism nvms, Type targetType) {
        return !rhs.isSourceReferenceParameter() && !rhs.getSourceType().isPrimitive() && (NullValueCheckStrategyPrism.ALWAYS == nvms || rhs.getType().isConverted() || rhs.getSourceLocalVarName() != null || rhs.getType().isDirect() && targetType.isPrimitive());
    }
}

