/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.processor.DefaultVersionInformation;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.RoundContext;
import org.mapstruct.ap.internal.util.workarounds.TypesDecorator;
import org.mapstruct.ap.internal.version.VersionInformation;

public class DefaultModelElementProcessorContext
implements ModelElementProcessor.ProcessorContext {
    private final ProcessingEnvironment processingEnvironment;
    private final DelegatingMessager messager;
    private final Options options;
    private final TypeFactory typeFactory;
    private final VersionInformation versionInformation;
    private final Types delegatingTypes;

    public DefaultModelElementProcessorContext(ProcessingEnvironment processingEnvironment, Options options, RoundContext roundContext) {
        this.processingEnvironment = processingEnvironment;
        this.messager = new DelegatingMessager(processingEnvironment.getMessager());
        this.versionInformation = DefaultVersionInformation.fromProcessingEnvironment(processingEnvironment);
        this.delegatingTypes = new TypesDecorator(processingEnvironment, this.versionInformation);
        this.typeFactory = new TypeFactory(processingEnvironment.getElementUtils(), this.delegatingTypes, roundContext);
        this.options = options;
    }

    @Override
    public Filer getFiler() {
        return this.processingEnvironment.getFiler();
    }

    @Override
    public Types getTypeUtils() {
        return this.delegatingTypes;
    }

    @Override
    public Elements getElementUtils() {
        return this.processingEnvironment.getElementUtils();
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public FormattingMessager getMessager() {
        return this.messager;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public VersionInformation getVersionInformation() {
        return this.versionInformation;
    }

    @Override
    public boolean isErroneous() {
        return this.messager.isErroneous();
    }

    private static final class DelegatingMessager
    implements FormattingMessager {
        private final Messager delegate;
        private boolean isErroneous = false;

        DelegatingMessager(Messager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void printMessage(Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, AnnotationMirror a, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e, a);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Element e, AnnotationMirror a, AnnotationValue v, Message msg, Object ... args) {
            String message = String.format(msg.getDescription(), args);
            this.delegate.printMessage(msg.getDiagnosticKind(), message, e, a, v);
            if (msg.getDiagnosticKind() == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        public boolean isErroneous() {
            return this.isErroneous;
        }
    }
}

