/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.Strings;

public abstract class ContainerMappingMethod
extends NormalTypeMappingMethod {
    private final Assignment elementAssignment;
    private final String loopVariableName;
    private final SelectionParameters selectionParameters;

    ContainerMappingMethod(Method method, Assignment parameterAssignment, MethodReference factoryMethod, boolean mapNullToDefault, String loopVariableName, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, SelectionParameters selectionParameters) {
        super(method, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.elementAssignment = parameterAssignment;
        this.loopVariableName = loopVariableName;
        this.selectionParameters = selectionParameters;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget() || parameter.isMappingContext()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public Assignment getElementAssignment() {
        return this.elementAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.elementAssignment != null) {
            types.addAll(this.elementAssignment.getImportTypes());
        }
        return types;
    }

    public String getLoopVariableName() {
        return this.loopVariableName;
    }

    public abstract Type getResultElementType();

    public String getIndex1Name() {
        return Strings.getSaveVariableName("i", this.loopVariableName, this.getSourceParameter().getName(), this.getResultName());
    }

    public String getIndex2Name() {
        return Strings.getSaveVariableName("j", this.loopVariableName, this.getSourceParameter().getName(), this.getResultName());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ContainerMappingMethod other = (ContainerMappingMethod)obj;
        return !(this.selectionParameters != null ? !this.selectionParameters.equals(other.selectionParameters) : other.selectionParameters != null);
    }
}

