/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.util.Set;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Strings;

public abstract class AbstractJavaTimeToStringConversion
extends SimpleConversion {
    @Override
    protected String getToExpression(ConversionContext conversionContext) {
        return this.dateTimeFormatter(conversionContext) + ".format( <SOURCE> )";
    }

    private String dateTimeFormatter(ConversionContext conversionContext) {
        if (!Strings.isEmpty(conversionContext.getDateFormat())) {
            return "DateTimeFormatter.ofPattern( \"" + conversionContext.getDateFormat() + "\" )";
        }
        return "DateTimeFormatter." + this.defaultFormatterSuffix();
    }

    protected abstract String defaultFormatterSuffix();

    @Override
    protected String getFromExpression(ConversionContext conversionContext) {
        return conversionContext.getTargetType().getFullyQualifiedName() + ".parse( " + this.parametersListForParsing(conversionContext) + " )";
    }

    private String parametersListForParsing(ConversionContext conversionContext) {
        StringBuilder parameterBuilder = new StringBuilder("<SOURCE>");
        if (!Strings.isEmpty(conversionContext.getDateFormat())) {
            parameterBuilder.append(", DateTimeFormatter.ofPattern( \"").append(conversionContext.getDateFormat()).append("\" )");
        }
        return parameterBuilder.toString();
    }

    @Override
    protected Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType("java.time.format.DateTimeFormatter"));
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType("java.time.format.DateTimeFormatter"));
    }
}

