/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.LifecycleCallbackFactory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LocalVariable;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedLocalVariableAssignment;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.dependency.GraphAnalyzer;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.model.source.TargetReference;
import org.mapstruct.ap.internal.option.ReportingPolicy;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class BeanMappingMethod
extends MappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final MethodReference factoryMethod;
    private final boolean mapNullToDefault;
    private final Type resultType;
    private final NestedTargetObjects nestedTargetObjects;

    private BeanMappingMethod(SourceMethod method, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault, Type resultType, Collection<String> existingVariableNames, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, NestedTargetObjects nestedTargetObjects) {
        super(method, existingVariableNames, beforeMappingReferences, afterMappingReferences);
        this.propertyMappings = propertyMappings;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings);
        for (Parameter sourceParameter : this.getSourceParameters()) {
            ArrayList<PropertyMapping> mappingsOfParameter = new ArrayList<PropertyMapping>();
            this.mappingsByParameter.put(sourceParameter.getName(), mappingsOfParameter);
            for (PropertyMapping mapping : propertyMappings) {
                if (!sourceParameter.getName().equals(mapping.getSourceBeanName())) continue;
                mappingsOfParameter.add(mapping);
                this.constantMappings.remove(mapping);
            }
        }
        this.factoryMethod = factoryMethod;
        this.mapNullToDefault = mapNullToDefault;
        this.resultType = resultType;
        this.nestedTargetObjects = nestedTargetObjects.init(this.getResultName());
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public Map<String, List<PropertyMapping>> getPropertyMappingsByParameter() {
        return this.mappingsByParameter;
    }

    public Set<LocalVariable> getLocalVariablesToCreate() {
        return this.nestedTargetObjects.localVariables;
    }

    public Set<NestedLocalVariableAssignment> getNestedLocalVariableAssignments() {
        return this.nestedTargetObjects.nestedAssignments;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    @Override
    public Type getResultType() {
        if (this.resultType == null) {
            return super.getResultType();
        }
        return this.resultType;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        types.addAll(this.nestedTargetObjects.getImportTypes());
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public List<Parameter> getSourcePrimitiveParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (!sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    private static class NestedTargetObjects {
        private final Set<LocalVariable> localVariables;
        private final Set<NestedLocalVariableAssignment> nestedAssignments;
        private final Map<String, String> localVariableNames;

        private Set<Type> getImportTypes() {
            HashSet<Type> importedTypes = new HashSet<Type>();
            for (LocalVariable localVariableToCreate : this.localVariables) {
                importedTypes.add(localVariableToCreate.getType());
            }
            return importedTypes;
        }

        private NestedTargetObjects(Set<LocalVariable> localVariables, Map<String, String> localVariableNames, Set<NestedLocalVariableAssignment> relations) {
            this.localVariables = localVariables;
            this.localVariableNames = localVariableNames;
            this.nestedAssignments = relations;
        }

        private String getLocalVariableName(TargetReference targetRef) {
            String result = null;
            List<PropertyEntry> propertyEntries = targetRef.getPropertyEntries();
            if (propertyEntries.size() > 1) {
                result = this.localVariableNames.get(propertyEntries.get(propertyEntries.size() - 2).getFullName());
            }
            return result;
        }

        private NestedTargetObjects init(String targetBeanName) {
            for (NestedLocalVariableAssignment nestedAssignment : this.nestedAssignments) {
                if (nestedAssignment.getTargetBean() != null) continue;
                nestedAssignment.setTargetBean(targetBeanName);
            }
            return this;
        }

        private static class Builder {
            private Map<String, List<Mapping>> mappings;
            private Set<String> existingVariableNames;
            private MappingBuilderContext ctx;
            private SourceMethod method;

            private Builder() {
            }

            private Builder mappings(Map<String, List<Mapping>> mappings) {
                this.mappings = mappings;
                return this;
            }

            private Builder existingVariableNames(Set<String> existingVariableNames) {
                this.existingVariableNames = existingVariableNames;
                return this;
            }

            private Builder mappingBuilderContext(MappingBuilderContext ctx) {
                this.ctx = ctx;
                return this;
            }

            private Builder sourceMethod(SourceMethod method) {
                this.method = method;
                return this;
            }

            private NestedTargetObjects build() {
                HashMap<String, PropertyEntry> uniquePropertyEntries = new HashMap<String, PropertyEntry>();
                HashMap<String, String> localVariableNames = new HashMap<String, String>();
                HashSet<LocalVariable> localVariables = new HashSet<LocalVariable>();
                for (Map.Entry<String, List<Mapping>> mapping : this.mappings.entrySet()) {
                    TargetReference targetRef = ((Mapping)Collections.first((Collection)mapping.getValue())).getTargetReference();
                    List<PropertyEntry> propertyEntries = targetRef.getPropertyEntries();
                    for (int i = 0; i < propertyEntries.size() - 1; ++i) {
                        PropertyEntry entry = propertyEntries.get(i);
                        uniquePropertyEntries.put(entry.getFullName(), entry);
                    }
                }
                for (PropertyEntry propertyEntry : uniquePropertyEntries.values()) {
                    String name = Strings.getSaveVariableName(propertyEntry.getName(), this.existingVariableNames);
                    this.existingVariableNames.add(name);
                    Type type = propertyEntry.getType();
                    MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, type, null);
                    localVariables.add(new LocalVariable(name, type, factoryMethod));
                    localVariableNames.put(propertyEntry.getFullName(), name);
                }
                HashSet<NestedLocalVariableAssignment> relations = new HashSet<NestedLocalVariableAssignment>();
                for (Map.Entry<String, List<Mapping>> mapping : this.mappings.entrySet()) {
                    TargetReference targetRef = ((Mapping)Collections.first((Collection)mapping.getValue())).getTargetReference();
                    List<PropertyEntry> propertyEntries = targetRef.getPropertyEntries();
                    for (int i = 0; i < propertyEntries.size() - 1; ++i) {
                        String targetBean = null;
                        if (i > 0) {
                            PropertyEntry targetPropertyEntry = propertyEntries.get(i - 1);
                            targetBean = (String)localVariableNames.get(targetPropertyEntry.getFullName());
                        }
                        PropertyEntry sourcePropertyEntry = propertyEntries.get(i);
                        String targetAccessor = sourcePropertyEntry.getWriteAccessor().getSimpleName().toString();
                        String sourceRef = (String)localVariableNames.get(sourcePropertyEntry.getFullName());
                        relations.add(new NestedLocalVariableAssignment(targetBean, targetAccessor, sourceRef));
                    }
                }
                return new NestedTargetObjects(localVariables, localVariableNames, relations);
            }
        }
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private Map<String, ExecutableElement> unprocessedTargetProperties;
        private Set<String> targetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();
        private NullValueMappingStrategyPrism nullValueMappingStrategy;
        private SelectionParameters selectionParameters;
        private final Set<String> existingVariableNames = new HashSet<String>();
        private NestedTargetObjects nestedTargetObjects;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            CollectionMappingStrategyPrism cms = sourceMethod.getMapperConfiguration().getCollectionMappingStrategy();
            Map<String, ExecutableElement> accessors = this.method.getResultType().getPropertyWriteAccessors(cms);
            this.targetProperties = accessors.keySet();
            this.nestedTargetObjects = new NestedTargetObjects.Builder().existingVariableNames(this.existingVariableNames).mappings(this.method.getMappingOptions().getMappings()).mappingBuilderContext(this.ctx).sourceMethod(this.method).build();
            this.unprocessedTargetProperties = new LinkedHashMap<String, ExecutableElement>(accessors);
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
            }
            this.existingVariableNames.addAll(this.method.getParameterNames());
            return this;
        }

        public Builder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public Builder nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        public BeanMappingMethod build() {
            boolean mappingErrorOccured = this.handleDefinedSourceMappings();
            if (mappingErrorOccured) {
                return null;
            }
            this.applyPropertyNameBasedMapping();
            this.applyParameterNameBasedMapping();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            boolean mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
            BeanMappingPrism beanMappingPrism = BeanMappingPrism.getInstanceOn(this.method.getExecutable());
            MethodReference factoryMethod = null;
            if (!this.method.isUpdateMethod()) {
                factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, this.method.getResultType(), this.selectionParameters);
            }
            Type resultType = null;
            if (factoryMethod == null && this.selectionParameters != null && this.selectionParameters.getResultType() != null && !(resultType = this.ctx.getTypeFactory().getType(this.selectionParameters.getResultType())).isAssignableTo(this.method.getResultType())) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), beanMappingPrism.mirror, Message.BEANMAPPING_NOT_ASSIGNABLE, resultType, this.method.getResultType());
            }
            this.sortPropertyMappingsByDependencies();
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleCallbackFactory.beforeMappingMethods(this.method, this.selectionParameters, this.ctx);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleCallbackFactory.afterMappingMethods(this.method, this.selectionParameters, this.ctx);
            return new BeanMappingMethod(this.method, this.propertyMappings, factoryMethod, mapNullToDefault, resultType, this.existingVariableNames, beforeMappingMethods, afterMappingMethods, this.nestedTargetObjects);
        }

        private void sortPropertyMappingsByDependencies() {
            GraphAnalyzer.GraphAnalyzerBuilder graphAnalyzerBuilder = GraphAnalyzer.builder();
            for (PropertyMapping propertyMapping : this.propertyMappings) {
                graphAnalyzerBuilder.withNode(propertyMapping.getName(), propertyMapping.getDependsOn());
            }
            final GraphAnalyzer graphAnalyzer = graphAnalyzerBuilder.build();
            if (!graphAnalyzer.getCycles().isEmpty()) {
                HashSet<String> cycles = new HashSet<String>();
                for (List<String> cycle : graphAnalyzer.getCycles()) {
                    cycles.add(Strings.join(cycle, " -> "));
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_CYCLE_BETWEEN_PROPERTIES, Strings.join(cycles, ", "));
            } else {
                java.util.Collections.sort(this.propertyMappings, new Comparator<PropertyMapping>(){

                    @Override
                    public int compare(PropertyMapping o1, PropertyMapping o2) {
                        if (graphAnalyzer.getAllDescendants(o1.getName()).contains(o2.getName())) {
                            return 1;
                        }
                        if (graphAnalyzer.getAllDescendants(o2.getName()).contains(o1.getName())) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean handleDefinedSourceMappings() {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            Iterator<Map.Entry<String, List<Mapping>>> iterator = this.method.getMappingOptions().getMappings().entrySet().iterator();
            block0: while (true) {
                if (!iterator.hasNext()) {
                    iterator = handledTargets.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return errorOccurred;
                        }
                        String handledTarget = (String)((Object)iterator.next());
                        this.unprocessedTargetProperties.remove(handledTarget);
                    }
                }
                Map.Entry<String, List<Mapping>> entry = iterator.next();
                Iterator<Mapping> iterator2 = entry.getValue().iterator();
                while (true) {
                    PropertyMapping propertyMapping;
                    block16: {
                        if (!iterator2.hasNext()) continue block0;
                        Mapping mapping = iterator2.next();
                        propertyMapping = null;
                        TargetReference targetRef = mapping.getTargetReference();
                        String resultPropertyName = null;
                        if (targetRef.isValid()) {
                            resultPropertyName = Collections.first(targetRef.getPropertyEntries()).getName();
                        }
                        if (!this.unprocessedTargetProperties.containsKey(resultPropertyName)) {
                            boolean hasReadAccessor = this.method.getResultType().getPropertyReadAccessors().containsKey(mapping.getTargetName());
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getSourceAnnotationValue(), hasReadAccessor ? Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_RESULTTYPE : Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_RESULTTYPE, mapping.getTargetName());
                            errorOccurred = true;
                            continue;
                        }
                        PropertyEntry targetProperty = Collections.last(targetRef.getPropertyEntries());
                        for (String dependency : mapping.getDependsOn()) {
                            if (this.targetProperties.contains(dependency)) continue;
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getDependsOnAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_DEPENDS_ON, dependency);
                            errorOccurred = true;
                        }
                        if (mapping.isIgnored()) {
                            propertyMapping = null;
                            handledTargets.add(mapping.getTargetName());
                        } else {
                            if (mapping.getSourceName() != null) {
                                SourceReference sourceRef = mapping.getSourceReference();
                                if (sourceRef.isValid()) {
                                    propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).sourceReference(sourceRef).selectionParameters(mapping.getSelectionParameters()).formattingParameters(mapping.getFormattingParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).defaultValue(mapping.getDefaultValue()).localTargetVarName(this.nestedTargetObjects.getLocalVariableName(targetRef))).build();
                                    handledTargets.add(resultPropertyName);
                                    this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                                    break block16;
                                } else {
                                    errorOccurred = true;
                                    continue;
                                }
                            }
                            if (mapping.getConstant() != null) {
                                propertyMapping = ((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).constantExpression("\"" + mapping.getConstant() + "\"").targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).formattingParameters(mapping.getFormattingParameters()).selectionParameters(mapping.getSelectionParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).localTargetVarName(this.nestedTargetObjects.getLocalVariableName(targetRef))).build();
                                handledTargets.add(mapping.getTargetName());
                            } else if (mapping.getJavaExpression() != null) {
                                propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(mapping.getJavaExpression()).existingVariableNames(this.existingVariableNames)).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).dependsOn(mapping.getDependsOn())).localTargetVarName(this.nestedTargetObjects.getLocalVariableName(targetRef))).build();
                                handledTargets.add(mapping.getTargetName());
                            }
                        }
                    }
                    if (propertyMapping == null) continue;
                    this.propertyMappings.add(propertyMapping);
                }
                break;
            }
        }

        private void applyPropertyNameBasedMapping() {
            Iterator<Map.Entry<String, ExecutableElement>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, ExecutableElement> targetProperty = targetPropertyEntriesIterator.next();
                String targetPropertyName = targetProperty.getKey();
                PropertyMapping propertyMapping = null;
                if (propertyMapping == null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        Type sourceType = sourceParameter.getType();
                        if (sourceType.isPrimitive()) continue;
                        PropertyMapping newPropertyMapping = null;
                        ExecutableElement sourceReadAccessor = sourceParameter.getType().getPropertyReadAccessors().get(targetPropertyName);
                        ExecutableElement sourcePresenceChecker = sourceParameter.getType().getPropertyPresenceCheckers().get(targetPropertyName);
                        if (sourceReadAccessor != null) {
                            Mapping mapping = this.method.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                            DeclaredType declaredSourceType = (DeclaredType)sourceParameter.getType().getTypeMirror();
                            SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(this.ctx.getTypeFactory().getReturnType(declaredSourceType, sourceReadAccessor)).readAccessor(sourceReadAccessor).presenceChecker(sourcePresenceChecker).name(targetProperty.getKey()).build();
                            newPropertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetPropertyName))).targetPropertyName(targetPropertyName)).sourceReference(sourceRef).formattingParameters(mapping != null ? mapping.getFormattingParameters() : null).selectionParameters(mapping != null ? mapping.getSelectionParameters() : null).defaultValue(mapping != null ? mapping.getDefaultValue() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : java.util.Collections.emptyList())).build();
                            this.unprocessedSourceParameters.remove(sourceParameter);
                        }
                        if (propertyMapping != null && newPropertyMapping != null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetPropertyName);
                            break;
                        }
                        if (newPropertyMapping == null) continue;
                        propertyMapping = newPropertyMapping;
                    }
                }
                if (propertyMapping == null) continue;
                this.propertyMappings.add(propertyMapping);
                targetPropertyEntriesIterator.remove();
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, ExecutableElement>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, ExecutableElement> targetProperty = targetPropertyEntriesIterator.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    Mapping mapping = this.method.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetProperty.getKey()))).targetPropertyName(targetProperty.getKey())).sourceReference(sourceRef).formattingParameters(mapping != null ? mapping.getFormattingParameters() : null).selectionParameters(mapping != null ? mapping.getSelectionParameters() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : java.util.Collections.emptyList())).build();
                    this.propertyMappings.add(propertyMapping);
                    targetPropertyEntriesIterator.remove();
                    sourceParameters.remove();
                }
            }
        }

        private ExecutableElement getTargetPropertyReadAccessor(String propertyName) {
            return this.method.getResultType().getPropertyReadAccessors().get(propertyName);
        }

        private ReportingPolicy getEffectiveUnmappedTargetPolicy() {
            MapperConfiguration mapperSettings = MapperConfiguration.getInstanceOn(this.ctx.getMapperTypeElement());
            boolean setViaAnnotation = mapperSettings.isSetUnmappedTargetPolicy();
            ReportingPolicy annotationValue = ReportingPolicy.valueOf(mapperSettings.unmappedTargetPolicy());
            if (setViaAnnotation || this.ctx.getOptions().getUnmappedTargetPolicy() == null) {
                return annotationValue;
            }
            return this.ctx.getOptions().getUnmappedTargetPolicy();
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicy unmappedTargetPolicy = this.getEffectiveUnmappedTargetPolicy();
            if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_TARGETS_WARNING;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", ")));
            }
        }
    }
}

