/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMapping;
import org.mapstruct.ap.internal.model.source.IterableMapping;
import org.mapstruct.ap.internal.model.source.MapMapping;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.MethodMatcher;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.model.source.ValueMapping;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Strings;

public class SourceMethod
implements Method {
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final List<Parameter> parameters;
    private final Parameter mappingTargetParameter;
    private final Parameter targetTypeParameter;
    private final Type returnType;
    private final Accessibility accessibility;
    private final List<Type> exceptionTypes;
    private final MapperConfiguration config;
    private final MappingOptions mappingOptions;
    private final List<SourceMethod> prototypeMethods;
    private final Type mapperToImplement;
    private List<Parameter> sourceParameters;
    private List<String> parameterNames;
    private List<SourceMethod> applicablePrototypeMethods;

    private SourceMethod(Type declaringMapper, ExecutableElement executable, List<Parameter> parameters, Type returnType, List<Type> exceptionTypes, MappingOptions mappingOptions, Types typeUtils, TypeFactory typeFactory, MapperConfiguration config, List<SourceMethod> prototypeMethods, Type mapperToImplement) {
        this.declaringMapper = declaringMapper;
        this.executable = executable;
        this.parameters = parameters;
        this.returnType = returnType;
        this.exceptionTypes = exceptionTypes;
        this.accessibility = Accessibility.fromModifiers(executable.getModifiers());
        this.mappingOptions = mappingOptions;
        this.mappingTargetParameter = this.determineMappingTargetParameter(parameters);
        this.targetTypeParameter = this.determineTargetTypeParameter(parameters);
        this.typeUtils = typeUtils;
        this.typeFactory = typeFactory;
        this.config = config;
        this.prototypeMethods = prototypeMethods;
        this.mapperToImplement = mapperToImplement;
    }

    private Parameter determineMappingTargetParameter(Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingTarget()) continue;
            return parameter;
        }
        return null;
    }

    private Parameter determineTargetTypeParameter(Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isTargetType()) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.executable;
    }

    @Override
    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        if (this.sourceParameters == null) {
            this.sourceParameters = new ArrayList<Parameter>();
            for (Parameter parameter : this.parameters) {
                if (parameter.isMappingTarget() || parameter.isTargetType()) continue;
                this.sourceParameters.add(parameter);
            }
        }
        return this.sourceParameters;
    }

    @Override
    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList<String>(this.parameters.size());
            for (Parameter parameter : this.parameters) {
                this.parameterNames.add(parameter.getName());
            }
        }
        return this.parameterNames;
    }

    @Override
    public Type getResultType() {
        return this.mappingTargetParameter != null ? this.mappingTargetParameter.getType() : this.returnType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
        List<Mapping> all = this.mappingOptions.getMappings().get(targetPropertyName);
        return all != null ? Collections.first(all) : null;
    }

    public boolean reverses(SourceMethod method) {
        return this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(Collections.first(this.getSourceParameters()).getType(), method.getResultType()) && this.equals(this.getResultType(), Collections.first(method.getSourceParameters()).getType());
    }

    public boolean isSame(SourceMethod method) {
        return this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(Collections.first(this.getSourceParameters()).getType(), Collections.first(method.getSourceParameters()).getType()) && this.equals(this.getResultType(), method.getResultType());
    }

    public boolean canInheritFrom(SourceMethod method) {
        return this.isMapMapping() == method.isMapMapping() && this.isIterableMapping() == method.isIterableMapping() && this.isEnumMapping() == method.isEnumMapping() && this.getResultType().isAssignableTo(method.getResultType()) && SourceMethod.allParametersAreAssignable(this.getSourceParameters(), method.getSourceParameters());
    }

    @Override
    public Parameter getMappingTargetParameter() {
        return this.mappingTargetParameter;
    }

    @Override
    public Parameter getTargetTypeParameter() {
        return this.targetTypeParameter;
    }

    public boolean isIterableMapping() {
        return this.getSourceParameters().size() == 1 && Collections.first(this.getSourceParameters()).getType().isIterableType() && this.getResultType().isIterableType();
    }

    public boolean isMapMapping() {
        return this.getSourceParameters().size() == 1 && Collections.first(this.getSourceParameters()).getType().isMapType() && this.getResultType().isMapType();
    }

    public boolean isEnumMapping() {
        return this.getSourceParameters().size() == 1 && Collections.first(this.getSourceParameters()).getType().isEnumType() && this.getResultType().isEnumType();
    }

    public boolean isValueMapping() {
        return this.isEnumMapping() && this.mappingOptions.getMappings().isEmpty();
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        if (this.declaringMapper != null) {
            sb.append(this.declaringMapper).append(".");
        }
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    public List<Mapping> getMappingBySourcePropertyName(String sourcePropertyName) {
        ArrayList<Mapping> mappingsOfSourceProperty = new ArrayList<Mapping>();
        for (List<Mapping> mappingOfProperty : this.mappingOptions.getMappings().values()) {
            for (Mapping mapping : mappingOfProperty) {
                if (this.isEnumMapping()) {
                    if (!mapping.getSourceName().equals(sourcePropertyName)) continue;
                    mappingsOfSourceProperty.add(mapping);
                    continue;
                }
                List<SourceReference.PropertyEntry> sourceEntries = mapping.getSourceReference().getPropertyEntries();
                if (sourceEntries.size() != 1 || !sourcePropertyName.equals(Collections.first(sourceEntries).getName())) continue;
                mappingsOfSourceProperty.add(mapping);
            }
        }
        return mappingsOfSourceProperty;
    }

    public Parameter getSourceParameter(String sourceParameterName) {
        for (Parameter parameter : this.getSourceParameters()) {
            if (!parameter.getName().equals(sourceParameterName)) continue;
            return parameter;
        }
        return null;
    }

    public List<SourceMethod> getApplicablePrototypeMethods() {
        if (this.applicablePrototypeMethods == null) {
            this.applicablePrototypeMethods = new ArrayList<SourceMethod>();
            for (SourceMethod prototype : this.prototypeMethods) {
                if (!this.canInheritFrom(prototype)) continue;
                this.applicablePrototypeMethods.add(prototype);
            }
        }
        return this.applicablePrototypeMethods;
    }

    private static boolean allParametersAreAssignable(List<Parameter> fromParams, List<Parameter> toParams) {
        if (fromParams.size() == toParams.size()) {
            HashSet<Parameter> unaccountedToParams = new HashSet<Parameter>(toParams);
            for (Parameter fromParam : fromParams) {
                boolean hasMatch = false;
                for (Parameter toParam : toParams) {
                    if (!fromParam.getType().isAssignableTo(toParam.getType())) continue;
                    unaccountedToParams.remove(toParam);
                    hasMatch = true;
                }
                if (hasMatch) continue;
                return false;
            }
            return unaccountedToParams.isEmpty();
        }
        return false;
    }

    @Override
    public boolean overridesMethod() {
        return this.declaringMapper == null && this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        MethodMatcher matcher = new MethodMatcher(this.typeUtils, this.typeFactory, this);
        return matcher.matches(sourceTypes, targetType);
    }

    public static boolean containsTargetTypeParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isTargetType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.exceptionTypes;
    }

    public MappingOptions getMappingOptions() {
        return this.mappingOptions;
    }

    @Override
    public boolean isStatic() {
        return this.executable.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isDefault() {
        return Executables.isDefaultMethod(this.executable);
    }

    @Override
    public Type getDefiningType() {
        return this.mapperToImplement;
    }

    @Override
    public MapperConfiguration getMapperConfiguration() {
        return this.config;
    }

    @Override
    public boolean isLifecycleCallbackMethod() {
        return Executables.isLifecycleCallbackMethod(this.getExecutable());
    }

    public boolean isAfterMappingMethod() {
        return Executables.isAfterMappingMethod(this.getExecutable());
    }

    public boolean isBeforeMappingMethod() {
        return Executables.isBeforeMappingMethod(this.getExecutable());
    }

    @Override
    public boolean isUpdateMethod() {
        return this.getMappingTargetParameter() != null;
    }

    public static class Builder {
        private Type declaringMapper = null;
        private Type definingType = null;
        private ExecutableElement executable;
        private List<Parameter> parameters;
        private Type returnType = null;
        private List<Type> exceptionTypes;
        private Map<String, List<Mapping>> mappings;
        private IterableMapping iterableMapping = null;
        private MapMapping mapMapping = null;
        private BeanMapping beanMapping = null;
        private Types typeUtils;
        private TypeFactory typeFactory = null;
        private FormattingMessager messager = null;
        private MapperConfiguration mapperConfig = null;
        private List<SourceMethod> prototypeMethods = java.util.Collections.emptyList();
        private List<ValueMapping> valueMappings;

        public Builder setDeclaringMapper(Type declaringMapper) {
            this.declaringMapper = declaringMapper;
            return this;
        }

        public Builder setExecutable(ExecutableElement executable) {
            this.executable = executable;
            return this;
        }

        public Builder setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setReturnType(Type returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder setExceptionTypes(List<Type> exceptionTypes) {
            this.exceptionTypes = exceptionTypes;
            return this;
        }

        public Builder setMappings(Map<String, List<Mapping>> mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setIterableMapping(IterableMapping iterableMapping) {
            this.iterableMapping = iterableMapping;
            return this;
        }

        public Builder setMapMapping(MapMapping mapMapping) {
            this.mapMapping = mapMapping;
            return this;
        }

        public Builder setBeanMapping(BeanMapping beanMapping) {
            this.beanMapping = beanMapping;
            return this;
        }

        public Builder setValueMappings(List<ValueMapping> valueMappings) {
            this.valueMappings = valueMappings;
            return this;
        }

        public Builder setTypeUtils(Types typeUtils) {
            this.typeUtils = typeUtils;
            return this;
        }

        public Builder setTypeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder setMessager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public Builder setMapperConfiguration(MapperConfiguration mapperConfig) {
            this.mapperConfig = mapperConfig;
            return this;
        }

        public Builder setPrototypeMethods(List<SourceMethod> prototypeMethods) {
            this.prototypeMethods = prototypeMethods;
            return this;
        }

        public Builder setDefininingType(Type definingType) {
            this.definingType = definingType;
            return this;
        }

        public SourceMethod build() {
            MappingOptions mappingOptions = new MappingOptions(this.mappings, this.iterableMapping, this.mapMapping, this.beanMapping, this.valueMappings);
            SourceMethod sourceMethod = new SourceMethod(this.declaringMapper, this.executable, this.parameters, this.returnType, this.exceptionTypes, mappingOptions, this.typeUtils, this.typeFactory, this.mapperConfig, this.prototypeMethods, this.definingType);
            if (this.mappings != null) {
                for (Map.Entry<String, List<Mapping>> entry : this.mappings.entrySet()) {
                    for (Mapping mapping : entry.getValue()) {
                        mapping.init(sourceMethod, this.messager, this.typeFactory);
                    }
                }
            }
            return sourceMethod;
        }
    }
}

