/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.MapMappingPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class MapMapping {
    private final String keyFormat;
    private final SelectionParameters keySelectionParameters;
    private final String valueFormat;
    private final SelectionParameters valueSelectionParameters;
    private final AnnotationMirror mirror;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;

    public static MapMapping fromPrism(MapMappingPrism mapMapping, ExecutableElement method, FormattingMessager messager) {
        boolean valueTargetTypeIsDefined;
        if (mapMapping == null) {
            return null;
        }
        NullValueMappingStrategyPrism nullValueMappingStrategy = mapMapping.values.nullValueMappingStrategy() == null ? null : NullValueMappingStrategyPrism.valueOf(mapMapping.nullValueMappingStrategy());
        boolean keyTargetTypeIsDefined = !TypeKind.VOID.equals((Object)mapMapping.keyTargetType().getKind());
        boolean bl = valueTargetTypeIsDefined = !TypeKind.VOID.equals((Object)mapMapping.valueTargetType().getKind());
        if (mapMapping.keyDateFormat().isEmpty() && mapMapping.keyQualifiedBy().isEmpty() && mapMapping.keyQualifiedByName().isEmpty() && mapMapping.valueDateFormat().isEmpty() && mapMapping.valueQualifiedBy().isEmpty() && mapMapping.valueQualifiedByName().isEmpty() && !keyTargetTypeIsDefined && !valueTargetTypeIsDefined && nullValueMappingStrategy == null) {
            messager.printMessage((Element)method, Message.MAPMAPPING_NO_ELEMENTS, new Object[0]);
        }
        SelectionParameters keySelection = new SelectionParameters(mapMapping.keyQualifiedBy(), mapMapping.keyQualifiedByName(), keyTargetTypeIsDefined ? mapMapping.keyTargetType() : null);
        SelectionParameters valueSelection = new SelectionParameters(mapMapping.valueQualifiedBy(), mapMapping.valueQualifiedByName(), valueTargetTypeIsDefined ? mapMapping.valueTargetType() : null);
        return new MapMapping(mapMapping.keyDateFormat(), keySelection, mapMapping.valueDateFormat(), valueSelection, mapMapping.mirror, nullValueMappingStrategy);
    }

    private MapMapping(String keyFormat, SelectionParameters keySelectionParameters, String valueFormat, SelectionParameters valueSelectionParameters, AnnotationMirror mirror, NullValueMappingStrategyPrism nvms) {
        this.keyFormat = keyFormat;
        this.keySelectionParameters = keySelectionParameters;
        this.valueFormat = valueFormat;
        this.valueSelectionParameters = valueSelectionParameters;
        this.mirror = mirror;
        this.nullValueMappingStrategy = nvms;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public SelectionParameters getKeySelectionParameters() {
        return this.keySelectionParameters;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public SelectionParameters getValueSelectionParameters() {
        return this.valueSelectionParameters;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }
}

