package org.mapstruct.ap.internal.prism;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import net.java.dev.hickory.prism.internal.*;
import java.util.HashMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
/** A Prism representing an {@code @javax.xml.bind.annotation.XmlElementRef} annotation. 
  */ 
public class XmlElementRefPrism {
    /** store prism value of type */
    private TypeMirror _type;

    /** store prism value of namespace */
    private String _namespace;

    /** store prism value of name */
    private String _name;

    /** store prism value of required */
    private Boolean _required;

    /**
      * An instance of the Values inner class whose
      * methods return the AnnotationValues used to build this prism. 
      * Primarily intended to support using Messager.
      */
    public final Values values;
    /** Return a prism representing the {@code @javax.xml.bind.annotation.XmlElementRef} annotation on 'e'. 
      * similar to {@code e.getAnnotation(javax.xml.bind.annotation.XmlElementRef.class)} except that 
      * an instance of this class rather than an instance of {@code javax.xml.bind.annotation.XmlElementRef}
      * is returned.
      */
    public static XmlElementRefPrism getInstanceOn(Element e) {
        AnnotationMirror m = getMirror("javax.xml.bind.annotation.XmlElementRef",e);
        if(m == null) return null;
        return getInstance(m);
   }

    /** Return a prism of the {@code @javax.xml.bind.annotation.XmlElementRef} annotation whose mirror is mirror. 
      */
    public static XmlElementRefPrism getInstance(AnnotationMirror mirror) {
        return new XmlElementRefPrism(mirror);
    }

    private XmlElementRefPrism(AnnotationMirror mirror) {
        for(ExecutableElement key : mirror.getElementValues().keySet()) {
            memberValues.put(key.getSimpleName().toString(),mirror.getElementValues().get(key));
        }
        for(ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            defaults.put(member.getSimpleName().toString(),member.getDefaultValue());
        }
        _type = getValue("type",TypeMirror.class);
        _namespace = getValue("namespace",String.class);
        _name = getValue("name",String.class);
        _required = getValue("required",Boolean.class);
        this.values = new Values(memberValues);
        this.mirror = mirror;
        this.isValid = valid;
    }

    /** 
      * Returns a TypeMirror representing the value of the {@code java.lang.Class type()} member of the Annotation.
      * @see javax.xml.bind.annotation.XmlElementRef#type()
      */ 
    public TypeMirror type() { return _type; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String namespace()} member of the Annotation.
      * @see javax.xml.bind.annotation.XmlElementRef#namespace()
      */ 
    public String namespace() { return _namespace; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String name()} member of the Annotation.
      * @see javax.xml.bind.annotation.XmlElementRef#name()
      */ 
    public String name() { return _name; }

    /** 
      * Returns a Boolean representing the value of the {@code boolean required()} member of the Annotation.
      * @see javax.xml.bind.annotation.XmlElementRef#required()
      */ 
    public Boolean required() { return _required; }

    /**
      * Determine whether the underlying AnnotationMirror has no errors.
      * True if the underlying AnnotationMirror has no errors.
      * When true is returned, none of the methods will return null.
      * When false is returned, a least one member will either return null, or another
      * prism that is not valid.
      */
    public final boolean isValid;
    
    /**
      * The underlying AnnotationMirror of the annotation
      * represented by this Prism. 
      * Primarily intended to support using Messager.
      */
    public final AnnotationMirror mirror;
    /**
      * A class whose members corespond to those of javax.xml.bind.annotation.XmlElementRef
      * but which each return the AnnotationValue corresponding to
      * that member in the model of the annotations. Returns null for
      * defaulted members. Used for Messager, so default values are not useful.
      */
    public static class Values {
       private Map<String,AnnotationValue> values;
       private Values(Map<String,AnnotationValue> values) {
           this.values = values;
       }    
       /** Return the AnnotationValue corresponding to the type() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue type(){ return values.get("type");}
       /** Return the AnnotationValue corresponding to the namespace() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue namespace(){ return values.get("namespace");}
       /** Return the AnnotationValue corresponding to the name() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue name(){ return values.get("name");}
       /** Return the AnnotationValue corresponding to the required() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue required(){ return values.get("required");}
    }
    private Map<String,AnnotationValue> defaults = new HashMap<String,AnnotationValue>(10);
    private Map<String,AnnotationValue> memberValues = new HashMap<String,AnnotationValue>(10);
    private boolean valid = true;

    private <T> T getValue(String name, Class<T> clazz) {
        T result = XmlElementRefPrism.getValue(memberValues,defaults,name,clazz);
        if(result == null) valid = false;
        return result;
    } 

    private <T> List<T> getArrayValues(String name, final Class<T> clazz) {
        List<T> result = XmlElementRefPrism.getArrayValues(memberValues,defaults,name,clazz);
        if(result == null) valid = false;
        return result;
    }
    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror m :target.getAnnotationMirrors()) {
            CharSequence mfqn = ((TypeElement)m.getAnnotationType().asElement()).getQualifiedName();
            if(fqn.contentEquals(mfqn)) return m;
        }
        return null;
    }
    private static <T> T getValue(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if(av == null) av = defaults.get(name);
        if(av == null) {
            return null;
        }
        if(clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());
        return null;
    }
    private static <T> List<T> getArrayValues(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, final Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if(av == null) av = defaults.get(name);
        if(av == null) {
            return null;
        }
        if(av.getValue() instanceof List) {
            List<T> result = new ArrayList<T>();
            for(AnnotationValue v : getValueAsList(av)) {
                if(clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                } else{
                    return null;
                }
            }
            return result;
        } else {
            return null;
        }
    }
    @SuppressWarnings("unchecked")
    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List<AnnotationValue>)av.getValue();
    }
}
